/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Client;
import org.eclipse.wst.server.core.internal.IClient;
import org.eclipse.wst.server.core.internal.IInstallableRuntime;
import org.eclipse.wst.server.core.internal.ILaunchableAdapter;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.IPublishTask;
import org.eclipse.wst.server.core.internal.IRuntimeLocator;
import org.eclipse.wst.server.core.internal.IServerMonitor;
import org.eclipse.wst.server.core.internal.InstallableRuntime;
import org.eclipse.wst.server.core.internal.InstallableRuntime2;
import org.eclipse.wst.server.core.internal.LaunchableAdapter;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.ModuleArtifactAdapter;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.internal.ModuleType;
import org.eclipse.wst.server.core.internal.ProgressUtil;
import org.eclipse.wst.server.core.internal.ProjectProperties;
import org.eclipse.wst.server.core.internal.PublishController;
import org.eclipse.wst.server.core.internal.PublishTask;
import org.eclipse.wst.server.core.internal.Publisher;
import org.eclipse.wst.server.core.internal.ResourceManager;
import org.eclipse.wst.server.core.internal.RuntimeLocator;
import org.eclipse.wst.server.core.internal.RuntimeType;
import org.eclipse.wst.server.core.internal.ServerMonitor;
import org.eclipse.wst.server.core.internal.ServerMonitorManager;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.internal.XMLMemento;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerPlugin
extends Plugin {
    public static final String PROJECT_PREF_FILE = ".serverPreference";
    public static final String EXCLUDE_SERVER_ADAPTERS = "excludeServerAdapters";
    private static final String EXTENSION_RUNTIME_MODULE_TYPE = "runtimeModuleType";
    private static final String SHUTDOWN_JOB_FAMILY = "org.eclipse.wst.server.core.family";
    protected static final DateFormat df = DateFormat.getDateTimeInstance(3, 3);
    protected static int num = 0;
    private static List<LaunchableAdapter> launchableAdapters;
    private static List<IClient> clients;
    private static List<ModuleFactory> moduleFactories;
    private static ServerPlugin singleton;
    private static List<IPublishTask> publishTasks;
    private static List<PublishController> publishControllers;
    private static List<Publisher> publishers;
    private static List<IServerMonitor> monitors;
    private static List<IRuntimeLocator> runtimeLocators;
    private static List<ModuleArtifactAdapter> moduleArtifactAdapters;
    private static List<IInstallableRuntime> installableRuntimes;
    private static IRegistryChangeListener registryListener;
    public static BundleContext bundleContext;
    private BundleListener bundleListener;
    private static final String TEMP_DATA_FILE = "tmp-data.xml";
    private Map<String, TempDir> tempDirHash;
    public static final String PLUGIN_ID = "org.eclipse.wst.server.core";

    public ServerPlugin() {
        singleton = this;
    }

    public static ServerPlugin getInstance() {
        return singleton;
    }

    public IPath getTempDirectory(String key) {
        return this.getTempDirectory(key, true);
    }

    public IPath getTempDirectory(String key, boolean recycle) {
        if (key == null) {
            return null;
        }
        IPath statePath = ServerPlugin.getInstance().getStateLocation();
        try {
            TempDir dir = this.getTempDirs().get(key);
            if (dir != null) {
                dir.age = 0;
                if (dir.recycle != recycle) {
                    dir.recycle = recycle;
                    this.saveTempDirInfo();
                }
                return statePath.append(dir.path);
            }
        }
        catch (Exception exception) {}
        String path = null;
        File dir = null;
        int count = 0;
        while (dir == null || dir.exists()) {
            path = "tmp" + count;
            dir = statePath.append(path).toFile();
            ++count;
        }
        dir.mkdirs();
        TempDir d = new TempDir();
        d.path = path;
        d.recycle = recycle;
        this.getTempDirs().put(key, d);
        this.saveTempDirInfo();
        return statePath.append(path);
    }

    public void removeTempDirectory(String key) {
        if (key == null) {
            return;
        }
        IPath statePath = ServerPlugin.getInstance().getStateLocation();
        try {
            TempDir dir = this.getTempDirs().get(key);
            if (dir != null) {
                this.getTempDirs().remove(key);
                this.saveTempDirInfo();
                ServerPlugin.deleteDirectory(statePath.append(dir.path).toFile(), null);
            }
        }
        catch (Exception e) {
            Trace.trace(2, "Could not remove temp directory", e);
        }
    }

    private Map<String, TempDir> getTempDirs() {
        if (this.tempDirHash == null) {
            this.loadTempDirInfo();
        }
        return this.tempDirHash;
    }

    private void loadTempDirInfo() {
        Trace.trace(5, "Loading temporary directory information");
        IPath statePath = ServerPlugin.getInstance().getStateLocation();
        String filename = statePath.append(TEMP_DATA_FILE).toOSString();
        this.tempDirHash = new HashMap<String, TempDir>();
        try {
            IMemento memento = XMLMemento.loadMemento(filename);
            IMemento[] children = memento.getChildren("temp-directory");
            int size = children.length;
            int i = 0;
            while (i < size) {
                String key = children[i].getString("key");
                TempDir d = new TempDir();
                d.path = children[i].getString("path");
                d.age = children[i].getInteger("age");
                Boolean recycle = children[i].getBoolean("recycle");
                if (recycle != null) {
                    d.recycle = recycle;
                }
                if (d.recycle) {
                    ++d.age;
                }
                this.tempDirHash.put(key, d);
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(2, "Could not load temporary directory information", e);
        }
    }

    public static void log(IStatus status) {
        ServerPlugin.getInstance().getLog().log(status);
    }

    private void saveTempDirInfo() {
        IPath statePath = ServerPlugin.getInstance().getStateLocation();
        String filename = statePath.append(TEMP_DATA_FILE).toOSString();
        try {
            XMLMemento memento = XMLMemento.createWriteRoot("temp-directories");
            for (String key : this.getTempDirs().keySet()) {
                TempDir d = this.getTempDirs().get(key);
                if (!d.recycle || d.age < 5) {
                    IMemento child = memento.createChild("temp-directory");
                    child.putString("key", key);
                    child.putString("path", d.path);
                    child.putInteger("age", d.age);
                    child.putBoolean("recycle", d.recycle);
                    continue;
                }
                ServerPlugin.deleteDirectory(statePath.append(d.path).toFile(), null);
            }
            memento.saveToFile(filename);
        }
        catch (Exception e) {
            Trace.trace(3, "Could not save temporary directory information", e);
        }
    }

    public void start(BundleContext context) throws Exception {
        Trace.trace(0, "----->----- Server Core plugin startup ----->-----");
        super.start(context);
        bundleContext = context;
        this.bundleListener = new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                String bundleId = event.getBundle().getSymbolicName();
                if (4 == event.getType() && ResourceManager.getInstance().isActiveBundle(bundleId)) {
                    ServerPlugin.this.stopBundle(bundleId);
                }
            }
        };
        context.addBundleListener(this.bundleListener);
        ServerPlugin.getPublishController();
    }

    protected void stopBundle(String bundleId) {
        try {
            class StopJob
            extends Job {
                private final /* synthetic */ String val$bundleId;

                public StopJob(String string) {
                    this.val$bundleId = string;
                    super("Disposing servers");
                }

                public boolean belongsTo(Object family) {
                    return ServerPlugin.SHUTDOWN_JOB_FAMILY.equals(family);
                }

                public IStatus run(IProgressMonitor monitor2) {
                    ResourceManager.getInstance().shutdownBundle(this.val$bundleId);
                    return Status.OK_STATUS;
                }
            }
            StopJob job = new StopJob(bundleId);
            job.setUser(false);
            job.schedule();
        }
        catch (Throwable throwable) {}
    }

    public void stop(BundleContext context) throws Exception {
        Trace.trace(0, "-----<----- Server Core plugin shutdown -----<-----");
        super.stop(context);
        if (registryListener != null) {
            Platform.getExtensionRegistry().removeRegistryChangeListener(registryListener);
        }
        ResourceManager.shutdown();
        ServerMonitorManager.shutdown();
        try {
            Job.getJobManager().join((Object)SHUTDOWN_JOB_FAMILY, null);
        }
        catch (Exception e) {
            Trace.trace(2, "Error waiting for shutdown job", e);
        }
        context.removeBundleListener(this.bundleListener);
    }

    public static void logExtensionFailure(String id, Throwable t) {
        Trace.trace(3, "Missing or failed server extension: " + id + ". Enable tracing for more information");
        Trace.trace(2, "Exception in server delegate", t);
    }

    private static void addAll(List<Object> list, Object[] obj) {
        if (obj == null) {
            return;
        }
        int size = obj.length;
        int i = 0;
        while (i < size) {
            list.add(obj[i]);
            ++i;
        }
    }

    public static boolean isNameInUse(Object element, String name) {
        if (name == null) {
            return true;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        if (element == null || element instanceof IRuntime) {
            ServerPlugin.addAll(list, ServerCore.getRuntimes());
        }
        if (element == null || element instanceof IServerAttributes) {
            ServerPlugin.addAll(list, ServerCore.getServers());
        }
        if (element != null) {
            if (element instanceof IRuntimeWorkingCopy) {
                element = ((IRuntimeWorkingCopy)element).getOriginal();
            }
            if (element instanceof IServerWorkingCopy) {
                element = ((IServerWorkingCopy)element).getOriginal();
            }
            if (list.contains(element)) {
                list.remove(element);
            }
        }
        for (Object e : list) {
            if (e instanceof IServerAttributes && (name.equalsIgnoreCase(((IServerAttributes)e).getName()) || name.equalsIgnoreCase(((IServerAttributes)e).getId()))) {
                return true;
            }
            if (!(e instanceof IRuntime) || !name.equalsIgnoreCase(((IRuntime)e).getName())) continue;
            return true;
        }
        return false;
    }

    public static String[] tokenize(String str, String delim) {
        String[] s;
        if (str == null) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str, delim);
        while (st.hasMoreTokens()) {
            s = st.nextToken();
            if (s == null || s.length() <= 0) continue;
            list.add(s.trim());
        }
        s = new String[list.size()];
        list.toArray(s);
        return s;
    }

    protected static synchronized void loadRuntimeModuleTypes(IRuntimeType runtimeType) {
        IConfigurationElement[] cf;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = cf = registry.getConfigurationElementsFor(PLUGIN_ID, EXTENSION_RUNTIME_MODULE_TYPE);
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                String[] looseModuleRuntimeIds = ServerPlugin.tokenize(ce.getAttribute("runtimeTypes"), ",");
                if (looseModuleRuntimeIds.length < 0) {
                    Trace.trace(7, "  runtimeTypes on extension point definition is empty");
                    return;
                }
                if (ServerPlugin.contains(looseModuleRuntimeIds, runtimeType.getId())) {
                    ((RuntimeType)runtimeType).addModuleType(ce);
                    Trace.trace(7, "  Loaded Runtime supported ModuleType: " + ce.getAttribute("id"));
                }
            }
            catch (Throwable t) {
                Trace.trace(3, "  Could not load Runtime supported ModuleType: " + ce.getAttribute("id"), t);
            }
            ++n2;
        }
    }

    protected static List<IModuleType> getModuleTypes(IConfigurationElement[] elements) {
        ArrayList<IModuleType> list = new ArrayList<IModuleType>();
        if (elements == null) {
            return list;
        }
        int size = elements.length;
        int i = 0;
        while (i < size) {
            String[] types = ServerPlugin.tokenize(elements[i].getAttribute("types"), ",");
            String[] versions = ServerPlugin.tokenize(elements[i].getAttribute("versions"), ",");
            int sizeT = types.length;
            int sizeV = versions.length;
            int j = 0;
            while (j < sizeT) {
                int k = 0;
                while (k < sizeV) {
                    list.add(ModuleType.getModuleType(types[j], versions[k]));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    public static boolean contains(String[] ids, String id) {
        if (id == null || id.length() == 0) {
            return false;
        }
        if (ids == null) {
            return true;
        }
        int size = ids.length;
        int i = 0;
        while (i < size) {
            if (ids[i].endsWith("*") ? id.length() >= ids[i].length() && id.startsWith(ids[i].substring(0, ids[i].length() - 1)) : id.equals(ids[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void deleteDirectory(File dir, IProgressMonitor monitor) {
        try {
            if (!dir.exists() || !dir.isDirectory()) {
                return;
            }
            File[] files = dir.listFiles();
            int size = files.length;
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(NLS.bind((String)Messages.deletingTask, (Object[])new String[]{dir.getAbsolutePath()}), size * 10);
            int i = 0;
            while (i < size) {
                File current = files[i];
                if (current.isFile()) {
                    current.delete();
                    monitor.worked(10);
                } else if (current.isDirectory()) {
                    monitor.subTask(NLS.bind((String)Messages.deletingTask, (Object[])new String[]{current.getAbsolutePath()}));
                    ServerPlugin.deleteDirectory(current, ProgressUtil.getSubMonitorFor(monitor, 10));
                }
                ++i;
            }
            dir.delete();
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace(3, "Error deleting directory " + dir.getAbsolutePath(), e);
        }
    }

    public static ILaunchableAdapter[] getLaunchableAdapters() {
        if (launchableAdapters == null) {
            ServerPlugin.loadLaunchableAdapters();
        }
        ILaunchableAdapter[] la = new ILaunchableAdapter[launchableAdapters.size()];
        launchableAdapters.toArray(la);
        return la;
    }

    public static IClient[] getClients() {
        if (clients == null) {
            ServerPlugin.loadClients();
        }
        IClient[] c = new IClient[clients.size()];
        clients.toArray(c);
        return c;
    }

    private static synchronized void loadLaunchableAdapters() {
        if (launchableAdapters != null) {
            return;
        }
        Trace.trace(7, "->- Loading .launchableAdapters extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "launchableAdapters");
        int size = cf.length;
        ArrayList<LaunchableAdapter> list = new ArrayList<LaunchableAdapter>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new LaunchableAdapter(cf[i]));
                Trace.trace(7, "  Loaded launchableAdapter: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(3, "  Could not load launchableAdapter: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        size = list.size();
        i = 0;
        while (i < size - 1) {
            int j = i + 1;
            while (j < size) {
                LaunchableAdapter a = (LaunchableAdapter)list.get(i);
                LaunchableAdapter b = (LaunchableAdapter)list.get(j);
                if (a.getPriority() < b.getPriority()) {
                    list.set(i, b);
                    list.set(j, a);
                }
                ++j;
            }
            ++i;
        }
        launchableAdapters = list;
        Trace.trace(7, "-<- Done loading .launchableAdapters extension point -<-");
    }

    private static synchronized void loadClients() {
        if (clients != null) {
            return;
        }
        Trace.trace(7, "->- Loading .clients extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "clients");
        int size = cf.length;
        ArrayList<IClient> list = new ArrayList<IClient>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new Client(cf[i]));
                Trace.trace(7, "  Loaded clients: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(3, "  Could not load clients: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        size = list.size();
        i = 0;
        while (i < size - 1) {
            int j = i + 1;
            while (j < size) {
                Client a = (Client)list.get(i);
                Client b = (Client)list.get(j);
                if (a.getPriority() < b.getPriority()) {
                    list.set(i, b);
                    list.set(j, a);
                }
                ++j;
            }
            ++i;
        }
        clients = list;
        Trace.trace(7, "-<- Done loading .clients extension point -<-");
    }

    public static IPublishTask[] getPublishTasks() {
        if (publishTasks == null) {
            ServerPlugin.loadPublishTasks();
        }
        IPublishTask[] st = new IPublishTask[publishTasks.size()];
        publishTasks.toArray(st);
        return st;
    }

    private static synchronized void loadPublishTasks() {
        if (publishTasks != null) {
            return;
        }
        Trace.trace(7, "->- Loading .publishTasks extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "publishTasks");
        int size = cf.length;
        ArrayList<IPublishTask> list = new ArrayList<IPublishTask>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new PublishTask(cf[i]));
                Trace.trace(7, "  Loaded publishTask: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(3, "  Could not load publishTask: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        publishTasks = list;
        Trace.trace(7, "-<- Done loading .publishTasks extension point -<-");
    }

    public static Publisher[] getPublishers() {
        if (publishers == null) {
            ServerPlugin.loadPublishers();
        }
        Publisher[] pub = new Publisher[publishers.size()];
        publishers.toArray(pub);
        return pub;
    }

    public static Publisher findPublisher(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (publishers == null) {
            ServerPlugin.loadPublishers();
        }
        for (Publisher pub : publishers) {
            if (!id.equals(pub.getId())) continue;
            return pub;
        }
        return null;
    }

    private static synchronized void loadPublishers() {
        if (publishers != null) {
            return;
        }
        Trace.trace(7, "->- Loading .publishers extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "publishers");
        int size = cf.length;
        ArrayList<Publisher> list = new ArrayList<Publisher>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new Publisher(cf[i]));
                Trace.trace(7, "  Loaded publisher: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(3, "  Could not load publisher: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        publishers = list;
        Trace.trace(7, "-<- Done loading .publishers extension point -<-");
    }

    public static PublishController[] getPublishController() {
        if (publishers == null) {
            ServerPlugin.loadPublishControllers();
        }
        PublishController[] controllers = new PublishController[publishControllers.size()];
        publishControllers.toArray(controllers);
        return controllers;
    }

    private static synchronized void loadPublishControllers() {
        if (publishControllers != null) {
            return;
        }
        Trace.trace(7, "->- Loading .publishController extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "publishController");
        int size = cf.length;
        ArrayList<PublishController> list = new ArrayList<PublishController>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new PublishController(cf[i]));
                Trace.trace(7, "  Loaded .publishController: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(3, "  Could not load .publishController: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        publishControllers = list;
        Trace.trace(7, "-<- Done loading .publishController extension point -<-");
    }

    public static ModuleFactory[] getModuleFactories() {
        if (moduleFactories == null) {
            ServerPlugin.loadModuleFactories();
        }
        ModuleFactory[] mf = new ModuleFactory[moduleFactories.size()];
        moduleFactories.toArray(mf);
        return mf;
    }

    public static ModuleFactory findModuleFactory(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (moduleFactories == null) {
            ServerPlugin.loadModuleFactories();
        }
        for (ModuleFactory factory : moduleFactories) {
            if (!id.equals(factory.getId())) continue;
            return factory;
        }
        return null;
    }

    public static ILaunchableAdapter findLaunchableAdapter(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (launchableAdapters == null) {
            ServerPlugin.loadLaunchableAdapters();
        }
        for (ILaunchableAdapter iLaunchableAdapter : launchableAdapters) {
            if (!id.equals(iLaunchableAdapter.getId())) continue;
            return iLaunchableAdapter;
        }
        return null;
    }

    public static IClient findClient(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (clients == null) {
            ServerPlugin.loadClients();
        }
        for (IClient client : clients) {
            if (!id.equals(client.getId())) continue;
            return client;
        }
        return null;
    }

    private static synchronized void loadModuleFactories() {
        if (moduleFactories != null) {
            return;
        }
        Trace.trace(7, "->- Loading .moduleFactories extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "moduleFactories");
        int size = cf.length;
        ArrayList<ModuleFactory> list = new ArrayList<ModuleFactory>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new ModuleFactory(cf[i]));
                Trace.trace(7, "  Loaded moduleFactories: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(3, "  Could not load moduleFactories: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        size = list.size();
        i = 0;
        while (i < size - 1) {
            int j = i + 1;
            while (j < size) {
                ModuleFactory a = (ModuleFactory)list.get(i);
                ModuleFactory b = (ModuleFactory)list.get(j);
                if (a.getOrder() > b.getOrder()) {
                    list.set(i, b);
                    list.set(j, a);
                }
                ++j;
            }
            ++i;
        }
        moduleFactories = list;
        Trace.trace(7, "-<- Done loading .moduleFactories extension point -<-");
    }

    public static IServerMonitor[] getServerMonitors() {
        if (monitors == null) {
            ServerPlugin.loadServerMonitors();
        }
        IServerMonitor[] sm = new IServerMonitor[monitors.size()];
        monitors.toArray(sm);
        return sm;
    }

    private static synchronized void loadServerMonitors() {
        if (monitors != null) {
            return;
        }
        Trace.trace(7, "->- Loading .serverMonitors extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "internalServerMonitors");
        int size = cf.length;
        ArrayList<IServerMonitor> list = new ArrayList<IServerMonitor>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new ServerMonitor(cf[i]));
                Trace.trace(7, "  Loaded serverMonitor: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(3, "  Could not load serverMonitor: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        monitors = list;
        Trace.trace(7, "-<- Done loading .serverMonitors extension point -<-");
    }

    public static IRuntimeLocator[] getRuntimeLocators() {
        if (runtimeLocators == null) {
            ServerPlugin.loadRuntimeLocators();
        }
        IRuntimeLocator[] rl = new IRuntimeLocator[runtimeLocators.size()];
        runtimeLocators.toArray(rl);
        return rl;
    }

    private static synchronized void loadRuntimeLocators() {
        if (runtimeLocators != null) {
            return;
        }
        Trace.trace(7, "->- Loading .runtimeLocators extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "runtimeLocators");
        int size = cf.length;
        ArrayList<IRuntimeLocator> list = new ArrayList<IRuntimeLocator>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new RuntimeLocator(cf[i]));
                Trace.trace(7, "  Loaded runtimeLocator: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(3, "  Could not load runtimeLocator: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        runtimeLocators = list;
        Trace.trace(7, "-<- Done loading .runtimeLocators extension point -<-");
    }

    protected static ModuleArtifactAdapter[] getModuleArtifactAdapters() {
        if (moduleArtifactAdapters == null) {
            ServerPlugin.loadModuleArtifactAdapters();
        }
        ModuleArtifactAdapter[] moa = new ModuleArtifactAdapter[moduleArtifactAdapters.size()];
        moduleArtifactAdapters.toArray(moa);
        return moa;
    }

    private static synchronized void loadModuleArtifactAdapters() {
        if (moduleArtifactAdapters != null) {
            return;
        }
        Trace.trace(7, "->- Loading .moduleArtifactAdapters extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "moduleArtifactAdapters");
        int size = cf.length;
        ArrayList<ModuleArtifactAdapter> list = new ArrayList<ModuleArtifactAdapter>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new ModuleArtifactAdapter(cf[i]));
                Trace.trace(7, "  Loaded moduleArtifactAdapter: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(3, "  Could not load moduleArtifactAdapter: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        size = list.size();
        i = 0;
        while (i < size - 1) {
            int j = i + 1;
            while (j < size) {
                ModuleArtifactAdapter a = (ModuleArtifactAdapter)list.get(i);
                ModuleArtifactAdapter b = (ModuleArtifactAdapter)list.get(j);
                if (a.getPriority() < b.getPriority()) {
                    list.set(i, b);
                    list.set(j, a);
                }
                ++j;
            }
            ++i;
        }
        moduleArtifactAdapters = list;
        Trace.trace(7, "-<- Done loading .moduleArtifactAdapters extension point -<-");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasModuleArtifact(Object obj) {
        Trace.trace(5, "ServerPlugin.hasModuleArtifact() " + obj);
        ModuleArtifactAdapter[] adapters = ServerPlugin.getModuleArtifactAdapters();
        if (adapters != null) {
            int size = adapters.length;
            int i = 0;
            while (i < size) {
                try {
                    if (adapters[i].isEnabled(obj)) {
                        Trace.trace(4, "ServerPlugin.hasModuleArtifact() - " + adapters[i].getId());
                        if (!adapters[i].isDelegateLoaded()) {
                            Trace.trace(4, "Enabled");
                            return true;
                        }
                        long time = System.currentTimeMillis();
                        IModuleArtifact[] ma = adapters[i].getModuleArtifacts(obj);
                        Trace.trace(4, "Deep enabled time: " + (System.currentTimeMillis() - time));
                        if (ma != null) {
                            Trace.trace(4, "Deep enabled");
                            return true;
                        }
                        Trace.trace(4, "Not enabled");
                    }
                }
                catch (CoreException ce) {
                    Trace.trace(2, "Could not use moduleArtifactAdapter", ce);
                }
                ++i;
            }
        }
        return false;
    }

    public static IModuleArtifact[] getModuleArtifacts(Object obj) {
        Trace.trace(5, "ServerPlugin.getModuleArtifact() " + obj);
        ModuleArtifactAdapter[] adapters = ServerPlugin.getModuleArtifactAdapters();
        if (adapters != null) {
            int size = adapters.length;
            int i = 0;
            while (i < size) {
                try {
                    IModuleArtifact[] ma;
                    if (adapters[i].isEnabled(obj) && (ma = adapters[i].getModuleArtifacts(obj)) != null) {
                        return ma;
                    }
                }
                catch (Exception e) {
                    Trace.trace(2, "Could not use moduleArtifactAdapter " + adapters[i], e);
                }
                ++i;
            }
        }
        return null;
    }

    public static IInstallableRuntime[] getInstallableRuntimes() {
        ServerPlugin.loadInstallableRuntimes();
        IInstallableRuntime[] ir = new IInstallableRuntime[installableRuntimes.size()];
        installableRuntimes.toArray(ir);
        return ir;
    }

    public static IInstallableRuntime findInstallableRuntime(String runtimeTypeId) {
        if (runtimeTypeId == null) {
            throw new IllegalArgumentException();
        }
        ServerPlugin.loadInstallableRuntimes();
        for (IInstallableRuntime runtime : installableRuntimes) {
            if (!runtime.getId().equals(runtimeTypeId)) continue;
            return runtime;
        }
        return null;
    }

    private static synchronized void loadInstallableRuntimes() {
        Trace.trace(7, "->- Loading .installableRuntimes extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "installableRuntimes");
        int size = cf.length;
        ArrayList<IInstallableRuntime> list = new ArrayList<IInstallableRuntime>(size);
        int i = 0;
        while (i < size) {
            try {
                if ("runtime".equals(cf[i].getName())) {
                    String os = cf[i].getAttribute("os");
                    if (os == null || os.contains(Platform.getOS())) {
                        list.add(new InstallableRuntime2(cf[i]));
                    }
                } else {
                    list.add(new InstallableRuntime(cf[i]));
                }
                Trace.trace(7, "  Loaded installableRuntime: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(3, "  Could not load installableRuntime: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        installableRuntimes = list;
        Trace.trace(7, "-<- Done loading .installableRuntimes extension point -<-");
    }

    public static void setRegistryListener(IRegistryChangeListener listener) {
        registryListener = listener;
    }

    public static ProjectProperties getProjectProperties(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException();
        }
        return new ProjectProperties(project);
    }

    public static boolean matches(String a, String b) {
        if (a == null || b == null || a.equals(b) || "*".equals(a) || "*".equals(b) || a.endsWith(".*") && b.startsWith(a.substring(0, a.length() - 1)) || b.endsWith(".*") && a.startsWith(b.substring(0, b.length() - 1))) {
            return true;
        }
        if (a.startsWith(b) || b.startsWith(a)) {
            Trace.trace(2, "Invalid matching rules used: " + a + "/" + b);
            return true;
        }
        return false;
    }

    public static String[] getExcludedServerAdapters() {
        return ServerPlugin.tokenize(ServerPlugin.getProperty(EXCLUDE_SERVER_ADAPTERS), ",");
    }

    private static String getProperty(String key) {
        if (key == null) {
            return null;
        }
        String value = null;
        if (Platform.getProduct() != null) {
            return Platform.getProduct().getProperty(key);
        }
        return value;
    }

    class TempDir {
        String path;
        int age;
        boolean recycle = true;

        TempDir() {
        }
    }
}

