/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.http.ui.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.http.core.internal.HttpServer;
import org.eclipse.wst.server.http.core.internal.command.ModifyPortCommand;
import org.eclipse.wst.server.http.core.internal.command.ModifyPublishingCommand;
import org.eclipse.wst.server.http.core.internal.command.ModifyURLPrefixCommand;
import org.eclipse.wst.server.http.ui.internal.Messages;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class HttpSection
extends ServerEditorSection {
    protected HttpServer httpServer;
    protected boolean updating;
    protected Text urlPrefixText;
    protected Button publishCheckBox;
    protected Spinner portSpinner;
    protected PropertyChangeListener listener;

    protected void addChangeListener() {
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Boolean b;
                if (HttpSection.this.updating) {
                    return;
                }
                HttpSection.this.updating = true;
                if ("port".equals(event.getPropertyName())) {
                    Integer i = (Integer)event.getNewValue();
                    HttpSection.this.portSpinner.setSelection(i.intValue());
                } else if ("urlPrefix".equals(event.getPropertyName())) {
                    String s = (String)event.getNewValue();
                    if (s != null) {
                        HttpSection.this.urlPrefixText.setText(s);
                    }
                } else if ("isPublishing".equals(event.getPropertyName()) && (b = (Boolean)event.getNewValue()) != null) {
                    HttpSection.this.publishCheckBox.setSelection(b.booleanValue());
                }
                HttpSection.this.updating = false;
            }
        };
        this.server.addPropertyChangeListener(this.listener);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 384);
        section.setText(Messages.editorSectionTitle);
        section.setDescription(Messages.editorSectionDescription);
        section.setLayoutData((Object)new GridData(272));
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        Label label = this.createLabel(toolkit, composite, Messages.editorURLPrefix);
        GridData data = new GridData(256);
        label.setLayoutData((Object)data);
        this.urlPrefixText = toolkit.createText(composite, "");
        data = new GridData(768);
        this.urlPrefixText.setLayoutData((Object)data);
        this.urlPrefixText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (HttpSection.this.updating) {
                    return;
                }
                HttpSection.this.updating = true;
                HttpSection.this.execute((IUndoableOperation)new ModifyURLPrefixCommand(HttpSection.this.httpServer, HttpSection.this.urlPrefixText.getText()));
                HttpSection.this.updating = false;
            }
        });
        this.createLabel(toolkit, composite, Messages.editorPort);
        this.portSpinner = new Spinner(composite, 2048);
        this.portSpinner.setMinimum(0);
        this.portSpinner.setMinimum(999999);
        data = new GridData(768);
        this.portSpinner.setLayoutData((Object)data);
        this.portSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (HttpSection.this.updating) {
                    return;
                }
                HttpSection.this.updating = true;
                HttpSection.this.execute((IUndoableOperation)new ModifyPortCommand(HttpSection.this.httpServer, HttpSection.this.portSpinner.getSelection()));
                HttpSection.this.updating = false;
            }
        });
        this.publishCheckBox = new Button(composite, 32);
        this.publishCheckBox.setText(Messages.editorShouldPublish);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.publishCheckBox.setLayoutData((Object)data);
        this.publishCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Button b = (Button)se.getSource();
                if (HttpSection.this.updating) {
                    return;
                }
                HttpSection.this.updating = true;
                HttpSection.this.execute((IUndoableOperation)new ModifyPublishingCommand(HttpSection.this.httpServer, b.getSelection()));
                HttpSection.this.updating = false;
            }
        });
        this.initialize();
    }

    protected Label createLabel(FormToolkit toolkit, Composite parent, String text) {
        Label label = toolkit.createLabel(parent, text);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        return label;
    }

    public void dispose() {
        if (this.server != null) {
            this.server.removePropertyChangeListener(this.listener);
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.httpServer = (HttpServer)this.server.loadAdapter(HttpServer.class, null);
        this.addChangeListener();
        this.initialize();
    }

    protected void initialize() {
        if (this.urlPrefixText == null) {
            return;
        }
        this.updating = true;
        String urlPrefix = this.httpServer.getURLPrefix();
        if (urlPrefix != null) {
            this.urlPrefixText.setText(urlPrefix);
        }
        this.urlPrefixText.setEnabled(!this.readOnly);
        this.portSpinner.setSelection(this.httpServer.getPort());
        this.portSpinner.setEnabled(!this.readOnly);
        this.publishCheckBox.setSelection(this.httpServer.isPublishing());
        this.publishCheckBox.setEnabled(!this.readOnly);
        this.updating = false;
    }
}

