/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.internal.modulecore;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.common.internal.modulecore.IClasspathDependencyProvider;
import org.eclipse.jst.common.internal.modulecore.util.ManifestUtilities;
import org.eclipse.wst.common.componentcore.internal.flat.AbstractFlattenParticipant;
import org.eclipse.wst.common.componentcore.internal.flat.FlatFile;
import org.eclipse.wst.common.componentcore.internal.flat.FlatVirtualComponent;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFolder;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatResource;
import org.eclipse.wst.common.componentcore.internal.flat.VirtualComponentFlattenUtility;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceManifestExportParticipant
extends AbstractFlattenParticipant {
    private IPath manifestPath;

    public ReplaceManifestExportParticipant(IPath manifestPath) {
        this.manifestPath = manifestPath;
    }

    public void finalize(IVirtualComponent component, FlatVirtualComponent.FlatComponentTaskModel dataModel, List<IFlatResource> resources) {
        this.forceUpdate(component, dataModel, resources);
    }

    public void forceUpdate(IVirtualComponent component, FlatVirtualComponent.FlatComponentTaskModel dataModel, List<IFlatResource> resources) {
        IFlatFolder parent;
        List<String> javaClasspathURIs = ReplaceManifestExportParticipant.getClasspathURIs(component);
        if (!javaClasspathURIs.isEmpty() && (parent = (IFlatFolder)VirtualComponentFlattenUtility.getExistingModuleResource(resources, (IPath)this.manifestPath.removeLastSegments(1))) != null) {
            IFlatResource[] children = parent.members();
            IFile original = null;
            int originalIndex = 0;
            int i = 0;
            while (i < children.length) {
                if (children[i].getName().equals(this.manifestPath.lastSegment())) {
                    original = (IFile)children[i].getAdapter(IFile.class);
                    originalIndex = i;
                    File newManifest = this.getNewManifest(component.getProject(), original, javaClasspathURIs);
                    FlatFile newManifestExportable = new FlatFile(newManifest, newManifest.getName(), this.manifestPath.removeLastSegments(1));
                    children[originalIndex] = newManifestExportable;
                    parent.setMembers(children);
                    return;
                }
                ++i;
            }
        }
    }

    public File getNewManifest(IProject project, IFile originalManifest, List<String> javaClasspathURIs) {
        File parent;
        IPath workingLocation = project.getWorkingLocation("org.eclipse.jst.common.frameworks");
        IPath tempManifestPath = workingLocation.append(this.manifestPath);
        File tempFile = tempManifestPath.toFile();
        if (!(tempFile.exists() || (parent = tempFile.getParentFile()).exists() || parent.mkdirs())) {
            return originalManifest != null ? originalManifest.getLocation().toFile() : null;
        }
        try {
            ManifestUtilities.updateManifestClasspath(originalManifest, javaClasspathURIs, tempFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
        return tempFile.exists() ? tempFile : (originalManifest != null ? originalManifest.getLocation().toFile() : null);
    }

    public static List<String> getClasspathURIs(IVirtualComponent component) {
        IClasspathDependencyProvider j2eeComp;
        IVirtualReference[] refs;
        ArrayList<String> uris = new ArrayList<String>();
        uris = new ArrayList();
        if (component instanceof IClasspathDependencyProvider && (refs = (j2eeComp = (IClasspathDependencyProvider)component).getJavaClasspathReferences()) != null) {
            int i = 0;
            while (i < refs.length) {
                if (refs[i].getRuntimePath().toString().equals("../")) {
                    uris.add(refs[i].getArchiveName());
                }
                ++i;
            }
        }
        return uris;
    }
}

