/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.flatfile.CommonConstants;
import org.eclipse.datatools.connectivity.oda.flatfile.FlatFileQuery;
import org.eclipse.datatools.connectivity.oda.flatfile.ResultSetMetaDataHelper;
import org.eclipse.datatools.connectivity.oda.flatfile.i18n.Messages;

public class FlatFileDataReader {
    private String homeDir;
    private String currentTableName;
    private char delimiter;
    private boolean hasColumnNames = true;
    private boolean hasTypeLine = true;
    private String charSet;
    private FlatFileQuery.FlatFileBufferedReader flatFileBufferedReader = null;
    private IResultSetMetaData rsmd;
    private ResultSetMetaDataHelper rsmdHelper;
    private int statementMaxRows = 0;
    private int resultSetMaxRows = 0;
    private int maxRowsToRead = 0;
    private String[] originalColumnNames;
    private boolean isFirstTimeToReadSourceData = true;
    private boolean isFirstTimeToCallReadLine = true;
    private int fetchCounter = 0;
    private int[] selectColumIndexes;
    private List nextDataLine;
    public static final int MAX_ROWS_PER_FETCH = 20000;

    public FlatFileDataReader(Properties connProperties, String currentTableName, int statementMaxRows, IResultSetMetaData rsmd, ResultSetMetaDataHelper rsmdHelper) throws OdaException {
        this.rsmd = rsmd;
        this.rsmdHelper = rsmdHelper;
        this.statementMaxRows = statementMaxRows;
        this.currentTableName = currentTableName;
        Properties properties = this.getCopyOfConnectionProperties(connProperties);
        this.populateHomeDir(properties);
        this.populateDelimiter(properties);
        this.populateCharSet(properties);
        this.populateHasColumnNames(properties);
        this.populateHasTypeLine(properties);
    }

    private Properties getCopyOfConnectionProperties(Properties connProperties) {
        Properties copyConnProperites = new Properties();
        copyConnProperites.setProperty("CHARSET", connProperties.getProperty("CHARSET"));
        copyConnProperites.setProperty("DELIMTYPE", connProperties.getProperty("DELIMTYPE"));
        copyConnProperites.setProperty("HOME", connProperties.getProperty("HOME"));
        copyConnProperites.setProperty("INCLCOLUMNNAME", connProperties.getProperty("INCLCOLUMNNAME"));
        copyConnProperites.setProperty("INCLTYPELINE", connProperties.getProperty("INCLTYPELINE"));
        return copyConnProperites;
    }

    private void initNameIndexMap() throws OdaException {
        assert (this.originalColumnNames != null);
        HashMap<String, Integer> originalColumnNameIndexMap = new HashMap<String, Integer>();
        int i = 0;
        while (i < this.originalColumnNames.length) {
            originalColumnNameIndexMap.put(this.originalColumnNames[i].trim().toUpperCase(), new Integer(i));
            ++i;
        }
        this.selectColumIndexes = new int[this.rsmd.getColumnCount()];
        i = 0;
        while (i < this.rsmd.getColumnCount()) {
            this.selectColumIndexes[i] = this.findIndex(this.rsmdHelper.getOriginalColumnName(this.rsmd.getColumnName(i + 1)), originalColumnNameIndexMap);
            ++i;
        }
    }

    private void populateDelimiter(Properties connProperties) throws OdaException {
        this.delimiter = CommonConstants.getDelimiterValue(connProperties.getProperty("DELIMTYPE") != null ? connProperties.getProperty("DELIMTYPE") : "COMMA").charAt(0);
    }

    private void populateHomeDir(Properties connProperties) throws OdaException {
        this.homeDir = connProperties.getProperty("HOME");
        File file = new File(this.homeDir);
        if (!file.exists()) {
            throw new OdaException(String.valueOf(Messages.getString("connection_CANNOT_OPEN_FLAT_FILE_DB_DIR")) + this.homeDir);
        }
    }

    private void populateCharSet(Properties connProperties) {
        this.charSet = connProperties.getProperty("CHARSET");
    }

    private void populateHasColumnNames(Properties connProperties) {
        this.hasColumnNames = !connProperties.getProperty("INCLCOLUMNNAME").equalsIgnoreCase("NO");
    }

    private void populateHasTypeLine(Properties connProperties) {
        this.hasTypeLine = !connProperties.getProperty("INCLTYPELINE").equalsIgnoreCase("NO");
    }

    public String[][] getSourceData() throws OdaException {
        this.createBufferedReader();
        List v = this.fetchQueriedDataFromFileToList();
        return this.copyDataFromListToTwoDimensionArray(v);
    }

    public List readLine() throws OdaException, IOException {
        if (this.isFirstTimeToCallReadLine) {
            this.createBufferedReader();
            this.isFirstTimeToCallReadLine = false;
        }
        return this.flatFileBufferedReader.readLine();
    }

    private void createBufferedReader() throws OdaException {
        try {
            if (this.flatFileBufferedReader == null) {
                String dataFilePath = this.findDataFileAbsolutePath();
                if (this.charSet == null || this.charSet.trim().length() == 0) {
                    this.examCharset(dataFilePath);
                }
                this.flatFileBufferedReader = new FlatFileQuery.FlatFileBufferedReader(new FileInputStream(dataFilePath), this.charSet, this.delimiter);
            }
        }
        catch (IOException e) {
            throw new OdaException(e.getMessage());
        }
    }

    public int getMaxRowsToRead(int resultSetMaxRows) {
        this.resultSetMaxRows = resultSetMaxRows;
        this.maxRowsToRead = this.statementMaxRows != 0 && this.statementMaxRows < this.resultSetMaxRows || this.resultSetMaxRows == 0 ? this.statementMaxRows : this.resultSetMaxRows;
        return this.maxRowsToRead;
    }

    public void clearBufferedReader() {
        try {
            if (this.flatFileBufferedReader != null) {
                this.flatFileBufferedReader.close();
            }
        }
        catch (IOException iOException) {}
        this.flatFileBufferedReader = null;
    }

    public void finalize() {
        this.clearBufferedReader();
    }

    private void examCharset(String filepath) throws OdaException, IOException {
        if (this.charSet != null && this.charSet.length() > 0) {
            return;
        }
        FileInputStream fis = new FileInputStream(filepath);
        byte[] byteMarker = new byte[2];
        fis.read(byteMarker);
        this.charSet = byteMarker[0] == -1 && byteMarker[1] == -2 ? "UTF-16LE" : (byteMarker[0] == -2 && byteMarker[1] == -1 ? "UTF-16BE" : "UTF-8");
        fis.close();
    }

    public int getColumnCount() throws OdaException {
        int count;
        try {
            List columnLine;
            String dataFilePath = this.findDataFileAbsolutePath();
            this.examCharset(dataFilePath);
            FileInputStream fis = new FileInputStream(dataFilePath);
            FlatFileQuery.FlatFileBufferedReader br = new FlatFileQuery.FlatFileBufferedReader(fis, this.charSet, this.delimiter);
            while (FlatFileDataReader.isEmptyRow(columnLine = br.readLine())) {
            }
            count = columnLine.size();
            br.close();
            fis.close();
        }
        catch (IOException iOException) {
            throw new OdaException(String.valueOf(Messages.getString("query_IO_EXCEPTION")) + this.findDataFileAbsolutePath());
        }
        return count;
    }

    public String findDataFileAbsolutePath() throws OdaException {
        File file = new File(String.valueOf(this.homeDir) + File.separator + this.currentTableName.trim());
        if (!file.exists()) {
            throw new OdaException(String.valueOf(Messages.getString("query_invalidTableName")) + this.homeDir + File.separator + this.currentTableName);
        }
        return file.getAbsolutePath();
    }

    public static boolean isEmptyRow(List line) throws OdaException {
        if (line == null) {
            throw new OdaException(Messages.getString("query_INVALID_FLAT_FILE"));
        }
        return line.isEmpty() || line.size() == 1 && line.get(0).equals("");
    }

    private List fetchQueriedDataFromFileToList() throws OdaException {
        ArrayList<String[]> result = new ArrayList<String[]>();
        try {
            if (this.isFirstTimeToReadSourceData) {
                if (this.hasColumnNames) {
                    List columeNameLine;
                    while (FlatFileDataReader.isEmptyRow(columeNameLine = this.flatFileBufferedReader.readLine())) {
                    }
                    this.originalColumnNames = this.getColumnNameArray(columeNameLine);
                    this.initNameIndexMap();
                }
                if (this.hasTypeLine) {
                    while (FlatFileDataReader.isEmptyRow(this.flatFileBufferedReader.readLine())) {
                    }
                }
                if (!this.hasColumnNames) {
                    while (FlatFileDataReader.isEmptyRow(this.nextDataLine = this.flatFileBufferedReader.readLine())) {
                    }
                    this.originalColumnNames = this.createTempColumnNames(this.nextDataLine);
                    this.initNameIndexMap();
                } else {
                    this.nextDataLine = this.flatFileBufferedReader.readLine();
                }
                this.isFirstTimeToReadSourceData = false;
            }
            int counterLimitPerFetch = this.fetchCounter + 20000;
            while ((this.maxRowsToRead <= 0 || this.fetchCounter < this.maxRowsToRead) && this.fetchCounter < counterLimitPerFetch && this.nextDataLine != null) {
                if (!FlatFileDataReader.isEmptyRow(this.nextDataLine)) {
                    ++this.fetchCounter;
                    result.add(this.fetchQueriedDataFromRow(this.nextDataLine));
                }
                this.nextDataLine = this.flatFileBufferedReader.readLine();
            }
            return result;
        }
        catch (IOException e) {
            throw new OdaException(e.getMessage());
        }
    }

    public String[] getColumnNameArray(List line) throws OdaException {
        if (line == null) {
            throw new OdaException(Messages.getString("common_CANNOT_FIND_COLUMN"));
        }
        return FlatFileDataReader.getStringArrayFromList(line);
    }

    public static String[] getStringArrayFromList(List list) {
        String[] array = null;
        if (list != null) {
            array = new String[list.size()];
            int i = 0;
            while (i < list.size()) {
                array[i] = (String)list.get(i);
                ++i;
            }
        }
        return array;
    }

    private String[][] copyDataFromListToTwoDimensionArray(List v) throws OdaException {
        String[][] rowSet = new String[v.size()][this.rsmd.getColumnCount()];
        int i = 0;
        while (i < v.size()) {
            String[] temp = (String[])v.get(i);
            int j = 0;
            while (j < temp.length) {
                if (temp[j] == null) {
                    throw new OdaException(Messages.getString("data_read_error"));
                }
                rowSet[i][j] = temp[j].trim();
                ++j;
            }
            ++i;
        }
        return rowSet;
    }

    private String[] createTempColumnNames(List aRow) throws OdaException {
        String[] tempColumnNames = new String[aRow.size()];
        int i = 0;
        while (i < aRow.size()) {
            tempColumnNames[i] = "COLUMN_" + (i + 1);
            ++i;
        }
        return tempColumnNames;
    }

    private String[] fetchQueriedDataFromRow(List aRow) throws OdaException {
        String[] sArray = new String[this.rsmd.getColumnCount()];
        int i = 0;
        while (i < sArray.length) {
            int location = this.selectColumIndexes[i];
            if (location != -1) {
                if (location >= aRow.size()) {
                    throw new OdaException(Messages.getString("query_INVALID_FLAT_FILE"));
                }
                sArray[i] = aRow.get(location).toString();
            }
            ++i;
        }
        return sArray;
    }

    private int findIndex(String value, HashMap originalColumnNameIndexMap) {
        Integer index = (Integer)originalColumnNameIndexMap.get(value.trim().toUpperCase());
        if (index == null) {
            return -1;
        }
        return index;
    }
}

