/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.discovery.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.discovery.util.PatternFilter;
import org.eclipse.equinox.internal.p2.ui.discovery.util.TextSearchControl;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.Messages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.progress.WorkbenchJob;

public abstract class FilteredViewer {
    private boolean automaticFind;
    private Label clearFilterTextControl;
    private Composite container;
    TextSearchControl filterText;
    private int minimumHeight;
    String previousFilterText = "";
    WorkbenchJob refreshJob;
    private long refreshJobDelay = 200L;
    private PatternFilter searchFilter;
    protected StructuredViewer viewer;
    private Composite header;

    public FilteredViewer() {
        this.setAutomaticFind(true);
    }

    void clearFilterText() {
        this.filterText.getTextControl().setText("");
        this.filterTextChanged();
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(this.container);
        this.container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FilteredViewer.this.refreshJob != null) {
                    FilteredViewer.this.refreshJob.cancel();
                }
            }
        });
        this.doCreateHeader();
        this.viewer = this.doCreateViewer(this.container);
        this.searchFilter = this.doCreateFilter();
        this.viewer.addFilter((ViewerFilter)this.searchFilter);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, this.minimumHeight).applyTo(this.viewer.getControl());
    }

    protected PatternFilter doCreateFilter() {
        return new PatternFilter(){

            protected boolean isParentMatch(Viewer viewer, Object element) {
                return false;
            }
        };
    }

    private void doCreateFindControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.ConnectorDiscoveryWizardMainPage_filterLabel);
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)label);
        this.filterText = new TextSearchControl(parent, this.automaticFind);
        if (this.automaticFind) {
            this.filterText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FilteredViewer.this.filterTextChanged();
                }
            });
        } else {
            this.filterText.getTextControl().addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 4) {
                        e.doit = false;
                        FilteredViewer.this.filterTextChanged();
                    }
                }
            });
        }
        this.filterText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.detail == 256) {
                    FilteredViewer.this.clearFilterText();
                } else {
                    FilteredViewer.this.filterTextChanged();
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.filterText);
    }

    private void doCreateHeader() {
        this.header = new Composite(this.container, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.header);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.header);
        this.doCreateFindControl(this.header);
        this.doCreateHeaderControls(this.header);
        GridLayoutFactory.fillDefaults().numColumns(this.header.getChildren().length).applyTo(this.header);
    }

    protected void doCreateHeaderControls(Composite parent) {
    }

    public void setHeaderVisible(boolean visible) {
        if (this.header != null && visible != this.header.getVisible()) {
            this.header.setVisible(visible);
            GridData headerLayout = (GridData)this.header.getLayoutData();
            headerLayout.exclude = !visible;
            this.container.layout(true, true);
        }
    }

    public boolean isHeaderVisible() {
        return this.header != null && this.header.getVisible();
    }

    protected WorkbenchJob doCreateRefreshJob() {
        return new WorkbenchJob("filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (FilteredViewer.this.filterText.isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                String text = FilteredViewer.this.filterText.getTextControl().getText();
                if (!FilteredViewer.this.previousFilterText.equals(text = text.trim())) {
                    FilteredViewer.this.previousFilterText = text;
                    FilteredViewer.this.doFind(text);
                }
                return Status.OK_STATUS;
            }
        };
    }

    protected abstract StructuredViewer doCreateViewer(Composite var1);

    protected void doFind(String text) {
        this.searchFilter.setPattern(text);
        if (this.clearFilterTextControl != null) {
            this.clearFilterTextControl.setVisible(text != null && text.length() != 0);
        }
        this.viewer.refresh(true);
    }

    protected void filterTextChanged() {
        if (this.refreshJob == null) {
            this.refreshJob = this.doCreateRefreshJob();
        } else {
            this.refreshJob.cancel();
        }
        this.refreshJob.schedule(this.refreshJobDelay);
    }

    protected String getFilterText() {
        return this.filterText == null ? null : this.filterText.getTextControl().getText();
    }

    public Control getControl() {
        return this.container;
    }

    public int getMinimumHeight() {
        return this.minimumHeight;
    }

    protected long getRefreshJobDelay() {
        return this.refreshJobDelay;
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    public void setMinimumHeight(int minimumHeight) {
        this.minimumHeight = minimumHeight;
        if (this.viewer != null) {
            GridDataFactory.fillDefaults().grab(true, true).hint(-1, minimumHeight).applyTo(this.viewer.getControl());
        }
    }

    protected void setRefreshJobDelay(long refreshJobDelay) {
        this.refreshJobDelay = refreshJobDelay;
    }

    public final void setAutomaticFind(boolean automaticFind) {
        if (this.filterText != null) {
            throw new IllegalStateException("setAutomaticFind() needs be invoked before controls are created");
        }
        this.automaticFind = automaticFind;
    }

    public final boolean isAutomaticFind() {
        return this.automaticFind;
    }
}

