/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.script;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Scriptable;

public class JSMethodRunner {
    private Scriptable scope;
    private ScriptContext cx;
    private static final String METHOD_NAME_PREFIX = "__bm_";

    public JSMethodRunner(ScriptContext cx, Scriptable scope, String scopeName) {
        this.scope = scope;
        this.cx = cx;
    }

    public Object runScript(String methodName, String script) throws BirtException {
        if (!this.scope.has(methodName = METHOD_NAME_PREFIX + methodName, this.scope)) {
            String scriptText = "function " + methodName + "() {\n" + script + "\n} ";
            ScriptEvalUtil.evaluateJSAsExpr(this.cx, this.scope, scriptText, ScriptExpression.defaultID, 1);
        }
        String callScriptText = String.valueOf(methodName) + "()";
        Object result = ScriptEvalUtil.evaluateJSAsExpr(this.cx, this.scope, callScriptText, ScriptExpression.defaultID, 1);
        return result;
    }
}

