/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import java.io.IOException;
import java.util.Map;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.api.ICubeCursor;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.cursor.MergedCubeCursor;
import org.eclipse.birt.data.engine.olap.data.api.CubeQueryExecutorHelper;
import org.eclipse.birt.data.engine.olap.data.api.cube.DocManagerMap;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.data.document.CubeRADocumentManagerFactory;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.NamingUtil;
import org.eclipse.birt.data.engine.olap.impl.query.CubeCursorImpl;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryExecutor;
import org.eclipse.birt.data.engine.olap.impl.query.DrillQueryHelper;
import org.eclipse.birt.data.engine.olap.impl.query.PreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.BirtDimensionView;
import org.eclipse.birt.data.engine.olap.query.view.BirtEdgeView;
import org.eclipse.birt.data.engine.olap.script.JSLevelAccessor;
import org.eclipse.birt.data.engine.olap.script.JSMeasureAccessor;
import org.mozilla.javascript.Scriptable;

public class CubeQueryResults
implements ICubeQueryResults {
    protected ICubeQueryDefinition cubeQueryDefinition;
    private Scriptable scope;
    protected DataEngineContext context;
    protected DataEngineSession session;
    private String queryResultsId;
    protected Map appContext;
    private StopSign stopSign;
    private IBaseQueryResults outResults;
    protected ICubeCursor cubeCursor;
    private String name;
    private PreparedCubeQuery preparedQuery;

    public CubeQueryResults(IBaseQueryResults outResults, PreparedCubeQuery preparedQuery, DataEngineSession session, Scriptable scope, DataEngineContext context, Map appContext) {
        this.cubeQueryDefinition = (ICubeQueryDefinition)preparedQuery.getCubeQueryDefinition();
        this.preparedQuery = preparedQuery;
        this.scope = scope;
        this.context = context;
        this.session = session;
        this.appContext = appContext;
        this.queryResultsId = this.cubeQueryDefinition.getQueryResultsID();
        this.outResults = outResults;
        this.stopSign = session.getStopSign();
    }

    public ICubeCursor getCubeCursor() throws DataException {
        if (this.cubeCursor != null) {
            return this.cubeCursor;
        }
        try {
            this.stopSign.start();
            CubeQueryExecutor executor = new CubeQueryExecutor(this.outResults, this.cubeQueryDefinition, this.session, this.scope, this.context);
            executor.getFacttableBasedFilterHelpers().addAll(this.preparedQuery.getInternalFilters());
            IDocumentManager documentManager = this.getDocumentManager(executor);
            ICube cube = this.loadCube(documentManager, executor);
            BirtCubeView bcv = new BirtCubeView(executor, cube, this.appContext);
            CubeCursor cubeCursor = bcv.getCubeCursor(this.stopSign, cube, true);
            ICubeQueryDefinition baseQuery = this.cubeQueryDefinition;
            DrillQueryHelper helper = new DrillQueryHelper(this.outResults, baseQuery, cube, this.session, this.scope, this.context, this.appContext, this.stopSign);
            if (helper.getAllCubeViews().length > 0) {
                BirtCubeView view = this.findBaseView(bcv, helper.getAllCubeViews());
                cubeCursor = new MergedCubeCursor(cubeCursor, bcv, view, helper);
                baseQuery = view.getCubeQueryDefinition();
            }
            cube.close();
            String newResultSetId = executor.getQueryResultsId();
            if (newResultSetId != null) {
                this.queryResultsId = newResultSetId;
            }
            this.scope.put("measure", this.scope, (Object)new JSMeasureAccessor(cubeCursor, bcv.getMeasureMapping()));
            this.scope.put("dimension", this.scope, (Object)new JSLevelAccessor(baseQuery, bcv));
            this.cubeCursor = new CubeCursorImpl(this.outResults, cubeCursor, this.scope, this.session.getEngineContext().getScriptContext(), this.cubeQueryDefinition, bcv);
            return this.cubeCursor;
        }
        catch (OLAPException e) {
            throw new DataException(e.getLocalizedMessage(), (Throwable)((Object)e));
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    private BirtCubeView findBaseView(BirtCubeView baseView, BirtCubeView[] drillView) {
        BirtEdgeView columnEdge = baseView.getColumnEdgeView();
        BirtEdgeView rowEdge = baseView.getRowEdgeView();
        BirtCubeView view = baseView;
        int column = this.getLevelCount(columnEdge);
        int row = this.getLevelCount(rowEdge);
        int i = 0;
        while (i < drillView.length) {
            columnEdge = drillView[i].getColumnEdgeView();
            rowEdge = drillView[i].getRowEdgeView();
            int drillColumn = this.getLevelCount(columnEdge);
            int drillRow = this.getLevelCount(rowEdge);
            if (column <= drillColumn) {
                if (row <= drillRow) {
                    view = drillView[i];
                    row = drillRow;
                }
                column = drillColumn;
            }
            ++i;
        }
        return view;
    }

    private int getLevelCount(BirtEdgeView view) {
        int count = 0;
        if (view != null) {
            int i = 0;
            while (i < view.getDimensionViews().size()) {
                BirtDimensionView dimView = (BirtDimensionView)view.getDimensionViews().get(i);
                count += dimView.getMemberSelection().size();
                ++i;
            }
        }
        return count;
    }

    private IDocumentManager getDocumentManager(CubeQueryExecutor executor) throws DataException, IOException {
        IDocumentManager manager = null;
        if (executor.getContext().getMode() == 3 || executor.getContext().getMode() == 1) {
            manager = DocManagerMap.getDocManagerMap().get(String.valueOf(executor.getSession().getEngine().hashCode()), String.valueOf(executor.getSession().getTempDir()) + executor.getSession().getEngine().hashCode());
        }
        if (manager != null && manager.exist(NamingUtil.getCubeDocName(executor.getCubeQueryDefinition().getName()))) {
            return manager;
        }
        return CubeRADocumentManagerFactory.createRADocumentManager(executor.getCubeQueryDefinition().getName(), executor.getContext().getDocReader());
    }

    private ICube loadCube(IDocumentManager documentManager, CubeQueryExecutor executor) throws DataException, IOException {
        ICube cube = null;
        cube = CubeQueryExecutorHelper.loadCube(executor.getCubeQueryDefinition().getName(), documentManager, executor.getSession().getStopSign());
        return cube;
    }

    public String getID() {
        return this.queryResultsId;
    }

    public void close() throws BirtException {
    }

    public void cancel() {
        this.stopSign.stop();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

