/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.cursor.Accessor;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.impl.query.DrillQueryHelper;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.BirtDimensionView;
import org.eclipse.birt.data.engine.olap.query.view.DrillCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.query.view.Relationship;

public class DrilledAggregationAccessor
extends Accessor {
    private CubeCursor baseCursor;
    private BirtCubeView baseView;
    private BirtCubeView[] drillView;

    public DrilledAggregationAccessor(CubeCursor baseCursor, BirtCubeView baseView, DrillQueryHelper drillQueryHelper) throws DataException {
        this.baseCursor = baseCursor;
        this.baseView = baseView;
        this.drillView = drillQueryHelper.getAllCubeViews();
    }

    public void close() throws OLAPException {
    }

    public Object getObject(int arg0) throws OLAPException {
        try {
            String aggrName = this.baseView.getAggregationRegisterTable().getAggrName(arg0);
            return this.getObject(aggrName);
        }
        catch (DataException dataException) {
            return null;
        }
    }

    public Object getObject(String arg0) throws OLAPException {
        Object[] key;
        int j;
        int i;
        IAggregationResultSet rs;
        Object value;
        DimensionCursor cursor;
        Object value2;
        DimensionCursor cursor2;
        EdgeCursor columnEdgeCursor;
        BirtDimensionView view;
        int i2;
        List dimensionView;
        EdgeCursor rowEdgeCursor;
        List columnDimList = null;
        List rowDimList = null;
        List columnLevelList = new ArrayList();
        List rowLevelList = new ArrayList();
        if (this.baseView.getRowEdgeView() != null && (rowEdgeCursor = this.baseView.getRowEdgeView().getEdgeCursor()) != null && !rowEdgeCursor.isBeforeFirst() && !rowEdgeCursor.isAfterLast()) {
            rowDimList = rowEdgeCursor.getDimensionCursor();
            dimensionView = this.baseView.getRowEdgeView().getDimensionViews();
            i2 = 0;
            while (i2 < dimensionView.size()) {
                view = (BirtDimensionView)dimensionView.get(i2);
                rowLevelList.addAll(view.getMemberSelection());
                ++i2;
            }
        }
        if (this.baseView.getColumnEdgeView() != null && (columnEdgeCursor = this.baseView.getColumnEdgeView().getEdgeCursor()) != null && !columnEdgeCursor.isBeforeFirst() && !columnEdgeCursor.isAfterLast()) {
            columnDimList = columnEdgeCursor.getDimensionCursor();
            dimensionView = this.baseView.getColumnEdgeView().getDimensionViews();
            i2 = 0;
            while (i2 < dimensionView.size()) {
                view = (BirtDimensionView)dimensionView.get(i2);
                columnLevelList.addAll(view.getMemberSelection());
                ++i2;
            }
        }
        Object[][] columnValue = new Object[columnLevelList.size()][];
        Object[][] rowValue = new Object[rowLevelList.size()][];
        i2 = 0;
        while (i2 < columnLevelList.size()) {
            cursor2 = (DimensionCursor)columnDimList.get(i2);
            value2 = cursor2.getObject(((ILevelDefinition)columnLevelList.get(i2)).getName());
            columnValue[i2] = new Object[]{value2};
            ++i2;
        }
        i2 = 0;
        while (i2 < rowLevelList.size()) {
            cursor2 = (DimensionCursor)rowDimList.get(i2);
            value2 = cursor2.getObject(((ILevelDefinition)rowLevelList.get(i2)).getName());
            rowValue[i2] = new Object[]{value2};
            ++i2;
        }
        int index = this.findDrillCursorIndex(columnValue, rowValue);
        if (index < 0) {
            return this.baseCursor.getObject(arg0);
        }
        rowLevelList.clear();
        columnLevelList.clear();
        try {
            Map referedLevel = this.drillView[index].getReferencedLevels();
            Relationship relation = (Relationship)referedLevel.get(arg0);
            if (relation == null) {
                return this.baseCursor.getObject(arg0);
            }
            rowLevelList = relation.getLevelListOnRow();
            columnLevelList = relation.getLevelListOnColumn();
        }
        catch (DataException dataException) {}
        columnValue = new Object[columnLevelList.size()][];
        rowValue = new Object[rowLevelList.size()][];
        int i3 = 0;
        while (i3 < columnLevelList.size()) {
            cursor = (DimensionCursor)columnDimList.get(i3);
            value = cursor.getObject(((DimLevel)columnLevelList.get(i3)).getLevelName());
            columnValue[i3] = new Object[]{value};
            ++i3;
        }
        i3 = 0;
        while (i3 < rowLevelList.size()) {
            cursor = (DimensionCursor)rowDimList.get(i3);
            value = cursor.getObject(((DimLevel)rowLevelList.get(i3)).getLevelName());
            rowValue[i3] = new Object[]{value};
            ++i3;
        }
        EdgeCursor columnCursor = null;
        EdgeCursor rowCursor = null;
        try {
            List ordinateEdge = this.drillView[index].getCubeCursor(null, null, false).getOrdinateEdge();
            if (this.drillView[index].getColumnEdgeView() != null) {
                columnCursor = (EdgeCursor)ordinateEdge.get(0);
                if (this.drillView[index].getRowEdgeView() != null) {
                    rowCursor = (EdgeCursor)ordinateEdge.get(1);
                }
            } else if (this.drillView[index].getRowEdgeView() != null) {
                rowCursor = (EdgeCursor)ordinateEdge.get(0);
            }
        }
        catch (DataException e1) {
            throw new OLAPException(e1.getLocalizedMessage());
        }
        boolean flag = true;
        if (!columnLevelList.isEmpty() && columnCursor != null) {
            block36: {
                block35: {
                    rs = this.drillView[index].getColumnEdgeView().getEdgeAxis().getQueryResultSet();
                    if (rs.length() != 0) break block35;
                    return null;
                }
                try {
                    i = 0;
                    while (i < rs.length()) {
                        rs.seek(i);
                        j = 0;
                        while (j < columnLevelList.size()) {
                            key = rs.getLevelKeyValue(rs.getLevelIndex((DimLevel)columnLevelList.get(j)));
                            if (!this.isEuqalObjectArray(key, columnValue[j])) {
                                flag = false;
                                break;
                            }
                            flag = true;
                            ++j;
                        }
                        if (flag) break;
                        ++i;
                    }
                    if (flag) break block36;
                    return null;
                }
                catch (IOException iOException) {}
            }
            columnCursor.setPosition(rs.getPosition());
        }
        if (!rowLevelList.isEmpty() && rowCursor != null) {
            block37: {
                try {
                    rs = this.drillView[index].getRowEdgeView().getEdgeAxis().getQueryResultSet();
                    i = 0;
                    while (i < rs.length()) {
                        rs.seek(i);
                        j = 0;
                        while (j < rowLevelList.size()) {
                            key = rs.getLevelKeyValue(rs.getLevelIndex((DimLevel)rowLevelList.get(j)));
                            if (!this.isDrilledElement(key, rowValue[j])) {
                                flag = false;
                                break;
                            }
                            flag = true;
                            ++j;
                        }
                        if (flag) break;
                        ++i;
                    }
                    if (flag) break block37;
                    return null;
                }
                catch (IOException iOException) {}
            }
            rowCursor.setPosition(rs.getPosition());
        }
        try {
            return this.drillView[index].getCubeCursor(null, null, false).getObject(arg0);
        }
        catch (DataException e) {
            throw new OLAPException(e.getLocalizedMessage());
        }
    }

    private int findDrillCursorIndex(Object[][] columnValue, Object[][] rowValue) {
        int cursorIndex = -1;
        int index = this.drillView.length - 1;
        while (index >= 0) {
            boolean flag = true;
            ICubeQueryDefinition query = this.drillView[index].getCubeQueryDefinition();
            Iterator column = ((DrillCubeQueryDefinition)query).getTupleOnColumn().iterator();
            int count = 0;
            while (column.hasNext()) {
                Object[] key = (Object[])column.next();
                if (key == null || key.length == 0 || key[0] == null) {
                    ++count;
                    continue;
                }
                if (columnValue.length > count && this.isDrilledElement(key, columnValue[count])) {
                    ++count;
                    continue;
                }
                flag = false;
                break;
            }
            if (flag) {
                Iterator row = ((DrillCubeQueryDefinition)query).getTupleOnRow().iterator();
                count = 0;
                while (row.hasNext()) {
                    Object[] key = (Object[])row.next();
                    if (key == null || key.length == 0 || key[0] == null) break;
                    if (rowValue.length > count && this.isDrilledElement(key, rowValue[count])) {
                        ++count;
                        continue;
                    }
                    flag = false;
                }
            }
            if (flag) {
                cursorIndex = index;
                break;
            }
            --index;
        }
        return cursorIndex;
    }

    private boolean isDrilledElement(Object[] drilledObject, Object[] obj2) {
        int i = 0;
        while (i < drilledObject.length) {
            if (drilledObject[i] == null) {
                return true;
            }
            if (drilledObject[i].equals(obj2[0])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isEuqalObjectArray(Object[] obj1, Object[] obj2) {
        if (obj1.length != obj2.length) {
            return false;
        }
        int i = 0;
        while (i < obj1.length) {
            if (!obj1[i].equals(obj2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

