/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.group;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.impl.group.DateGroupCalculator;

class HourGroupCalculator
extends DateGroupCalculator {
    public HourGroupCalculator(Object intervalStart, double intervalRange, ULocale locale, TimeZone timeZone) throws BirtException {
        super(intervalStart, intervalRange, locale, timeZone);
    }

    public Object calculate(Object value) throws BirtException {
        if (value == null) {
            return new Double(-1.0);
        }
        Date target = this.getDate(value);
        if (this.intervalStart == null) {
            return new Double(Math.floor(this.dateTimeUtil.diffHour(this.defaultStart, target) / (long)this.getDateIntervalRange()));
        }
        if (this.dateTimeUtil.diffHour((Date)this.intervalStart, target) < 0L) {
            return new Double(-1.0);
        }
        return new Double(Math.floor(this.dateTimeUtil.diffHour((Date)this.intervalStart, target) / (long)this.getDateIntervalRange()));
    }
}

