/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.group;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.Date;

class DateTimeUtil {
    private static final long serialVersionUID = 1L;
    private ULocale locale;
    private TimeZone timeZone;

    public DateTimeUtil(ULocale locale, TimeZone timeZone) {
        this.locale = locale == null ? ULocale.getDefault() : locale;
        this.timeZone = timeZone == null ? TimeZone.getDefault() : timeZone;
    }

    private int year(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        return this.getCalendar(d).get(1);
    }

    private int quarter(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        int month = this.getCalendar(d).get(2);
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                return 1;
            }
            case 3: 
            case 4: 
            case 5: {
                return 2;
            }
            case 6: 
            case 7: 
            case 8: {
                return 3;
            }
            case 9: 
            case 10: 
            case 11: {
                return 4;
            }
        }
        return -1;
    }

    private int month(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        return this.getCalendar(d).get(2) + 1;
    }

    private String weekDay(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        return String.valueOf(this.getCalendar(d).get(7));
    }

    int diffYear(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        int startYear = this.year(d1);
        int endYear = this.year(d2);
        return endYear - startYear;
    }

    int diffMonth(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        int startMonth = this.year(d1) * 12 + this.month(d1);
        int endMonth = this.year(d2) * 12 + this.month(d2);
        return endMonth - startMonth;
    }

    int diffQuarter(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        int startQuter = this.year(d1) * 4 + this.quarter(d1);
        int endQuter = this.year(d2) * 4 + this.quarter(d2);
        return endQuter - startQuter;
    }

    long diffWeek(Date d1, Date d2) {
        Calendar calendar = this.getCalendarOfStartingTime();
        Date baseDay = calendar.getTime();
        int diffDay = 1 - Integer.valueOf(this.weekDay(baseDay));
        baseDay = this.addDay(baseDay, diffDay);
        return (this.diffSecond(baseDay, d2) + 1814400000L) / 604800L - (this.diffSecond(baseDay, d1) + 1814400000L) / 604800L;
    }

    long diffDay(Date d1, Date d2) {
        Calendar calendar = this.getCalendarOfStartingTime();
        return (this.diffSecond(calendar.getTime(), d2) + 1814400000L) / 86400L - (this.diffSecond(calendar.getTime(), d1) + 1814400000L) / 86400L;
    }

    private Calendar getCalendarOfStartingTime() {
        Calendar calendar = Calendar.getInstance((ULocale)this.locale);
        calendar.setTimeZone(this.timeZone);
        calendar.clear();
        return calendar;
    }

    long diffHour(Date d1, Date d2) {
        Calendar calendar = this.getCalendarOfStartingTime();
        return (this.diffSecond(calendar.getTime(), d2) + 1814400000L) / 3600L - (this.diffSecond(calendar.getTime(), d1) + 1814400000L) / 3600L;
    }

    long diffMinute(Date d1, Date d2) {
        Calendar calendar = this.getCalendarOfStartingTime();
        return (this.diffSecond(calendar.getTime(), d2) + 1814400000L) / 60L - (this.diffSecond(calendar.getTime(), d1) + 1814400000L) / 60L;
    }

    long diffSecond(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        long diff = d2.getTime() - d1.getTime();
        if (this.timeZone.inDaylightTime(d1)) {
            diff -= (long)this.timeZone.getDSTSavings();
        }
        if (this.timeZone.inDaylightTime(d2)) {
            diff += (long)this.timeZone.getDSTSavings();
        }
        return new Long(diff / 1000L);
    }

    private Date addDay(Date date, int num) {
        Calendar startCal = this.getCalendar(date);
        startCal.add(5, num);
        return startCal.getTime();
    }

    private Calendar getCalendar(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        Calendar c = Calendar.getInstance((ULocale)this.locale);
        c.setTimeZone(this.timeZone);
        c.setTime(d);
        return c;
    }
}

