/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelperInstance;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.odi.IResultObjectEvent;

public class ComputedColumnHelper
implements IResultObjectEvent {
    private ComputedColumnHelperInstance dataSetInstance;
    private ComputedColumnHelperInstance resultSetInstance;
    private ComputedColumnHelperInstance availableModeInstance;
    private ComputedColumnHelperInstance currentModel;
    private List allCC;
    private DataSetRuntime dataSet;
    private static Logger logger = Logger.getLogger(ComputedColumnHelper.class.getName());

    ComputedColumnHelper(DataSetRuntime dataSet, List dataSetCCList, List resultSetCCList, ScriptContext cx) throws DataException {
        Object[] params = new Object[]{dataSet, dataSetCCList, resultSetCCList};
        logger.entering(ComputedColumnHelper.class.getName(), "ComputedColumnHelper", params);
        this.dataSetInstance = new ComputedColumnHelperInstance(dataSet, dataSetCCList, DataSetRuntime.Mode.DataSet, cx);
        this.resultSetInstance = new ComputedColumnHelperInstance(dataSet, resultSetCCList, DataSetRuntime.Mode.Query, cx);
        ArrayList availableCCList = new ArrayList();
        this.getAvailableComputedList(this.getComputedNameList(dataSetCCList), dataSetCCList, availableCCList);
        this.availableModeInstance = new ComputedColumnHelperInstance(dataSet, availableCCList, DataSetRuntime.Mode.DataSet, cx);
        this.currentModel = this.dataSetInstance;
        this.allCC = new ArrayList();
        this.allCC.addAll(dataSetCCList);
        this.allCC.addAll(resultSetCCList);
        this.dataSet = dataSet;
        logger.exiting(ComputedColumnHelper.class.getName(), "ComputedColumnHelper");
    }

    private ComputedColumnHelperInstance getCurrentInstance() {
        return this.currentModel;
    }

    public boolean process(IResultObject resultObject, int rowIndex) throws DataException {
        if (this.getCurrentInstance() != null) {
            return this.getCurrentInstance().process(resultObject, rowIndex);
        }
        return true;
    }

    public boolean isComputedColumnExist(int model) {
        if (model == 0) {
            return this.dataSetInstance.getComputedColumnList().size() > 0;
        }
        if (model == 1) {
            return this.resultSetInstance.getComputedColumnList().size() > 0;
        }
        if (model == 2) {
            return this.allCC.size() > 0;
        }
        return false;
    }

    public List getComputedColumnList() {
        if (this.getCurrentInstance() != null) {
            return this.getCurrentInstance().getComputedColumnList();
        }
        return this.allCC;
    }

    public void setRePrepare(boolean rePrepare) {
        if (this.getCurrentInstance() != null) {
            this.getCurrentInstance().setRePrepare(rePrepare);
        }
    }

    public void setModel(int model) {
        this.currentModel = model == 0 ? this.dataSetInstance : (model == 1 ? this.resultSetInstance : (model == 5 ? this.availableModeInstance : null));
    }

    private List getComputedNameList(List dataSetCCList) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < dataSetCCList.size()) {
            IComputedColumn column = (IComputedColumn)dataSetCCList.get(i);
            result.add(column.getName());
            ++i;
        }
        return result;
    }

    private void getAvailableComputedList(List refernceNameList, List dataSetCCList, List result) throws DataException {
        try {
            int i = 0;
            while (i < dataSetCCList.size()) {
                IComputedColumn column = (IComputedColumn)dataSetCCList.get(i);
                if (refernceNameList.contains(column.getName()) && !ExpressionCompilerUtil.hasAggregationInExpr(column.getExpression()) && column.getAggregateFunction() == null) {
                    List referedList = ExpressionUtil.extractColumnExpressions((String)((IScriptExpression)column.getExpression()).getText());
                    if (referedList.size() == 0) {
                        result.add(column);
                    } else {
                        ArrayList<String> newList = new ArrayList<String>();
                        int j = 0;
                        while (j < referedList.size()) {
                            IColumnBinding binding = (IColumnBinding)referedList.get(j);
                            String name = binding.getResultSetColumnName();
                            newList.add(name);
                            ++j;
                        }
                        if (!this.hasAggregation(newList, dataSetCCList)) {
                            result.add(column);
                        }
                    }
                }
                ++i;
            }
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean hasAggregation(List nameList, List dataSetCCList) throws DataException {
        try {
            int k = 0;
            while (k < nameList.size()) {
                IComputedColumn column = null;
                int i = 0;
                while (i < dataSetCCList.size()) {
                    column = (IComputedColumn)dataSetCCList.get(i);
                    if (column.getName() != null && column.getName().equals(nameList.get(k))) break;
                    column = null;
                    ++i;
                }
                if (column != null) {
                    if (ExpressionCompilerUtil.hasAggregationInExpr(column.getExpression()) || column.getAggregateFunction() != null) {
                        return true;
                    }
                    List referedList = ExpressionUtil.extractColumnExpressions((String)((IScriptExpression)column.getExpression()).getText());
                    ArrayList<String> newList = new ArrayList<String>();
                    int j = 0;
                    while (j < referedList.size()) {
                        IColumnBinding binding = (IColumnBinding)referedList.get(j);
                        String name = binding.getResultSetColumnName();
                        newList.add(name);
                        ++j;
                    }
                    return this.hasAggregation(newList, dataSetCCList);
                }
                ++k;
            }
            return false;
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }
}

