/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.ListElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormTool;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.ToolManager;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.ViewTool;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.FindAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.RegFindBusinessUUIDAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.RegFindServiceInterfaceUUIDAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.RegFindServiceUUIDAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.SelectPropertiesToolAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.MultipleFormToolPropertiesInterface;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.datatype.tmodel.TModel;

public class SelectSubQueryItemAction
extends SelectPropertiesToolAction {
    private boolean requiresTreeViewRefresh_ = false;
    private boolean requiresViewSelection_ = false;
    private boolean newUUIDQueryCreated_ = false;
    private String itemName_ = null;

    public SelectSubQueryItemAction(Controller controller) {
        super(controller);
    }

    public static final String getActionLink(int nodeId, int toolId, int viewId, String subQueryKey, String subQueryListKey, int subQueryListItemId, int queryItem, boolean forHistory) {
        StringBuffer actionLink = new StringBuffer("uddi/actions/SelectSubQueryItemActionJSP.jsp?");
        actionLink.append("nodeId").append('=').append(nodeId);
        actionLink.append('&').append("toolId").append('=').append(toolId);
        if (viewId != -1) {
            actionLink.append('&').append("viewId").append('=').append(viewId);
        }
        actionLink.append('&').append("subQueryKey").append('=').append(subQueryKey);
        actionLink.append('&').append("subQueryListKey").append('=').append(subQueryListKey);
        actionLink.append('&').append("subQueryListItemId").append('=').append(subQueryListItemId);
        actionLink.append('&').append("queryItem").append('=').append(queryItem);
        if (forHistory) {
            actionLink.append('&').append("isHistory").append("=1");
        }
        return actionLink.toString();
    }

    public boolean processLinkParameters(HttpServletRequest request) {
        boolean result = super.processLinkParameters(request);
        String subQueryKey = request.getParameter("subQueryKey");
        String subQueryListKey = request.getParameter("subQueryListKey");
        String subQueryListItemId = request.getParameter("subQueryListItemId");
        String queryItemString = request.getParameter("queryItem");
        if (subQueryKey != null) {
            this.propertyTable_.put("subQueryKey", subQueryKey);
        }
        if (subQueryListKey != null) {
            this.propertyTable_.put("subQueryListKey", subQueryListKey);
        }
        if (subQueryListItemId != null) {
            this.propertyTable_.put("subQueryListItemId", subQueryListItemId);
        }
        if (queryItemString != null) {
            this.propertyTable_.put("queryItem", queryItemString);
        }
        return result;
    }

    private final boolean findByUUID() {
        Node currentNode = this.nodeManager_.getSelectedNode();
        FormTool formTool = (FormTool)currentNode.getCurrentToolManager().getSelectedTool();
        FormToolPropertiesInterface formToolPI = ((MultipleFormToolPropertiesInterface)((Object)formTool)).getFormToolProperties((String)this.propertyTable_.get("subQueryKey"));
        Vector list = (Vector)formToolPI.getProperty((String)this.propertyTable_.get("subQueryListKey"));
        ListElement listElement = (ListElement)list.elementAt(Integer.parseInt((String)this.propertyTable_.get("subQueryListItemId")));
        int queryItem = Integer.parseInt((String)this.propertyTable_.get("queryItem"));
        FindAction findAction = null;
        String uuidKey = null;
        String uuidKeyValue = null;
        switch (queryItem) {
            case 0: {
                findAction = new RegFindBusinessUUIDAction(this.controller_);
                uuidKey = "uuidBusinessKey";
                BusinessEntity sp = (BusinessEntity)listElement.getObject();
                uuidKeyValue = sp.getBusinessKey();
                this.itemName_ = sp.getDefaultNameString();
                break;
            }
            case 1: {
                findAction = new RegFindServiceUUIDAction(this.controller_);
                uuidKey = "uuidServiceKey";
                BusinessService bs = (BusinessService)listElement.getObject();
                uuidKeyValue = bs.getServiceKey();
                this.itemName_ = bs.getDefaultNameString();
                break;
            }
            default: {
                findAction = new RegFindServiceInterfaceUUIDAction(this.controller_);
                uuidKey = "uuidServiceInterfaceKey";
                TModel tModel = (TModel)listElement.getObject();
                uuidKeyValue = tModel.getTModelKey();
                this.itemName_ = tModel.getNameString();
            }
        }
        Hashtable propertyTable = findAction.getPropertyTable();
        propertyTable.put("queryName", uuidKeyValue);
        propertyTable.put(uuidKey, uuidKeyValue);
        boolean result = findAction.run();
        if (result) {
            Node itemNode = this.nodeManager_.getSelectedNode();
            int nodeId = itemNode.getNodeId();
            int toolId = itemNode.getToolManager().getSelectedToolId();
            int viewId = -1;
            int viewToolId = -1;
            this.propertyTable_.put("nodeId", String.valueOf(nodeId));
            this.propertyTable_.put("toolId", String.valueOf(toolId));
            this.propertyTable_.put("viewId", String.valueOf(viewId));
            this.propertyTable_.put("viewToolId", String.valueOf(viewToolId));
            super.run();
            this.requiresTreeViewRefresh_ = true;
            this.requiresViewSelection_ = true;
            this.newUUIDQueryCreated_ = true;
            listElement.setTargetViewToolInfo(nodeId, toolId, viewId);
            return true;
        }
        return false;
    }

    public final String getItemName() {
        return this.itemName_;
    }

    public boolean run() {
        int nodeId = Integer.parseInt((String)this.propertyTable_.get("nodeId"));
        int toolId = Integer.parseInt((String)this.propertyTable_.get("toolId"));
        int viewId = -1;
        try {
            viewId = Integer.parseInt((String)this.propertyTable_.get("viewId"));
        }
        catch (NumberFormatException numberFormatException) {}
        int viewToolId = 0;
        if (!this.isStaleNode(nodeId)) {
            this.requiresTreeViewRefresh_ = this.makeNodeVisible(this.nodeManager_.getNode(nodeId));
            Node node = this.nodeManager_.getNode(nodeId);
            if (viewId != -1) {
                ViewTool viewTool = (ViewTool)node.getToolManager().getTool(toolId);
                ToolManager elementToolManager = viewTool.getToolManager(viewId);
                if (elementToolManager != null) {
                    viewToolId = elementToolManager.getSelectedToolId();
                } else {
                    return this.findByUUID();
                }
            }
            this.propertyTable_.put("viewToolId", String.valueOf(viewToolId));
            return super.run();
        }
        return this.findByUUID();
    }

    protected String getActionLinkForHistory() {
        int nodeId = this.selectedNode_.getNodeId();
        int toolId = this.selectedTool_.getToolId();
        int viewId = this.selectedNode_.getViewId();
        int viewToolId = this.selectedNode_.getViewToolId();
        return SelectPropertiesToolAction.getActionLink(nodeId, toolId, viewId, viewToolId, true);
    }

    public boolean requiresTreeViewRefresh() {
        return super.requiresTreeViewRefresh() | this.requiresTreeViewRefresh_;
    }

    public boolean requiresViewSelection() {
        return super.requiresViewSelection() | this.requiresViewSelection_;
    }

    public boolean requiresStatusUpdate() {
        return this.newUUIDQueryCreated_;
    }

    public final String getStatusContentVar() {
        return "statusContent";
    }

    public final String getStatusContentPage() {
        return "uddi/status_content.jsp";
    }
}

