/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.adapter.oda.IAmbiguousAttribute;
import org.eclipse.birt.report.model.adapter.oda.impl.AmbiguousAttribute;
import org.eclipse.birt.report.model.adapter.oda.impl.CompareUtil;
import org.eclipse.birt.report.model.adapter.oda.impl.ResultSetsAdapter;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.OdaResultSetColumnHandle;
import org.eclipse.datatools.connectivity.oda.design.AxisAttributes;
import org.eclipse.datatools.connectivity.oda.design.ColumnDefinition;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataElementUIHints;
import org.eclipse.datatools.connectivity.oda.design.OutputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.ValueFormatHints;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResultSetColumnChecker {
    List<IAmbiguousAttribute> ambiguousList;
    ColumnDefinition columnDefn = null;
    OdaResultSetColumnHandle columnHandle;
    ColumnHintHandle columnHintHandle;

    ResultSetColumnChecker(ColumnDefinition columnDefn, OdaResultSetColumnHandle columnHandle, ColumnHintHandle columnHintHandle) {
        if (columnDefn == null || columnHandle == null) {
            throw new IllegalArgumentException("The parameter definition and oda data set parameter handle can not be null!");
        }
        this.columnDefn = columnDefn;
        this.columnHandle = columnHandle;
        this.columnHintHandle = columnHintHandle;
        this.ambiguousList = new ArrayList<IAmbiguousAttribute>();
    }

    List<IAmbiguousAttribute> process() {
        DataElementAttributes dataAttrs = this.columnDefn.getAttributes();
        this.processDataElementAttributes(dataAttrs);
        this.processColumnHint();
        return this.ambiguousList;
    }

    private void processDataElementAttributes(DataElementAttributes dataAttrs) {
        if (dataAttrs == null) {
            return;
        }
        String newValue = dataAttrs.getName();
        String oldValue = this.columnHandle.getNativeName();
        this.checkProperty("nativeName", oldValue, newValue);
        assert (dataAttrs.getPosition() == this.columnHandle.getPosition().intValue());
        int newNativeDataType = dataAttrs.getNativeDataTypeCode();
        Integer oldNativeDataType = this.columnHandle.getNativeDataType();
        this.checkProperty("nativeDataType", oldNativeDataType, newNativeDataType);
    }

    private void processColumnHint() {
        OutputElementAttributes usageHints;
        AxisAttributes axisAttrs;
        if (this.columnHintHandle == null) {
            return;
        }
        DataElementAttributes dataAttrs = this.columnDefn.getAttributes();
        if (dataAttrs != null) {
            this.checkProperty("columnName", dataAttrs.getName(), this.columnHintHandle.getColumnName());
            DataElementUIHints uiHints = dataAttrs.getUiHints();
            if (uiHints != null) {
                this.checkProperty("displayName", uiHints.getDisplayName(), this.columnHintHandle.getDisplayName());
                this.checkProperty("displayNameID", uiHints.getDisplayNameKey(), this.columnHintHandle.getDisplayNameKey());
                this.checkProperty("description", uiHints.getDescription(), this.columnHintHandle.getDescription());
                this.checkProperty("descriptionID", uiHints.getDescriptionKey(), this.columnHintHandle.getDescriptionKey());
            }
        }
        if ((axisAttrs = this.columnDefn.getMultiDimensionAttributes()) != null) {
            this.checkProperty("analysis", ResultSetsAdapter.convertAxisTypeToAnalysisType(axisAttrs.getAxisType()), this.columnHintHandle.getAnalysis());
            this.checkProperty("onColumnLayout", axisAttrs.isOnColumnLayout(), this.columnHintHandle.isOnColumnLayout());
        }
        if ((usageHints = this.columnDefn.getUsageHints()) != null) {
            this.checkProperty("helpText", usageHints.getHelpText(), this.columnHintHandle.getHelpText());
            this.checkProperty("helpTextID", usageHints.getHelpTextKey(), this.columnHintHandle.getHelpTextKey());
            this.checkProperty("heading", usageHints.getLabel(), this.columnHintHandle.getHeading());
            this.checkProperty("headingID", usageHints.getLabelKey(), this.columnHintHandle.getHeadingKey());
            ValueFormatHints formattingHints = usageHints.getFormattingHints();
            if (formattingHints != null) {
                this.checkProperty("format", formattingHints.getDisplayFormat(), this.columnHintHandle.getFormat());
                this.checkProperty("displayLength", formattingHints.getDisplaySize(), this.columnHintHandle.getDisplayLength());
                this.checkProperty("horizontalAlign", ResultSetsAdapter.convertToROMHorizontalAlignment(formattingHints.getHorizontalAlignment()), this.columnHintHandle.getHorizontalAlign());
                this.checkProperty("wordWrap", ResultSetsAdapter.convertToROMWordWrap(formattingHints.getTextWrapType()), this.columnHintHandle.wordWrap());
            }
        }
    }

    private void checkProperty(String propertyName, Object oldValue, Object newValue) {
        if (!CompareUtil.isEquals(String.valueOf(newValue), String.valueOf(oldValue))) {
            this.ambiguousList.add(new AmbiguousAttribute(propertyName, oldValue, newValue, false));
        }
    }
}

