/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.annotations.initialization;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.initialization.AnnotationAttributeInitializer;
import org.eclipse.jst.ws.internal.jaxws.core.utils.JAXWSUtils;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebMethodAttributeInitializer
extends AnnotationAttributeInitializer {
    public List<MemberValuePair> getMemberValuePairs(IJavaElement javaElement, AST ast, Class<? extends Annotation> annotationClass) {
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        if (javaElement.getElementType() == 9) {
            IMethod method = (IMethod)javaElement;
            IType type = method.getCompilationUnit().findPrimaryType();
            MemberValuePair operationValuePair = AnnotationsCore.createStringMemberValuePair((AST)ast, (String)"operationName", (String)this.getOperationNameValue(type, method));
            MemberValuePair actionValuePair = AnnotationsCore.createStringMemberValuePair((AST)ast, (String)"action", (String)this.getActionValue(type, method));
            memberValuePairs.add(operationValuePair);
            memberValuePairs.add(actionValuePair);
        }
        return memberValuePairs;
    }

    public List<ICompletionProposal> getCompletionProposalsForMemberValuePair(IJavaElement javaElement, MemberValuePair memberValuePair) {
        ArrayList<ICompletionProposal> completionProposals = new ArrayList<ICompletionProposal>();
        if (javaElement.getElementType() == 9) {
            IMethod method = (IMethod)javaElement;
            IType type = method.getCompilationUnit().findPrimaryType();
            String memberValuePairName = memberValuePair.getName().getIdentifier();
            if (memberValuePairName.equals("operationName")) {
                completionProposals.add((ICompletionProposal)this.createCompletionProposal(this.getOperationNameValue(type, method), memberValuePair.getValue()));
            }
            if (memberValuePairName.equals("action")) {
                completionProposals.add((ICompletionProposal)this.createCompletionProposal(this.getActionValue(type, method), memberValuePair.getValue()));
            }
        }
        return completionProposals;
    }

    private String getOperationNameValue(IType type, IMethod method) {
        try {
            return String.valueOf(method.getElementName()) + JAXWSUtils.accountForOverloadedMethods((IMethod)method);
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
            return "";
        }
    }

    private String getActionValue(IType type, IMethod method) {
        try {
            String methodName = method.getElementName();
            return "urn:" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1) + JAXWSUtils.accountForOverloadedMethods((IMethod)method);
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
            return "";
        }
    }
}

