/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.AbstractScalarParameter;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.TextDataItem;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ObjectDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.SimpleEncryptionHelper;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.metadata.StructureDefn;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.RecoverableError;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.AnyElementState;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.eclipse.birt.report.model.util.XMLParserHandler;
import org.xml.sax.Attributes;

public class AbstractPropertyState
extends AbstractParseState {
    protected ModuleParserHandler handler = null;
    protected DesignElement element = null;
    protected String name = null;
    protected int nameValue = -1;
    protected IStructure struct = null;
    protected boolean valid = true;
    protected boolean isEmpty = false;

    public AbstractPropertyState(ModuleParserHandler theHandler, DesignElement element) {
        this.handler = theHandler;
        this.element = element;
    }

    public void parseAttrs(Attributes attrs) throws XMLParserException {
        this.name = attrs.getValue("name");
        if (StringUtil.isBlank(this.name)) {
            DesignParserException e = new DesignParserException("Error.DesignParserException.NAME_REQUIRED");
            this.handler.getErrorHandler().semanticError((Exception)((Object)e));
            this.valid = false;
            return;
        }
        this.nameValue = this.name.toLowerCase().hashCode();
        this.isEmpty = Boolean.parseBoolean(attrs.getValue("isEmpty"));
        super.parseAttrs(attrs);
    }

    public XMLParserHandler getHandler() {
        return this.handler;
    }

    void setMember(IStructure struct, String propName, String member, Object value) {
        SimpleEncryptionHelper helper;
        StructureDefn structDefn = (StructureDefn)struct.getDefn();
        assert (structDefn != null);
        StructPropertyDefn memberDefn = (StructPropertyDefn)structDefn.getMember(member);
        if (memberDefn == null) {
            DesignParserException e = new DesignParserException(new String[]{member}, "Error.DesignParserException.UNDEFINED_PROPERTY");
            RecoverableError.dealUndefinedProperty(this.handler, e);
            this.valid = false;
            return;
        }
        Object valueToSet = value;
        if (memberDefn.isEncryptable() && this.handler.versionNumber < 3021500 && (helper = SimpleEncryptionHelper.getInstance()) != SimpleEncryptionHelper.getInstance()) {
            valueToSet = SimpleEncryptionHelper.getInstance().decrypt((String)valueToSet);
            valueToSet = helper.encrypt((String)valueToSet);
        }
        this.doSetMember(struct, propName, memberDefn, valueToSet);
    }

    protected void doSetMember(IStructure struct, String propName, StructPropertyDefn memberDefn, Object valueToSet) {
        try {
            Object propValue = memberDefn.validateXml(this.handler.getModule(), this.element, valueToSet);
            struct.setProperty(memberDefn, propValue);
        }
        catch (PropertyValueException ex) {
            ex.setElement(this.element);
            ex.setPropertyName(String.valueOf(propName) + "." + memberDefn.getName());
            this.handleMemberValueException(ex, memberDefn);
            this.valid = false;
        }
    }

    protected void setProperty(String propName, Object value) {
        assert (propName != null);
        if (propName.equalsIgnoreCase("name") || propName.equalsIgnoreCase("extends")) {
            DesignParserException e = new DesignParserException("Error.DesignParserException.INVALID_PROPERTY_SYNTAX");
            this.handler.getErrorHandler().semanticError((Exception)((Object)e));
            this.valid = false;
            return;
        }
        if (this.element.isVirtualElement() && this.element instanceof Cell && ("colSpan".equalsIgnoreCase(propName) || "rowSpan".equalsIgnoreCase(propName) || "drop".equalsIgnoreCase(propName) || "column".equalsIgnoreCase(propName))) {
            PropertyValueException e = new PropertyValueException(this.element, propName, value, "Error.PropertyValueException.PROPERTY_CHANGE_FORBIDDEN");
            this.handler.getErrorHandler().semanticWarning((Exception)((Object)e));
            this.valid = false;
            return;
        }
        ElementPropertyDefn propDefn = this.element.getPropertyDefn(propName);
        if (propDefn == null) {
            if (this.element instanceof ExtendedItem) {
                ((ExtendedItem)this.element).getExtensibilityProvider().handleUndefinedProperty(propName, value);
                return;
            }
            DesignParserException e = new DesignParserException(new String[]{propName}, "Error.DesignParserException.UNDEFINED_PROPERTY");
            RecoverableError.dealUndefinedProperty(this.handler, e);
            this.valid = false;
            return;
        }
        Object valueToSet = value;
        if (propDefn.isEncryptable() && this.handler.versionNumber < 3021500) {
            SimpleEncryptionHelper helper = SimpleEncryptionHelper.getInstance();
            if (this.handler.versionNumber == 0) {
                valueToSet = helper.encrypt((String)valueToSet);
            } else if (helper != SimpleEncryptionHelper.getInstance()) {
                valueToSet = SimpleEncryptionHelper.getInstance().decrypt((String)valueToSet);
                valueToSet = helper == null ? valueToSet : helper.encrypt((String)valueToSet);
            }
            this.element.setEncryptionHelper(propDefn, "base64");
        }
        this.doSetProperty(propDefn, valueToSet);
    }

    protected void doSetProperty(PropertyDefn propDefn, Object valueToSet) {
        try {
            Object propValue = propDefn.validateXml(this.handler.getModule(), this.element, valueToSet);
            this.element.setProperty(propDefn, propValue);
        }
        catch (PropertyValueException ex) {
            if (this.element instanceof ExtendedItem && propDefn.isExtended()) {
                ((ExtendedItem)this.element).getExtensibilityProvider().handleInvalidPropertyValue(propDefn.getName(), valueToSet);
                return;
            }
            ex.setElement(this.element);
            ex.setPropertyName(propDefn.getName());
            this.handlePropertyValueException(ex);
            this.valid = false;
        }
    }

    protected void handlePropertyValueException(PropertyValueException e) {
        String propName = e.getPropertyName();
        if (this.isRecoverableError(e.getInvalidValue(), e.getErrorCode(), e.getElement().getPropertyDefn(propName))) {
            RecoverableError.dealInvalidPropertyValue(this.handler, e);
        } else {
            this.handler.getErrorHandler().semanticError((Exception)((Object)e));
        }
    }

    private void handleMemberValueException(PropertyValueException e, StructPropertyDefn memberDefn) {
        if (this.isRecoverableError(e.getInvalidValue(), e.getErrorCode(), memberDefn)) {
            RecoverableError.dealInvalidMemberValue(this.handler, e, this.struct, memberDefn);
        } else {
            this.handler.getErrorHandler().semanticError((Exception)((Object)e));
        }
    }

    private boolean isRecoverableError(Object invalidValue, String errorCode, IPropertyDefn propDefn) {
        IChoiceSet columnDataTypeSet;
        if ("Error.PropertyValueException.NEGATIVE_VALUE".equalsIgnoreCase(errorCode) || "Error.PropertyValueException.NON_POSITIVE_VALUE".equalsIgnoreCase(errorCode) || "Error.PropertyValueException.UNIT_NOT_ALLOWED".equalsIgnoreCase(errorCode) || "Error.PropertyValueException.CHOICE_NOT_ALLOWED".equalsIgnoreCase(errorCode)) {
            return true;
        }
        if ("Error.PropertyValueException.CHOICE_NOT_FOUND".equalsIgnoreCase(errorCode) && (columnDataTypeSet = propDefn.getChoices()) != null && "columnDataType".equalsIgnoreCase(columnDataTypeSet.getName()) && "any".equals(invalidValue)) {
            return true;
        }
        if ("Error.PropertyValueException.INVALID_VALUE".equalsIgnoreCase(errorCode) || "Error.PropertyValueException.CHOICE_NOT_FOUND".equalsIgnoreCase(errorCode)) {
            if (this.element instanceof TextDataItem && "contentType".equalsIgnoreCase(propDefn.getName())) {
                return true;
            }
            if (this.element instanceof AbstractScalarParameter && "dataType".equalsIgnoreCase(propDefn.getName())) {
                return true;
            }
            if ("pageBreakAfter".equalsIgnoreCase(propDefn.getName()) || "pageBreakBefore".equalsIgnoreCase(propDefn.getName()) || "pageBreakInside".equalsIgnoreCase(propDefn.getName())) {
                return true;
            }
            ObjectDefn objDefn = ((PropertyDefn)propDefn).definedBy();
            if (objDefn instanceof StructureDefn) {
                String structureName = objDefn.getName();
                if (("DateTimeFormatValue".equals(structureName) || "NumberFormatValue".equals(structureName) || "StringFormatValue".equals(structureName) || "TimeFormatValue".equals(structureName) || "DateFormatValue".equals(structureName)) && "category".equalsIgnoreCase(propDefn.getName())) {
                    return true;
                }
                if ("DataSetParam".equalsIgnoreCase(structureName) && "dataType".equalsIgnoreCase(propDefn.getName()) || "OdaDataSetParam".equalsIgnoreCase(structureName) && "dataType".equalsIgnoreCase(propDefn.getName())) {
                    return true;
                }
                if (("MapRule".equals(objDefn.getName()) || "HighlightRule".equals(objDefn.getName())) && ("operator".equals(propDefn.getName()) || "operator".equals(propDefn.getName()))) {
                    return "any".equalsIgnoreCase(invalidValue.toString());
                }
            }
        }
        return false;
    }

    protected void setName(String name) {
        this.name = name;
        if (this.name != null) {
            this.nameValue = this.name.toLowerCase().hashCode();
        }
    }

    public final AbstractParseState jumpTo() {
        if (!this.valid) {
            return new AnyElementState(this.handler);
        }
        AbstractParseState state = null;
        state = this.generalJumpTo();
        if (state != null) {
            return state;
        }
        if (!this.handler.isCurrentVersion && (state = this.versionConditionalJumpTo()) != null) {
            return state;
        }
        return super.jumpTo();
    }

    protected AbstractParseState versionConditionalJumpTo() {
        return null;
    }

    protected AbstractParseState generalJumpTo() {
        return null;
    }

    protected String deEscape(String value) {
        if (value == null) {
            return null;
        }
        String retValue = value.replaceAll("]]&gt;", "]]>");
        retValue = retValue.replaceAll("&amp;", "&");
        return retValue;
    }

    protected boolean supportIsEmpty() {
        ElementPropertyDefn defn;
        return this.isEmpty && this.struct == null && (defn = this.element.getPropertyDefn(this.name)) != null && ModelUtil.canInherit(defn);
    }
}

