/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.i18n;

import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.model.i18n.ModelResourceHandle;

public class ThreadResources {
    private Map<ULocale, ModelResourceHandle> resourceMap = new HashMap<ULocale, ModelResourceHandle>(10);
    private static ThreadLocal threadLocal = new ThreadLocal();

    public static void setLocale(ULocale locale) {
        if (locale == null) {
            threadLocal.set(ULocale.getDefault());
        } else {
            threadLocal.set(locale);
        }
    }

    public static ULocale getLocale() {
        ULocale locale = (ULocale)threadLocal.get();
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        return locale;
    }

    public String getMessage(String key) {
        return this.getMessage(key, ThreadResources.getLocale());
    }

    public String getMessage(String key, ULocale locale) {
        ModelResourceHandle resourceHandle = this.getResourceHandle(locale);
        if (resourceHandle != null) {
            return resourceHandle.getMessage(key);
        }
        return key;
    }

    public String getMessage(String key, Object[] arguments) {
        ModelResourceHandle resourceHandle = this.getResourceHandle(ThreadResources.getLocale());
        if (resourceHandle != null) {
            return resourceHandle.getMessage(key, arguments);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelResourceHandle getResourceHandle(ULocale locale) {
        ModelResourceHandle resourceHandle = this.resourceMap.get(locale);
        if (resourceHandle != null) {
            return resourceHandle;
        }
        Map<ULocale, ModelResourceHandle> map = this.resourceMap;
        synchronized (map) {
            resourceHandle = this.resourceMap.get(locale);
            if (resourceHandle != null) {
                return resourceHandle;
            }
            resourceHandle = new ModelResourceHandle(locale);
            this.resourceMap.put(locale, resourceHandle);
        }
        return resourceHandle;
    }
}

