/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.ReferenceableElement;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.css.CssNameManager;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;
import org.eclipse.birt.report.model.elements.interfaces.IAbstractThemeModel;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.NamePropertyType;
import org.eclipse.birt.report.model.util.StyleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTheme
extends ReferenceableElement
implements IAbstractThemeModel {
    protected List<String> cachedStyleNames = new ArrayList<String>();

    public AbstractTheme() {
        this.initSlots();
    }

    public AbstractTheme(String theName) {
        super(theName);
        this.initSlots();
    }

    @Override
    public final ContainerSlot getSlot(int slot) {
        assert (slot == 0);
        return this.slots[0];
    }

    public final List<StyleElement> getAllStyles() {
        ArrayList<StyleElement> styleList = new ArrayList<StyleElement>();
        if (this instanceof ICssStyleSheetOperation) {
            styleList.addAll(CssNameManager.getStyles((ICssStyleSheetOperation)((Object)this)));
        }
        int i = 0;
        while (i < this.slots[0].getCount()) {
            StyleElement tmpStyle = (StyleElement)this.slots[0].getContent(i);
            int pos = StyleUtil.getStylePosition(styleList, tmpStyle.getFullName());
            if (pos == -1) {
                styleList.add(tmpStyle);
            } else {
                styleList.remove(pos);
                styleList.add(tmpStyle);
            }
            ++i;
        }
        return styleList;
    }

    public final StyleElement findStyle(String styleName) {
        if (styleName == null) {
            return null;
        }
        List<StyleElement> styles = this.getAllStyles();
        int i = 0;
        while (i < styles.size()) {
            StyleElement style = styles.get(i);
            if (styleName.equalsIgnoreCase(style.getFullName())) {
                return style;
            }
            ++i;
        }
        return null;
    }

    public final void makeUniqueName(DesignElement element) {
        if (element == null) {
            return;
        }
        if (!(element instanceof StyleElement)) {
            return;
        }
        if (element.getRoot() != null) {
            return;
        }
        String name = StringUtil.trimString(element.getName());
        if ((name = NamePropertyType.validateName(name)) == null) {
            name = ModelMessages.getMessage("New." + element.getDefn().getName()).trim();
        }
        List<DesignElement> styles = this.slots[0].getContents();
        ArrayList<String> ns = new ArrayList<String>(styles.size());
        int i = 0;
        while (i < styles.size()) {
            ns.add(styles.get(i).getName().toLowerCase());
            ++i;
        }
        int index = 0;
        String baseName = name;
        assert (name != null);
        String lowerCaseName = name.toLowerCase();
        while (this.cachedStyleNames.contains(lowerCaseName) || ns.contains(lowerCaseName)) {
            name = String.valueOf(baseName) + ++index;
            lowerCaseName = name.toLowerCase();
        }
        element.setName(name.trim());
        this.cachedStyleNames.add(lowerCaseName);
    }

    public final void dropCachedName(String name) {
        assert (name != null);
        name = name.toLowerCase();
        this.cachedStyleNames.remove(name);
    }
}

