/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import com.ibm.icu.util.ULocale;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.activity.ReadOnlyActivityStack;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ResourceChangeEvent;
import org.eclipse.birt.report.model.api.core.AttributeEvent;
import org.eclipse.birt.report.model.api.core.DisposeEvent;
import org.eclipse.birt.report.model.api.core.IAttributeListener;
import org.eclipse.birt.report.model.api.core.IDisposeListener;
import org.eclipse.birt.report.model.api.core.IModuleModel;
import org.eclipse.birt.report.model.api.core.IResourceChangeListener;
import org.eclipse.birt.report.model.api.css.StyleSheetException;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.model.api.elements.structures.CustomColor;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.elements.structures.IncludeScript;
import org.eclipse.birt.report.model.api.elements.structures.IncludedLibrary;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.ISlotDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.IValidationListener;
import org.eclipse.birt.report.model.api.validators.ValidationEvent;
import org.eclipse.birt.report.model.core.BundleHelper;
import org.eclipse.birt.report.model.core.CachedBundles;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.DesignSessionImpl;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.core.namespace.INameContainer;
import org.eclipse.birt.report.model.core.namespace.INameHelper;
import org.eclipse.birt.report.model.core.namespace.ModuleNameHelper;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.elements.ContentElement;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportItemTheme;
import org.eclipse.birt.report.model.elements.TemplateElement;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.Translation;
import org.eclipse.birt.report.model.elements.TranslationTable;
import org.eclipse.birt.report.model.elements.interfaces.ISupportThemeElement;
import org.eclipse.birt.report.model.elements.olap.Cube;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.elements.olap.TabularDimension;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.StructureDefn;
import org.eclipse.birt.report.model.util.LevelContentIterator;
import org.eclipse.birt.report.model.util.LineNumberInfo;
import org.eclipse.birt.report.model.util.StructureRefUtil;
import org.eclipse.birt.report.model.util.VersionControlMgr;
import org.eclipse.birt.report.model.validators.ValidationExecutor;
import org.eclipse.birt.report.model.writer.ModuleWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Module
extends DesignElement
implements IModuleModel,
INameContainer,
ISupportThemeElement {
    public static final int STYLE_NAME_SPACE = 0;
    public static final int ELEMENT_NAME_SPACE = 1;
    public static final int PARAMETER_NAME_SPACE = 2;
    public static final int DATA_SOURCE_NAME_SPACE = 3;
    public static final int DATA_SET_NAME_SPACE = 4;
    public static final int PAGE_NAME_SPACE = 5;
    public static final int THEME_NAME_SPACE = 6;
    public static final int TEMPLATE_PARAMETER_NAME_SPACE = 7;
    public static final int CUBE_NAME_SPACE = 8;
    public static final int VARIABLE_ELEMENT_NAME_SPACE = 9;
    public static final int DIMENSION_NAME_SPACE = 10;
    public static final int NAME_SPACE_COUNT = 11;
    protected DesignSessionImpl session;
    protected INameHelper nameHelper = null;
    protected long elementIDCounter = 1L;
    protected HashMap<Long, DesignElement> idMap = new HashMap();
    protected LineNumberInfo lineNoInfo = null;
    protected ActivityStack activityStack = new ActivityStack(this);
    protected int saveState = 0;
    protected ValidationExecutor validationExecutor = new ValidationExecutor(this);
    private List<IValidationListener> validationListeners = null;
    protected String fileName = null;
    protected String signature = null;
    protected List<Exception> allExceptions = new ArrayList<Exception>();
    protected List<IDisposeListener> disposeListeners = null;
    protected List<IResourceChangeListener> resourceChangeListeners = null;
    protected URL systemId = null;
    private URL location = null;
    protected ModuleOption options = null;
    private boolean isCached = false;
    private CachedBundles cachedBundles = null;
    protected VersionControlMgr versionMgr = null;
    private List<IAttributeListener> attributeListeners = null;

    protected Module(DesignSessionImpl theSession) {
        this.session = theSession;
        this.versionMgr = new VersionControlMgr();
    }

    public DesignSessionImpl getSession() {
        return this.session;
    }

    public final DesignElement findDataSource(String name) {
        return this.resolveElement(null, name, null, MetaDataDictionary.getInstance().getElement("DataSource"));
    }

    public final DesignElement findDataSet(String name) {
        return this.resolveElement(null, name, null, MetaDataDictionary.getInstance().getElement("DataSet"));
    }

    public final DesignElement findOLAPElement(String name) {
        return this.resolveNativeElement(name, 8);
    }

    public final Dimension findDimension(String name) {
        return (Dimension)this.resolveNativeElement(name, 10);
    }

    public final DesignElement findLevel(String name) {
        return this.resolveElement(null, name, null, MetaDataDictionary.getInstance().getElement("Level"));
    }

    public final long getNextID() {
        return this.elementIDCounter++;
    }

    public final void addElementID(DesignElement element) {
        assert (this.idMap != null);
        assert (element.getID() > 0L);
        Long idObj = element.getID();
        assert (!this.idMap.containsKey(idObj));
        this.idMap.put(idObj, element);
        long id = element.getID();
        if (this.elementIDCounter <= id) {
            this.elementIDCounter = id + 1L;
        }
    }

    public final void addElementID(long id) {
        if (this.elementIDCounter <= id) {
            this.elementIDCounter = id + 1L;
        }
    }

    public final void dropElementID(DesignElement element) {
        if (this.idMap == null) {
            return;
        }
        assert (element.getID() > 0L);
        Long idObj = element.getID();
        assert (this.idMap.containsKey(idObj) && this.idMap.get(idObj) == element);
        this.idMap.remove(idObj);
    }

    public final void initLineNoMap() {
        this.lineNoInfo = new LineNumberInfo();
    }

    public final DesignElement getElementByID(long id) {
        if (this.idMap == null) {
            return null;
        }
        return this.idMap.get(id);
    }

    public final int getLineNo(Object obj) {
        return this.lineNoInfo.get(obj);
    }

    public final int getLineNoByID(long id) {
        if (this.lineNoInfo == null) {
            return 1;
        }
        return this.lineNoInfo.getElementLineNo(id);
    }

    public final void addLineNo(Object obj, Integer lineNo) {
        if (this.lineNoInfo == null) {
            return;
        }
        this.lineNoInfo.put(obj, lineNo);
    }

    public final ActivityStack getActivityStack() {
        return this.activityStack;
    }

    public final void prepareToSave() {
        String createdBy;
        if (this.options != null && (createdBy = (String)this.options.getProperty("createdBy")) != null) {
            this.setProperty("createdBy", (Object)createdBy);
        }
    }

    public final void onSave() {
        this.saveState = this.activityStack.getCurrentTransNo();
        this.nameHelper.clear();
    }

    public final boolean isDirty() {
        return this.saveState != this.activityStack.getCurrentTransNo();
    }

    public final void setSaveState(int saveState) {
        this.saveState = saveState;
    }

    protected final void onCreate() {
        this.saveState = 0;
    }

    public final void close() {
        this.isValid = false;
        if (!this.isReadOnly()) {
            this.saveState = this.activityStack.getCurrentTransNo();
            this.session.drop(this);
        }
    }

    @Override
    public Object doClone(CopyPolicy policy) throws CloneNotSupportedException {
        DesignElement innerElement;
        Module module = (Module)super.doClone(policy);
        module.activityStack = new ActivityStack(module);
        module.allExceptions = null;
        module.attributeListeners = null;
        module.disposeListeners = null;
        module.resourceChangeListeners = null;
        module.elementIDCounter = 1L;
        module.idMap = new HashMap();
        module.lineNoInfo = null;
        module.nameHelper = new ModuleNameHelper(module);
        module.saveState = 0;
        module.validationExecutor = new ValidationExecutor(module);
        module.validationListeners = null;
        assert (module.getID() > 0L);
        assert (module.getElementByID(module.getID()) == null);
        module.addElementID(module);
        module.isCached = false;
        IElementDefn defn = module.getDefn();
        ArrayList<DesignElement> unhandledElements = new ArrayList<DesignElement>();
        ArrayList<TabularDimension> unhandledCubeDimensions = new ArrayList<TabularDimension>();
        Iterator<ISlotDefn> slots = ((ElementDefn)defn).slotsIterator();
        while (slots.hasNext()) {
            ISlotDefn iSlotDefn = slots.next();
            ContainerSlot slot = module.getSlot(iSlotDefn.getSlotID());
            if (slot == null) continue;
            int pos = 0;
            while (pos < slot.getCount()) {
                innerElement = slot.getContent(pos);
                if (innerElement.canDynamicExtends()) {
                    if (!unhandledElements.contains(innerElement)) {
                        unhandledElements.add(innerElement);
                    }
                } else {
                    Cube cube;
                    List<Object> dimensions;
                    if (innerElement instanceof Cube && (dimensions = (cube = (Cube)innerElement).getListProperty(module, "dimensions")) != null) {
                        int i = 0;
                        while (i < dimensions.size()) {
                            TabularDimension tabularDimension;
                            Dimension dimension = (Dimension)dimensions.get(i);
                            if (dimension instanceof TabularDimension && (tabularDimension = (TabularDimension)dimension).hasSharedDimension(module)) {
                                unhandledCubeDimensions.add(tabularDimension);
                            }
                            ++i;
                        }
                    }
                    this.buildNameSpaceAndIDMap(module, innerElement);
                }
                ++pos;
            }
        }
        List<IElementPropertyDefn> properties = defn.getContents();
        int i = 0;
        while (i < properties.size()) {
            IElementPropertyDefn propDefn = properties.get(i);
            if (propDefn.isList()) {
                List innerElements = (List)module.getProperty(module, (ElementPropertyDefn)propDefn);
                if (innerElements != null && !innerElements.isEmpty()) {
                    int j = 0;
                    while (j < innerElements.size()) {
                        DesignElement innerElement2 = (DesignElement)innerElements.get(j);
                        this.buildNameSpaceAndIDMap(module, innerElement2);
                        ++j;
                    }
                }
            } else {
                innerElement = (DesignElement)module.getProperty(module, (ElementPropertyDefn)propDefn);
                this.buildNameSpaceAndIDMap(module, innerElement);
            }
            ++i;
        }
        for (DesignElement element : unhandledElements) {
            this.buildNameSpaceAndIDMap(module, element);
        }
        for (TabularDimension element : unhandledCubeDimensions) {
            element.updateLayout(module);
            this.buildNameSpaceAndIDMap(module, element);
        }
        return module;
    }

    private void buildNameSpaceAndIDMap(Module module, DesignElement element) {
        TemplateParameterDefinition templateParam;
        if (module == null || element == null) {
            return;
        }
        assert (!(element instanceof Module));
        if (element instanceof TemplateElement && (templateParam = element.getTemplateParameterElement(module)) != null && templateParam.getRoot() != module) {
            element.setProperty("refTemplateParameter", (Object)new ElementRefValue(null, templateParam.getFullName()));
        }
        ElementDefn defn = (ElementDefn)element.getDefn();
        assert (module.getElementByID(element.getID()) == null || element.isVirtualElement() || element.canDynamicExtends());
        assert (element.getID() > 0L);
        if (module.getElementByID(element.getID()) == null) {
            module.addElementID(element);
        } else if (element.canDynamicExtends()) {
            assert (module.getElementByID(element.getID()) == element);
        } else {
            element.setID(module.getNextID());
            module.addElementID(element);
        }
        String name = element.getName();
        assert (!StringUtil.isBlank(name) || defn.getNameOption() != 2);
        assert (element.getContainer() != null);
        int id = defn.getNameSpaceID();
        if (name != null && id != -1 && element.isManagedByNameSpace()) {
            NameSpace ns = new NameExecutor(element).getNameSpace(module);
            assert (!ns.contains(name));
            ns.insert(element);
        }
        if (element.isContainer()) {
            LevelContentIterator iter = new LevelContentIterator(module, element, 1);
            while (iter.hasNext()) {
                DesignElement innerElement = (DesignElement)iter.next();
                this.buildNameSpaceAndIDMap(module, innerElement);
            }
        }
    }

    public final String getMessage(String resourceKey) {
        return this.getMessage(resourceKey, this.getLocale());
    }

    public final String getMessage(String resourceKey, ULocale locale) {
        if (StringUtil.isBlank(resourceKey)) {
            return null;
        }
        if (locale == null) {
            locale = this.getLocale();
        }
        TranslationTable table = this.getTranslationTable();
        String msg = null;
        if (table != null && (msg = table.getMessage(resourceKey, locale)) != null) {
            return msg;
        }
        List<Object> baseNameList = this.getListProperty(this, "includeResource");
        if (baseNameList == null || baseNameList.size() == 0) {
            return null;
        }
        int i = 0;
        while (i < baseNameList.size()) {
            String baseName = (String)baseNameList.get(i);
            msg = BundleHelper.getHelper(this, baseName).getMessage(resourceKey, locale);
            if (msg != null) {
                return msg;
            }
            ++i;
        }
        return msg;
    }

    public final List<ErrorDetail> getAllErrors() {
        return ErrorDetail.convertExceptionList(this.allExceptions);
    }

    public final List<Exception> getAllExceptions() {
        return this.allExceptions;
    }

    public final ValidationExecutor getValidationExecutor() {
        return this.validationExecutor;
    }

    public final void addValidationListener(IValidationListener listener) {
        if (this.validationListeners == null) {
            this.validationListeners = new ArrayList<IValidationListener>();
        }
        if (!this.validationListeners.contains(listener)) {
            this.validationListeners.add(listener);
        }
    }

    public final boolean removeValidationListener(IValidationListener listener) {
        if (this.validationListeners == null) {
            return false;
        }
        return this.validationListeners.remove(listener);
    }

    public final void broadcastValidationEvent(DesignElement element, ValidationEvent event) {
        if (this.validationListeners != null) {
            for (IValidationListener listener : this.validationListeners) {
                listener.elementValidated(element.getHandle(this), event);
            }
        }
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final void setFileName(String newName) {
        this.fileName = newName;
    }

    public final void setUTFSignature(String signature) {
        this.signature = signature;
    }

    public final String getUTFSignature() {
        return this.signature;
    }

    protected abstract int getSlotCount();

    @Override
    public final ContainerSlot getSlot(int slot) {
        assert (slot >= 0);
        int index = this.getSlotIndex(slot);
        if (index == -1) {
            return null;
        }
        return this.slots[index];
    }

    public final void semanticError(SemanticException ex) {
        if (this.allExceptions == null) {
            this.allExceptions = new ArrayList<Exception>();
        }
        this.allExceptions.add((Exception)((Object)ex));
    }

    public final List<ErrorDetail> getErrorList() {
        List<ErrorDetail> allErrors = this.getAllErrors();
        List<ErrorDetail> list = ErrorDetail.getSemanticErrors(allErrors, "Error.DesignFileException.SEMANTIC_ERROR");
        list.addAll(ErrorDetail.getSemanticErrors(allErrors, "Error.DesignFileException.SYNTAX_ERROR"));
        return list;
    }

    public final List<ErrorDetail> getWarningList() {
        List<ErrorDetail> allErrors = this.getAllErrors();
        return ErrorDetail.getSemanticErrors(allErrors, "Error.DesignFileException.SEMANTIC_WARNING");
    }

    public void semanticCheck(Module module) {
        this.allExceptions = new ArrayList<Exception>();
        this.allExceptions.addAll(this.validateWithContents(module));
    }

    public final DesignElement resolveElement(DesignElement element, String elementName, PropertyDefn propDefn, IElementDefn elementDefn) {
        ElementRefValue refValue = this.nameHelper.resolve(element, elementName, propDefn, elementDefn);
        return refValue == null ? null : refValue.getElement();
    }

    public final DesignElement resolveElement(DesignElement focus, DesignElement element, PropertyDefn propDefn, IElementDefn elementDefn) {
        ElementRefValue refValue = this.nameHelper.resolve(focus, element, propDefn, elementDefn);
        return refValue == null ? null : refValue.getElement();
    }

    protected final DesignElement resolveNativeElement(String elementName, int nameSpace) {
        NameSpace namespace = this.nameHelper.getNameSpace(nameSpace);
        return namespace.getElement(elementName);
    }

    protected final void setAllExceptions(List<Exception> allExceptions) {
        this.allExceptions = allExceptions;
    }

    public final URL findResource(String fileName, int fileType) {
        URL url = this.getSession().getResourceLocator().findResource((ModuleHandle)this.getHandle(this), fileName, fileType);
        return url;
    }

    public final URL findResource(String fileName, int fileType, Map appContext) {
        URL url = this.getSession().getResourceLocator().findResource((ModuleHandle)this.getHandle(this), fileName, fileType, appContext);
        return url;
    }

    public final boolean isReadOnly() {
        return this.activityStack instanceof ReadOnlyActivityStack;
    }

    public final void addDisposeListener(IDisposeListener listener) {
        if (this.disposeListeners == null) {
            this.disposeListeners = new ArrayList<IDisposeListener>();
        }
        if (!this.disposeListeners.contains(listener)) {
            this.disposeListeners.add(listener);
        }
    }

    public final boolean removeDisposeListener(IDisposeListener listener) {
        if (this.disposeListeners == null) {
            return false;
        }
        return this.disposeListeners.remove(listener);
    }

    public final void addResourceChangeListener(IResourceChangeListener listener) {
        if (this.resourceChangeListeners == null) {
            this.resourceChangeListeners = new ArrayList<IResourceChangeListener>();
        }
        if (!this.resourceChangeListeners.contains(listener)) {
            this.resourceChangeListeners.add(listener);
        }
    }

    public final boolean removeResourceChangeListener(IResourceChangeListener listener) {
        if (this.resourceChangeListeners == null) {
            return false;
        }
        return this.resourceChangeListeners.remove(listener);
    }

    public final void broadcastDisposeEvent(DisposeEvent event) {
        if (this.disposeListeners == null || this.disposeListeners.isEmpty()) {
            return;
        }
        ArrayList<IDisposeListener> temp = new ArrayList<IDisposeListener>(this.disposeListeners);
        for (IDisposeListener listener : temp) {
            listener.moduleDisposed((ModuleHandle)this.getHandle(this), event);
        }
    }

    public final void broadcastResourceChangeEvent(ResourceChangeEvent event) {
        if (this.resourceChangeListeners == null || this.resourceChangeListeners.isEmpty()) {
            return;
        }
        ArrayList<IResourceChangeListener> temp = new ArrayList<IResourceChangeListener>(this.resourceChangeListeners);
        for (IResourceChangeListener listener : temp) {
            listener.resourceChanged((ModuleHandle)this.getHandle(this), event);
        }
    }

    public final List<String> getMessageKeys() {
        List<Object> baseNameList;
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        String[] transKeys = this.getTranslationResourceKeys();
        if (transKeys != null) {
            int i = 0;
            while (i < transKeys.length) {
                keys.add(transKeys[i]);
                ++i;
            }
        }
        if ((baseNameList = this.getListProperty(this, "includeResource")) == null || baseNameList.size() == 0) {
            return new ArrayList<String>(keys);
        }
        int i = 0;
        while (i < baseNameList.size()) {
            String baseName = (String)baseNameList.get(i);
            keys.addAll(BundleHelper.getHelper(this, baseName).getMessageKeys(this.getLocale()));
            ++i;
        }
        return new ArrayList<String>(keys);
    }

    public final boolean isFileExist(String fileName, int fileType) {
        URL url = this.findResource(fileName, fileType);
        return url != null;
    }

    public abstract ModuleWriter getWriter();

    public final ModuleHandle getModuleHandle() {
        return (ModuleHandle)this.getHandle(this);
    }

    public final URL getSystemId() {
        return this.systemId;
    }

    public final void setSystemId(URL systemId) {
        this.systemId = systemId;
    }

    public final void manageId(DesignElement element, boolean isAdd) {
        if (element == null) {
            return;
        }
        if (element instanceof ContentElement) {
            return;
        }
        if (element.getRoot() != this) {
            return;
        }
        if (isAdd) {
            if (element.getID() <= 0L || this.getElementByID(element.getID()) != null && this.getElementByID(element.getID()) != element) {
                element.setID(this.getNextID());
            }
            if (this.getElementByID(element.getID()) == null) {
                this.addElementID(element);
            }
        } else {
            this.dropElementID(element);
        }
        LevelContentIterator iter = new LevelContentIterator(this, element, 1);
        while (iter.hasNext()) {
            DesignElement innerElement = (DesignElement)iter.next();
            this.manageId(innerElement, isAdd);
        }
    }

    public final String getLocation() {
        if (this.location == null) {
            return null;
        }
        return this.location.toExternalForm();
    }

    public final void setLocation(URL location) {
        this.location = location;
    }

    @Override
    public final void rename(DesignElement element) {
        this.nameHelper.rename(element);
    }

    public final void rename(DesignElement container, DesignElement element) {
        NameExecutor executor = new NameExecutor(element);
        INameHelper nameHelper = executor.getNameHelper(this, container);
        if (nameHelper != null) {
            nameHelper.makeUniqueName(element);
        }
        LevelContentIterator iter = new LevelContentIterator(this, element, 1);
        while (iter.hasNext()) {
            DesignElement innerElement = iter.next();
            this.rename(element, innerElement);
        }
    }

    @Override
    public final void makeUniqueName(DesignElement element) {
        this.nameHelper.makeUniqueName(element);
    }

    public ModuleOption getOptions() {
        return this.options;
    }

    public final void setOptions(ModuleOption options) {
        this.options = options;
    }

    public final void setResourceFolder(String resourceFolder) {
        if (this.options == null) {
            this.options = new ModuleOption();
        }
        this.options.setResourceFolder(resourceFolder);
    }

    public final String getResourceFolder() {
        ModuleOption effectOptions = this.getOptions();
        if (effectOptions == null) {
            return null;
        }
        return effectOptions.getResourceFolder();
    }

    public final void setReadOnly() {
        this.activityStack = new ReadOnlyActivityStack(this);
    }

    @Override
    public final INameHelper getNameHelper() {
        return this.nameHelper;
    }

    public boolean isCached() {
        return this.isCached;
    }

    public final void setIsCached(boolean isCached) {
        this.isCached = isCached;
    }

    public void cacheValues() {
        this.nameHelper.cacheValues();
    }

    public final List<DesignElement> getAllElements() {
        ArrayList<DesignElement> elements = new ArrayList<DesignElement>();
        elements.addAll(this.idMap.values());
        return elements;
    }

    public final CachedBundles getResourceBundle() {
        if (this.getOptions() == null || this.getOptions() != null && this.getOptions().useSemanticCheck()) {
            return null;
        }
        if (this.cachedBundles == null) {
            this.cachedBundles = new CachedBundles();
        }
        return this.cachedBundles;
    }

    public final VersionControlMgr getVersionManager() {
        return this.versionMgr;
    }

    public final void broadcastFileNameEvent(AttributeEvent event) {
        if (this.attributeListeners != null) {
            for (IAttributeListener listener : this.attributeListeners) {
                listener.fileNameChanged((ModuleHandle)this.getHandle(this), event);
            }
        }
    }

    public final void addAttributeListener(IAttributeListener listener) {
        if (this.attributeListeners == null) {
            this.attributeListeners = new ArrayList<IAttributeListener>();
        }
        if (!this.attributeListeners.contains(listener)) {
            this.attributeListeners.add(listener);
        }
    }

    public final boolean removeAttributeListener(IAttributeListener listener) {
        if (this.attributeListeners == null) {
            return false;
        }
        return this.attributeListeners.remove(listener);
    }

    public final CustomColor findColor(String colorName) {
        StructureDefn defn = (StructureDefn)MetaDataDictionary.getInstance().getStructure("CustomColor");
        return (CustomColor)StructureRefUtil.findStructure(this, defn, colorName);
    }

    public final ConfigVariable findConfigVariabel(String variableName) {
        StructureDefn defn = (StructureDefn)MetaDataDictionary.getInstance().getStructure("ConfigVar");
        return (ConfigVariable)StructureRefUtil.findStructure(this, defn, variableName);
    }

    public final EmbeddedImage findImage(String imageName) {
        StructureDefn defn = (StructureDefn)MetaDataDictionary.getInstance().getStructure("EmbeddedImage");
        return (EmbeddedImage)StructureRefUtil.findStructure(this, defn, imageName);
    }

    public final List<Library> getAllLibraries() {
        return this.getLibraries(Integer.MAX_VALUE);
    }

    public StyleElement findNativeStyle(String name) {
        return null;
    }

    public StyleElement findStyle(String name) {
        return null;
    }

    public DesignElement findElement(String name) {
        return null;
    }

    public DesignElement findPage(String name) {
        return null;
    }

    public final DesignElement findParameter(String name) {
        return this.resolveNativeElement(name, 2);
    }

    public void addTranslation(Translation translation) {
    }

    public boolean dropTranslation(Translation translation) {
        return false;
    }

    protected TranslationTable getTranslationTable() {
        return null;
    }

    public Translation findTranslation(String resourceKey, String locale) {
        return null;
    }

    public boolean contains(Translation trans) {
        return false;
    }

    public List<Translation> getTranslations() {
        return Collections.emptyList();
    }

    public List<Translation> getTranslations(String resourceKey) {
        return Collections.emptyList();
    }

    public String[] getTranslationResourceKeys() {
        return null;
    }

    public ElementPropertyDefn getReferencablePropertyDefn(String structureName) {
        return null;
    }

    public Module findOutermostModule() {
        return this;
    }

    public Library loadLibrary(String libraryFileName, String namespace, Map<String, Library> reloadLibs, URL url) throws DesignFileException {
        return null;
    }

    public void loadLibrarySilently(IncludedLibrary includeLibrary, Library foundLib, Map<String, Library> reloadLibs, URL url) {
    }

    public List<Library> getLibraries(int level) {
        return Collections.emptyList();
    }

    public final List<Library> getLibraries() {
        return this.getLibraries(1);
    }

    public void insertLibrary(Library library, int posn) {
    }

    public void addLibrary(Library library) {
    }

    public int dropLibrary(Library library) {
        return -1;
    }

    public final Library getLibraryWithNamespace(String namespace) {
        return this.getLibraryWithNamespace(namespace, Integer.MAX_VALUE);
    }

    public Library getLibraryWithNamespace(String namespace, int level) {
        return null;
    }

    public List<IncludedLibrary> getIncludedLibraries() {
        return Collections.emptyList();
    }

    public String getUnits() {
        return null;
    }

    public final List<IncludeScript> getIncludeScripts() {
        return (ArrayList)this.getLocalProperty(this, "includeScripts");
    }

    public Exception getFatalException() {
        return null;
    }

    protected void setFatalException(Exception fatalException) {
    }

    public final Theme findTheme(String name) {
        return (Theme)this.resolveElement(null, name, null, MetaDataDictionary.getInstance().getElement("Theme"));
    }

    public final ReportItemTheme findReportItemTheme(String name) {
        return (ReportItemTheme)this.resolveElement(null, name, null, MetaDataDictionary.getInstance().getElement("ReportItemTheme"));
    }

    @Override
    public Theme getTheme() {
        return null;
    }

    @Override
    public String getThemeName() {
        return null;
    }

    @Override
    public Theme getTheme(Module module) {
        return null;
    }

    public final IncludedLibrary findIncludedLibrary(String namespace) {
        List<IncludedLibrary> libs = this.getIncludedLibraries();
        if (libs == null) {
            return null;
        }
        IncludedLibrary includedItem = null;
        int i = 0;
        while (i < libs.size()) {
            IncludedLibrary incluedLib = libs.get(i);
            String tmpNameSpace = incluedLib.getNamespace();
            assert (tmpNameSpace != null);
            if (tmpNameSpace.equalsIgnoreCase(namespace)) {
                includedItem = incluedLib;
                break;
            }
            ++i;
        }
        return includedItem;
    }

    public final Library getLibraryByLocation(String theLocation) {
        return this.getLibraryByLocation(theLocation, 1);
    }

    public Library getLibraryByLocation(String theLocation, int level) {
        return null;
    }

    public final List<Library> getLibrariesByLocation(String theLocation, int level) {
        if (StringUtil.isBlank(theLocation)) {
            return Collections.emptyList();
        }
        ArrayList<Library> retList = new ArrayList<Library>();
        List<Library> libraries = this.getLibraries(level);
        int i = 0;
        while (i < libraries.size()) {
            Library library = libraries.get(i);
            if (theLocation.equalsIgnoreCase(library.getLocation())) {
                retList.add(library);
            }
            ++i;
        }
        return retList;
    }

    public TemplateParameterDefinition findTemplateParameterDefinition(String name) {
        return null;
    }

    public boolean isDuplicateNamespace(String namespaceToCheck) {
        return false;
    }

    public PropertyBinding findPropertyBinding(DesignElement element, String propName) {
        return null;
    }

    public List<PropertyBinding> getPropertyBindings(DesignElement element) {
        return Collections.emptyList();
    }

    public void rename(EmbeddedImage image) {
    }

    public String getNamespace() {
        return null;
    }

    public CssStyleSheet loadCss(String fileName) throws StyleSheetException {
        return null;
    }

    public CssStyleSheet loadCss(DesignElement container, URL url, String fileName) throws StyleSheetException {
        return null;
    }

    public ULocale getLocale() {
        ULocale optionLocale;
        ModuleOption option = this.getOptions();
        if (option != null && (optionLocale = option.getLocale()) != null) {
            return optionLocale;
        }
        ULocale sessionLocale = this.session.getLocale();
        if (sessionLocale != null) {
            return sessionLocale;
        }
        return ThreadResources.getLocale();
    }
}

