/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IPredefinedStyle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.elements.ReportItemTheme;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TemplateElement;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.ContentExceptionFactory;
import org.eclipse.birt.report.model.util.ContentIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContainerContextProviderImpl {
    protected ContainerContext focus = null;

    public ContainerContextProviderImpl(ContainerContext containerInfo) {
        if (containerInfo == null) {
            throw new IllegalArgumentException("The containerInfo of this context should not be null");
        }
        this.focus = containerInfo;
    }

    public final boolean canContain(Module module, String type) {
        if (type == null) {
            return false;
        }
        return this.canContain(module, MetaDataDictionary.getInstance().getElement(type));
    }

    public final boolean canContain(Module module, DesignElement element) {
        if (module != null && module.isReadOnly()) {
            return false;
        }
        List<SemanticException> errors = this.checkContainmentContext(module, element);
        return errors.isEmpty();
    }

    public boolean canContain(Module module, IElementDefn defn) {
        if (defn == null || module != null && module.isReadOnly()) {
            return false;
        }
        boolean retValue = this.canContainInRom(defn);
        if (!retValue) {
            return false;
        }
        if (this.focus.getElement().isRootIncludedByModule()) {
            return false;
        }
        if (!this.canContainTemplateElement(module, defn)) {
            return false;
        }
        if (this.focus.getElement().isVirtualElement() || this.focus.getElement().getExtendsName() != null) {
            return false;
        }
        if (this.focus.getElement() instanceof TableItem && this.focus.getElement().getBooleanProperty(module, "isSummaryTable") && this.focus.containerSlotID == 2) {
            return false;
        }
        ContainerContext containerInfo = this.focus;
        while (containerInfo != null) {
            DesignElement container = containerInfo.getElement();
            if (container instanceof ListingElement || container instanceof MasterPage) {
                List<SemanticException> errors = container.checkContent(module, this.focus, defn);
                return errors.isEmpty();
            }
            containerInfo = container.getContainerInfo();
        }
        return retValue;
    }

    public List<SemanticException> checkContainmentContext(Module module, DesignElement element) {
        if (element == null) {
            return Collections.emptyList();
        }
        boolean retValue = this.canContainInRom(element.getDefn());
        ContentException e = ContentExceptionFactory.createContentException(this.focus, element, "Error.ContentException.INVALID_CONTEXT_CONTAINMENT");
        List<SemanticException> errors = new ArrayList<SemanticException>();
        if (!retValue) {
            errors.add(e);
            return errors;
        }
        if (!this.canContainTemplateElement(module, element)) {
            errors.add(e);
            return errors;
        }
        if (this.focus.getElement().isRootIncludedByModule()) {
            errors.add(e);
            return errors;
        }
        if (this.focus.getElement().isVirtualElement() || this.focus.getElement().getExtendsName() != null) {
            errors.add(e);
            return errors;
        }
        if (this.focus.getElement() instanceof TableItem && this.focus.getElement().getBooleanProperty(module, "isSummaryTable") && this.focus.containerSlotID == 2) {
            errors.add(e);
            return errors;
        }
        if (this.focus.getElement() instanceof ReportItemTheme) {
            ReportItemTheme theme = (ReportItemTheme)this.focus.getElement();
            String type = theme.getType(theme.getRoot());
            IPredefinedStyle style = MetaDataDictionary.getInstance().getPredefinedStyle(element.getName());
            if (StringUtil.isBlank(type) || style == null || !type.equals(style.getType())) {
                errors.add(e);
                return errors;
            }
        }
        ContainerContext containerInfor = this.focus;
        while (containerInfor != null) {
            DesignElement container = containerInfor.getElement();
            if (container == element) {
                errors.add(e);
                return errors;
            }
            if (container instanceof ListingElement || container instanceof MasterPage) {
                errors = container.checkContent(module, this.focus, element);
                return errors;
            }
            containerInfor = container.getContainerInfo();
        }
        return Collections.emptyList();
    }

    private boolean canContainInRom(IElementDefn defn) {
        if (!this.focus.canContainInRom(defn)) {
            return false;
        }
        String name = defn.getName();
        if ("TemplateDataSet".equals(name) || "TemplateReportItem".equals(name) || "TemplateElement".equals(name)) {
            return true;
        }
        return this.focus.getContentCount(this.focus.getElement().getRoot()) <= 0 || this.focus.isContainerMultipleCardinality();
    }

    private boolean canContainTemplateElement(Module module, DesignElement element) {
        IElementDefn defn = MetaDataDictionary.getInstance().getElement("TemplateElement");
        if (element instanceof TemplateElement) {
            return this.canContainTemplateElement(module, defn);
        }
        ContentIterator contents = new ContentIterator(module, element);
        while (contents.hasNext()) {
            DesignElement content = contents.next();
            if (!(content instanceof TemplateElement)) continue;
            return this.canContainTemplateElement(module, defn);
        }
        return true;
    }

    private boolean canContainTemplateElement(Module module, IElementDefn defn) {
        if (defn != null && defn.isKindOf(MetaDataDictionary.getInstance().getElement("TemplateElement"))) {
            ContainerContext containerInfo = this.focus;
            while (containerInfo != null) {
                DesignElement container = containerInfo.getElement();
                if (container instanceof Module && containerInfo.getSlotID() == 5 || container instanceof Library) {
                    return false;
                }
                containerInfo = container.getContainerInfo();
            }
            if (module instanceof Library) {
                return false;
            }
        }
        return true;
    }
}

