/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.filterExtension;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.model.api.filterExtension.interfaces.IBirtFilterOperatorConstants;
import org.eclipse.birt.report.model.api.filterExtension.interfaces.IFilterExprDefinition;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

public class FilterExprDefinition
implements IFilterExprDefinition {
    protected static final int UNDEFINED = -1;
    protected String birtFilterExprId = null;
    protected String birtFilterDisplayName = null;
    protected int minArgs = -1;
    protected int maxArgs = -1;
    protected boolean supportUnboundedMaxArgs = false;

    public FilterExprDefinition() {
    }

    public FilterExprDefinition(String birtFilterExpr) throws IllegalArgumentException {
        this.birtFilterExprId = birtFilterExpr;
        this.initBirtExpr(birtFilterExpr.toLowerCase().hashCode());
    }

    public int expressionSupportedType() {
        return 0;
    }

    public String getBirtFilterExprId() {
        return this.birtFilterExprId;
    }

    public String getBirtFilterExprDisplayName() {
        return this.birtFilterDisplayName;
    }

    public String getExtFilterDisplayName() {
        return null;
    }

    public String getExtFilterExprId() {
        return null;
    }

    public Integer getMaxArguments() {
        if (this.maxArgs == -1) {
            return null;
        }
        return this.maxArgs;
    }

    public Integer getMinArguments() {
        if (this.minArgs == -1) {
            return null;
        }
        return this.minArgs;
    }

    public String getProviderExtensionId() {
        return null;
    }

    public boolean supportsUnboundedMaxArguments() {
        return this.supportUnboundedMaxArgs;
    }

    protected void initBirtExpr(int birtOperator) {
        if (IBirtFilterOperatorConstants.FILTER_OPERATOR_BETWEEN == birtOperator) {
            this.birtFilterExprId = "between";
            this.maxArgs = 2;
            this.minArgs = 2;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_BOTTOM_N == birtOperator) {
            this.birtFilterExprId = "bottom-n";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_BOTTOM_PERCENT == birtOperator) {
            this.birtFilterExprId = "bottom-percent";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_EQ == birtOperator) {
            this.birtFilterExprId = "eq";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_FALSE == birtOperator) {
            this.birtFilterExprId = "is-false";
            this.maxArgs = 0;
            this.minArgs = 0;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_GE == birtOperator) {
            this.birtFilterExprId = "ge";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_GT == birtOperator) {
            this.birtFilterExprId = "gt";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_LE == birtOperator) {
            this.birtFilterExprId = "le";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_LIKE == birtOperator) {
            this.birtFilterExprId = "like";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_LT == birtOperator) {
            this.birtFilterExprId = "lt";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_NE == birtOperator) {
            this.birtFilterExprId = "ne";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_NOT_BETWEEN == birtOperator) {
            this.birtFilterExprId = "not-between";
            this.maxArgs = 2;
            this.minArgs = 2;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_NOT_IN == birtOperator) {
            this.birtFilterExprId = "not-in";
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = true;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_NOT_NULL == birtOperator) {
            this.birtFilterExprId = "is-not-null";
            this.maxArgs = 0;
            this.minArgs = 0;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_NULL == birtOperator) {
            this.birtFilterExprId = "is-null";
            this.maxArgs = 0;
            this.minArgs = 0;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_TOP_N == birtOperator) {
            this.birtFilterExprId = "top-n";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_TOP_PERCENT == birtOperator) {
            this.birtFilterExprId = "top-percent";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_TRUE == birtOperator) {
            this.birtFilterExprId = "is-true";
            this.maxArgs = 0;
            this.minArgs = 0;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_MATCH == birtOperator) {
            this.birtFilterExprId = "match";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_NOT_LIKE == birtOperator) {
            this.birtFilterExprId = "not-like";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_NOT_MATCH == birtOperator) {
            this.birtFilterExprId = "not-match";
            this.maxArgs = 1;
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = false;
        } else if (IBirtFilterOperatorConstants.FILTER_OPERATOR_IN == birtOperator) {
            this.birtFilterExprId = "in";
            this.minArgs = 1;
            this.supportUnboundedMaxArgs = true;
        } else {
            throw new IllegalArgumentException("The Birt filter expression Id is not valid.");
        }
        if (this.birtFilterExprId != null) {
            this.birtFilterDisplayName = this.getOperatorDisplayName(this.birtFilterExprId);
        }
    }

    public boolean isNegatedExtExprId() {
        return false;
    }

    private String getOperatorDisplayName(String operator) {
        IChoiceSet allowedChoices = MetaDataDictionary.getInstance().getChoiceSet("filterOperator");
        assert (allowedChoices != null);
        IChoice choice = allowedChoices.findChoice(operator);
        if (choice != null) {
            return choice.getDisplayName();
        }
        return null;
    }

    public String getBirtFilterExprDisplayName(ULocale locale) {
        IChoiceSet allowedChoices = MetaDataDictionary.getInstance().getChoiceSet("filterOperator");
        assert (allowedChoices != null);
        IChoice choice = allowedChoices.findChoice(this.birtFilterExprId);
        if (choice != null) {
            return choice.getDisplayName(locale);
        }
        return null;
    }

    public boolean supportsAPIDataType(int apiDataType) {
        return true;
    }
}

