/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.ExpressionListHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.OperatorUtil;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.StructureContextUtil;

public class FilterConditionHandle
extends StructureHandle {
    public FilterConditionHandle(SimpleValueHandle valueHandle, int index) {
        super(valueHandle, index);
    }

    public String getExpr() {
        return this.getStringProperty("expr");
    }

    public void setExpr(String filterExpr) throws SemanticException {
        this.setProperty("expr", filterExpr);
    }

    public String getOperator() {
        return this.getStringProperty("operator");
    }

    public void setOperator(String operator) throws SemanticException {
        ActivityStack stack = this.getModule().getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.ChangeProperty", new String[]{"operator"}));
        try {
            this.setProperty("operator", operator);
            int level = OperatorUtil.computeFilterOperatorLevel(operator);
            switch (level) {
                case 1: {
                    this.setValue2(null);
                    break;
                }
                case 2: {
                    break;
                }
                case 0: {
                    this.setValue2(null);
                    this.setValue1((List)null);
                    break;
                }
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public String getValue1() {
        List valueList = this.getValue1List();
        if (valueList == null || valueList.isEmpty()) {
            return null;
        }
        return (String)valueList.get(0);
    }

    public List getValue1List() {
        List valueList = (List)this.getProperty("value1");
        if (valueList == null || valueList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(ModelUtil.getExpressionCompatibleList(valueList));
    }

    public ExpressionListHandle getValue1ExpressionList() {
        return new ExpressionListHandle(this.elementHandle, StructureContextUtil.createStructureContext(this, "value1"));
    }

    public void setValue1(String value1Expr) {
        this.setPropertySilently("value1", value1Expr);
    }

    public void setValue1(List value1List) throws SemanticException {
        this.setProperty("value1", value1List);
    }

    public String getValue2() {
        return this.getStringProperty("value2");
    }

    public void setValue2(String value2Expr) {
        this.setPropertySilently("value2", value2Expr);
    }

    public String getColumn() {
        return null;
    }

    public void setColumn(String column) {
    }

    public String getFilterExpr() {
        return this.getExpr();
    }

    public void setFilterExpr(String filterExpr) throws SemanticException {
        this.setExpr(filterExpr);
    }

    public String getValue1Expr() {
        return this.getValue1();
    }

    public void setValue1Expr(String value1Expr) {
        this.setValue1(value1Expr);
    }

    public String getValue2Expr() {
        return this.getValue2();
    }

    public void setValue2Expr(String value2Expr) {
        this.setValue2(value2Expr);
    }

    public String getFilterTarget() {
        return (String)this.getProperty("filterTarget");
    }

    public void setFilterTarget(String filterTarget) throws SemanticException {
        this.setProperty("filterTarget", filterTarget);
    }

    public boolean isOptional() {
        Boolean isOptional = (Boolean)this.getProperty("isOptional");
        if (isOptional == null) {
            return false;
        }
        return isOptional;
    }

    public void setOptional(boolean isOptional) {
        this.setPropertySilently("isOptional", isOptional);
    }

    public String getExtensionName() {
        return this.getStringProperty("extensionName");
    }

    public String getExtensionExprId() {
        return this.getStringProperty("extensionExprId");
    }

    public boolean pushDown() {
        Boolean pushDown = (Boolean)this.getProperty("pushDown");
        if (pushDown == null) {
            return false;
        }
        return pushDown;
    }

    public String getDynamicFilterParameter() {
        return this.getStringProperty("dynamicFilterParameter");
    }

    public void setExtensionName(String extensionName) {
        this.setPropertySilently("extensionName", extensionName);
    }

    public void setExtensionExprId(String extensionExprId) {
        this.setPropertySilently("extensionExprId", extensionExprId);
    }

    public void setPushDown(boolean pushDown) {
        this.setPropertySilently("pushDown", pushDown);
    }

    public void setDynamicFilterParameter(String parameterName) {
        this.setPropertySilently("dynamicFilterParameter", parameterName);
    }
}

