/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.utility;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IFieldInfo;
import org.eclipse.jpt.core.internal.utility.KeyClassesValidator;
import org.eclipse.jpt.eclipselink.core.internal.JptEclipseLinkCoreMessages;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jst.common.project.facet.core.libprov.user.UserLibraryProviderInstallOperationConfig;
import org.eclipse.jst.common.project.facet.core.libprov.user.UserLibraryValidator;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkLibraryValidator
extends UserLibraryValidator {
    private static final String VERSION_CLASS_PATH = "org/eclipse/persistence/Version.class";
    private static final String VERSION_FIELD_NAME = "version";
    private static final String VERSION_RANGE_PREFIX = "version-range:";
    private static final String KEY_CLASS_PREFIX = "key-class:";
    private final List<VersionRange> versionRanges = new ArrayList<VersionRange>();
    private final List<String> keyClasses = new ArrayList<String>();
    private final KeyClassesValidator keyClassesValidator = new KeyClassesValidator();

    public void init(List<String> params) {
        for (String param : params) {
            if (param.startsWith(VERSION_RANGE_PREFIX)) {
                this.versionRanges.add(new VersionRange(param.replaceFirst(VERSION_RANGE_PREFIX, "")));
                continue;
            }
            if (!param.startsWith(KEY_CLASS_PREFIX)) continue;
            this.keyClasses.add(param.replaceFirst(KEY_CLASS_PREFIX, ""));
        }
        this.keyClassesValidator.init(this.keyClasses);
    }

    public IStatus validate(UserLibraryProviderInstallOperationConfig config) {
        if (!this.keyClassesValidator.validate(config).isOK()) {
            return new Status(4, "org.eclipse.jpt.eclipselink.core", JptEclipseLinkCoreMessages.EclipseLinkLibraryValidator_invalidJpaLibrary);
        }
        Version version = null;
        for (IClasspathEntry cpe : config.resolve()) {
            String versionString = null;
            if (cpe.getEntryKind() != 1) continue;
            IClassFileReader classReader = ToolFactory.createDefaultClassFileReader((String)cpe.getPath().toFile().getAbsolutePath(), (String)VERSION_CLASS_PATH, (int)5);
            if (classReader != null) {
                IFieldInfo[] iFieldInfoArray = classReader.getFieldInfos();
                int n = iFieldInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IFieldInfo field = iFieldInfoArray[n2];
                    if (StringTools.stringsAreEqual((char[])field.getName(), (char[])VERSION_FIELD_NAME.toCharArray())) {
                        try {
                            versionString = field.getConstantValueAttribute().getConstantValue().getStringValue();
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    ++n2;
                }
            }
            if (versionString == null) continue;
            if (version != null) {
                return new Status(4, "org.eclipse.jpt.eclipselink.core", JptEclipseLinkCoreMessages.EclipseLinkLibraryValidator_multipleEclipseLinkVersions);
            }
            version = new Version(versionString);
        }
        if (version == null) {
            return new Status(4, "org.eclipse.jpt.eclipselink.core", JptEclipseLinkCoreMessages.EclipseLinkLibraryValidator_noEclipseLinkVersion);
        }
        for (VersionRange versionRange : this.versionRanges) {
            if (versionRange.isIncluded(version)) continue;
            return new Status(4, "org.eclipse.jpt.eclipselink.core", JptEclipseLinkCoreMessages.EclipseLinkLibraryValidator_improperEclipseLinkVersion);
        }
        return Status.OK_STATUS;
    }
}

