/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.orm;

import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkChangeTracking;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkChangeTrackingType;
import org.eclipse.jpt.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlChangeTracking;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlChangeTrackingHolder;

public class OrmEclipseLinkChangeTracking
extends AbstractOrmXmlContextNode
implements EclipseLinkChangeTracking {
    protected final XmlChangeTrackingHolder resource;
    protected EclipseLinkChangeTrackingType defaultType;
    protected EclipseLinkChangeTrackingType specifiedType;

    public OrmEclipseLinkChangeTracking(OrmTypeMapping parent, XmlChangeTrackingHolder resource, EclipseLinkChangeTracking javaChangeTracking) {
        super((JpaContextNode)parent);
        this.resource = resource;
        this.defaultType = this.calculateDefaultType(javaChangeTracking);
        this.specifiedType = this.getResourceChangeTracking();
    }

    public EclipseLinkChangeTrackingType getType() {
        return this.getSpecifiedType() != null ? this.getSpecifiedType() : this.getDefaultType();
    }

    public EclipseLinkChangeTrackingType getDefaultType() {
        return this.defaultType;
    }

    protected void setDefaultType_(EclipseLinkChangeTrackingType newDefaultType) {
        EclipseLinkChangeTrackingType oldDefaultType = this.defaultType;
        this.defaultType = newDefaultType;
        this.firePropertyChanged("defaultType", (Object)oldDefaultType, (Object)newDefaultType);
    }

    public EclipseLinkChangeTrackingType getSpecifiedType() {
        return this.specifiedType;
    }

    public void setSpecifiedType(EclipseLinkChangeTrackingType newSpecifiedType) {
        EclipseLinkChangeTrackingType oldSpecifiedType = this.specifiedType;
        this.specifiedType = newSpecifiedType;
        if (newSpecifiedType == null) {
            this.resource.setChangeTracking(null);
        } else {
            if (this.resource.getChangeTracking() == null) {
                this.resource.setChangeTracking(EclipseLinkOrmFactory.eINSTANCE.createXmlChangeTracking());
            }
            this.resource.getChangeTracking().setType(EclipseLinkChangeTrackingType.toOrmResourceModel(newSpecifiedType));
        }
        this.firePropertyChanged("specifiedType", (Object)oldSpecifiedType, (Object)newSpecifiedType);
    }

    protected void setSpecifiedType_(EclipseLinkChangeTrackingType newSpecifiedType) {
        EclipseLinkChangeTrackingType oldSpecifiedType = this.specifiedType;
        this.specifiedType = newSpecifiedType;
        this.firePropertyChanged("specifiedType", (Object)oldSpecifiedType, (Object)newSpecifiedType);
    }

    protected void update(EclipseLinkChangeTracking javaChangeTracking) {
        this.setDefaultType_(this.calculateDefaultType(javaChangeTracking));
        this.setSpecifiedType_(this.getResourceChangeTracking());
    }

    protected EclipseLinkChangeTrackingType calculateDefaultType(EclipseLinkChangeTracking javaChangeTracking) {
        return javaChangeTracking != null ? javaChangeTracking.getType() : EclipseLinkChangeTracking.DEFAULT_TYPE;
    }

    protected EclipseLinkChangeTrackingType getResourceChangeTracking() {
        XmlChangeTracking xmlChangeTracking = this.resource.getChangeTracking();
        return xmlChangeTracking != null ? EclipseLinkChangeTrackingType.fromOrmResourceModel(xmlChangeTracking.getType()) : null;
    }

    public TextRange getValidationTextRange() {
        return this.resource.getValidationTextRange();
    }
}

