/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkJoinFetch;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkJoinFetchType;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkJoinFetchAnnotation;

public class JavaEclipseLinkJoinFetch
extends AbstractJavaJpaContextNode
implements EclipseLinkJoinFetch {
    protected EclipseLinkJoinFetchType joinFetchValue;
    protected JavaResourcePersistentAttribute resourcePersistentAttribute;

    public JavaEclipseLinkJoinFetch(JavaAttributeMapping parent) {
        super((JpaContextNode)parent);
    }

    protected String getJoinFetchAnnotationName() {
        return "org.eclipse.persistence.annotations.JoinFetch";
    }

    protected EclipseLinkJoinFetchAnnotation getResourceJoinFetch() {
        return (EclipseLinkJoinFetchAnnotation)this.resourcePersistentAttribute.getAnnotation(this.getJoinFetchAnnotationName());
    }

    protected void addResourceJoinFetch() {
        this.resourcePersistentAttribute.addAnnotation(this.getJoinFetchAnnotationName());
    }

    protected void removeResourceJoinFetch() {
        this.resourcePersistentAttribute.removeAnnotation(this.getJoinFetchAnnotationName());
    }

    public EclipseLinkJoinFetchType getValue() {
        return this.joinFetchValue;
    }

    protected EclipseLinkJoinFetchType getDefaultValue() {
        return EclipseLinkJoinFetch.DEFAULT_VALUE;
    }

    public void setValue(EclipseLinkJoinFetchType newJoinFetchValue) {
        if (this.joinFetchValue == newJoinFetchValue) {
            return;
        }
        EclipseLinkJoinFetchType oldJoinFetchValue = this.joinFetchValue;
        this.joinFetchValue = newJoinFetchValue;
        if (newJoinFetchValue != null) {
            if (this.getResourceJoinFetch() == null) {
                this.addResourceJoinFetch();
            }
            this.getResourceJoinFetch().setValue(EclipseLinkJoinFetchType.toJavaResourceModel(newJoinFetchValue));
        } else if (this.getResourceJoinFetch() != null) {
            this.removeResourceJoinFetch();
        }
        this.firePropertyChanged("value", (Object)oldJoinFetchValue, (Object)newJoinFetchValue);
    }

    protected void setValue_(EclipseLinkJoinFetchType newJoinFetchValue) {
        EclipseLinkJoinFetchType oldJoinFetchValue = this.joinFetchValue;
        this.joinFetchValue = newJoinFetchValue;
        this.firePropertyChanged("value", (Object)oldJoinFetchValue, (Object)newJoinFetchValue);
    }

    public void initialize(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistentAttribute = jrpa;
        EclipseLinkJoinFetchAnnotation resourceJoinFetch = this.getResourceJoinFetch();
        this.joinFetchValue = this.joinFetch(resourceJoinFetch);
    }

    public void update(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistentAttribute = jrpa;
        EclipseLinkJoinFetchAnnotation resourceJoinFetch = this.getResourceJoinFetch();
        this.setValue_(this.joinFetch(resourceJoinFetch));
    }

    private EclipseLinkJoinFetchType joinFetch(EclipseLinkJoinFetchAnnotation resourceJoinFetch) {
        if (resourceJoinFetch == null) {
            return null;
        }
        if (resourceJoinFetch.getValue() == null) {
            return this.getDefaultValue();
        }
        return EclipseLinkJoinFetchType.fromJavaResourceModel(resourceJoinFetch.getValue());
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        EclipseLinkJoinFetchAnnotation resourceJoinFetch = this.getResourceJoinFetch();
        return resourceJoinFetch == null ? null : resourceJoinFetch.getTextRange(astRoot);
    }
}

