/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkCustomizer;
import org.eclipse.jpt.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.eclipselink.core.internal.EclipseLinkJpaFactory;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkCustomizerAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEclipseLinkCustomizer
extends AbstractJavaJpaContextNode
implements EclipseLinkCustomizer {
    private JavaResourcePersistentType resourcePersistentType;
    private String customizerClass;
    private String fullyQualifiedCustomizerClass;
    public static final String FULLY_QUALIFIED_CUSTOMIZER_CLASS_PROPERTY = "fullyQualifiedCustomizerClass";

    public JavaEclipseLinkCustomizer(JavaJpaContextNode parent) {
        super((JpaContextNode)parent);
    }

    @Override
    public char getCustomizerClassEnclosingTypeSeparator() {
        return '.';
    }

    protected EclipseLinkJpaFactory getJpaFactory() {
        return (EclipseLinkJpaFactory)super.getJpaFactory();
    }

    protected String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Customizer";
    }

    protected void addResourceCustomizer() {
        this.resourcePersistentType.addAnnotation(this.getAnnotationName());
    }

    protected void removeResourceCustomizer() {
        this.resourcePersistentType.removeAnnotation(this.getAnnotationName());
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getResourceCustomizer().getTextRange(astRoot);
    }

    protected EclipseLinkCustomizerAnnotation getResourceCustomizer() {
        return (EclipseLinkCustomizerAnnotation)this.resourcePersistentType.getAnnotation(this.getAnnotationName());
    }

    @Override
    public String getCustomizerClass() {
        return this.getSpecifiedCustomizerClass();
    }

    @Override
    public String getDefaultCustomizerClass() {
        return null;
    }

    @Override
    public String getSpecifiedCustomizerClass() {
        return this.customizerClass;
    }

    public String getFullyQualifiedCustomizerClass() {
        return this.fullyQualifiedCustomizerClass;
    }

    protected void setFullyQualifiedCustomizerClass(String customizerClass) {
        String old = this.fullyQualifiedCustomizerClass;
        this.fullyQualifiedCustomizerClass = customizerClass;
        this.firePropertyChanged(FULLY_QUALIFIED_CUSTOMIZER_CLASS_PROPERTY, old, customizerClass);
    }

    protected String buildFullyQualifiedCustomizerClass(EclipseLinkCustomizerAnnotation resourceCustomizer) {
        return resourceCustomizer == null ? null : resourceCustomizer.getFullyQualifiedCustomizerClassName();
    }

    @Override
    public void setSpecifiedCustomizerClass(String newCustomizerClass) {
        if (this.attributeValueHasNotChanged(this.customizerClass, newCustomizerClass)) {
            return;
        }
        String oldCustomizerClass = this.customizerClass;
        this.customizerClass = newCustomizerClass;
        if (this.customizerClass != null) {
            this.addResourceCustomizer();
        } else {
            this.removeResourceCustomizer();
        }
        if (newCustomizerClass != null) {
            this.getResourceCustomizer().setValue(newCustomizerClass);
        }
        this.firePropertyChanged("specifiedCustomizerClass", oldCustomizerClass, newCustomizerClass);
    }

    protected void setCustomizerClass_(String newCustomizerClass) {
        String oldCustomizerClass = this.customizerClass;
        this.customizerClass = newCustomizerClass;
        this.firePropertyChanged("specifiedCustomizerClass", oldCustomizerClass, newCustomizerClass);
    }

    public void initialize(JavaResourcePersistentType jrpt) {
        this.resourcePersistentType = jrpt;
        EclipseLinkCustomizerAnnotation resourceCustomizer = this.getResourceCustomizer();
        this.customizerClass = this.customizerClass(resourceCustomizer);
        this.fullyQualifiedCustomizerClass = this.buildFullyQualifiedCustomizerClass(resourceCustomizer);
    }

    public void update(JavaResourcePersistentType jrpt) {
        this.resourcePersistentType = jrpt;
        EclipseLinkCustomizerAnnotation resourceCustomizer = this.getResourceCustomizer();
        this.setCustomizerClass_(this.customizerClass(resourceCustomizer));
        this.setFullyQualifiedCustomizerClass(this.buildFullyQualifiedCustomizerClass(resourceCustomizer));
    }

    protected String customizerClass(EclipseLinkCustomizerAnnotation resourceCustomizer) {
        return resourceCustomizer == null ? null : resourceCustomizer.getValue();
    }

    public TextRange getCustomizerClassTextRange(CompilationUnit astRoot) {
        return this.getResourceCustomizer().getValueTextRange(astRoot);
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateConverterClass(messages, astRoot);
    }

    protected void validateConverterClass(List<IMessage> messages, CompilationUnit astRoot) {
        EclipseLinkCustomizerAnnotation resourceCustomizer = this.getResourceCustomizer();
        if (resourceCustomizer != null && !resourceCustomizer.customizerClassImplementsInterface("org.eclipse.persistence.config.DescriptorCustomizer", astRoot)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CUSTOMIZER_CLASS_IMPLEMENTS_DESCRIPTOR_CUSTOMIZER", new String[]{this.customizerClass}, this, this.getCustomizerClassTextRange(astRoot)));
        }
    }
}

