/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaConverter;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.eclipselink.core.internal.context.java.JavaEclipseLinkConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.java.JavaEclipseLinkCustomConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.java.JavaEclipseLinkObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.java.JavaEclipseLinkStructConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.java.JavaEclipseLinkTypeConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkConvertAnnotation;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEclipseLinkConvert
extends AbstractJavaJpaContextNode
implements EclipseLinkConvert,
JavaConverter {
    private String specifiedConverterName;
    private JavaResourcePersistentAttribute resourcePersistentAttribute;
    private JavaEclipseLinkConverter converter;

    public JavaEclipseLinkConvert(JavaAttributeMapping parent, JavaResourcePersistentAttribute jrpa) {
        super((JpaContextNode)parent);
        this.initialize(jrpa);
    }

    public JavaAttributeMapping getParent() {
        return (JavaAttributeMapping)super.getParent();
    }

    public String getType() {
        return "eclipseLinkConverter";
    }

    protected String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Convert";
    }

    public void addToResourceModel() {
        this.resourcePersistentAttribute.addAnnotation(this.getAnnotationName());
    }

    public void removeFromResourceModel() {
        this.resourcePersistentAttribute.removeAnnotation(this.getAnnotationName());
        if (this.getConverter() != null) {
            this.resourcePersistentAttribute.removeAnnotation(this.getConverter().getAnnotationName());
        }
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getResourceConvert().getTextRange(astRoot);
    }

    protected EclipseLinkConvertAnnotation getResourceConvert() {
        return (EclipseLinkConvertAnnotation)this.resourcePersistentAttribute.getAnnotation(this.getAnnotationName());
    }

    @Override
    public String getConverterName() {
        return this.getSpecifiedConverterName() == null ? this.getDefaultConverterName() : this.getSpecifiedConverterName();
    }

    @Override
    public String getDefaultConverterName() {
        return "none";
    }

    @Override
    public String getSpecifiedConverterName() {
        return this.specifiedConverterName;
    }

    @Override
    public void setSpecifiedConverterName(String newSpecifiedConverterName) {
        String oldSpecifiedConverterName = this.specifiedConverterName;
        this.specifiedConverterName = newSpecifiedConverterName;
        this.getResourceConvert().setValue(newSpecifiedConverterName);
        this.firePropertyChanged("specifiedConverterName", oldSpecifiedConverterName, newSpecifiedConverterName);
    }

    protected void setSpecifiedConverterName_(String newSpecifiedConverterName) {
        String oldSpecifiedConverterName = this.specifiedConverterName;
        this.specifiedConverterName = newSpecifiedConverterName;
        this.firePropertyChanged("specifiedConverterName", oldSpecifiedConverterName, newSpecifiedConverterName);
    }

    @Override
    public JavaEclipseLinkConverter getConverter() {
        return this.converter;
    }

    protected String getConverterType() {
        if (this.converter == null) {
            return "noConverter";
        }
        return this.converter.getType();
    }

    @Override
    public void setConverter(String converterType) {
        if (this.getConverterType() == converterType) {
            return;
        }
        JavaEclipseLinkConverter oldConverter = this.converter;
        JavaEclipseLinkConverter newConverter = this.buildConverter(converterType);
        this.converter = null;
        if (oldConverter != null) {
            this.resourcePersistentAttribute.removeAnnotation(oldConverter.getAnnotationName());
        }
        this.converter = newConverter;
        if (newConverter != null) {
            this.resourcePersistentAttribute.addAnnotation(newConverter.getAnnotationName());
        }
        this.firePropertyChanged("converter", oldConverter, newConverter);
    }

    protected void setConverter(JavaEclipseLinkConverter newConverter) {
        JavaEclipseLinkConverter oldConverter = this.converter;
        this.converter = newConverter;
        this.firePropertyChanged("converter", oldConverter, newConverter);
    }

    protected void initialize(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistentAttribute = jrpa;
        this.specifiedConverterName = this.getResourceConverterName();
        this.converter = this.buildConverter(this.getResourceConverterType());
    }

    public void update(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistentAttribute = jrpa;
        this.setSpecifiedConverterName_(this.getResourceConverterName());
        if (this.getResourceConverterType() == this.getConverterType()) {
            this.getConverter().update((JavaResourcePersistentMember)this.resourcePersistentAttribute);
        } else {
            JavaEclipseLinkConverter javaConverter = this.buildConverter(this.getResourceConverterType());
            this.setConverter(javaConverter);
        }
    }

    protected String getResourceConverterName() {
        EclipseLinkConvertAnnotation resourceConvert = this.getResourceConvert();
        return resourceConvert == null ? null : resourceConvert.getValue();
    }

    protected JavaEclipseLinkConverter buildConverter(String converterType) {
        if (converterType == "noConverter") {
            return null;
        }
        if (converterType == "customConverter") {
            return this.buildCustomConverter();
        }
        if (converterType == "typeConverter") {
            return this.buildTypeConverter();
        }
        if (converterType == "objectTypeConverter") {
            return this.buildObjectTypeConverter();
        }
        if (converterType == "structConverter") {
            return this.buildStructConverter();
        }
        return null;
    }

    protected JavaEclipseLinkCustomConverter buildCustomConverter() {
        JavaEclipseLinkCustomConverter contextConverter = new JavaEclipseLinkCustomConverter((JavaJpaContextNode)this);
        contextConverter.initialize((JavaResourcePersistentMember)this.resourcePersistentAttribute);
        return contextConverter;
    }

    protected JavaEclipseLinkTypeConverter buildTypeConverter() {
        JavaEclipseLinkTypeConverter contextConverter = new JavaEclipseLinkTypeConverter((JavaJpaContextNode)this);
        contextConverter.initialize((JavaResourcePersistentMember)this.resourcePersistentAttribute);
        return contextConverter;
    }

    protected JavaEclipseLinkObjectTypeConverter buildObjectTypeConverter() {
        JavaEclipseLinkObjectTypeConverter contextConverter = new JavaEclipseLinkObjectTypeConverter((JavaJpaContextNode)this);
        contextConverter.initialize((JavaResourcePersistentMember)this.resourcePersistentAttribute);
        return contextConverter;
    }

    protected JavaEclipseLinkStructConverter buildStructConverter() {
        JavaEclipseLinkStructConverter contextConverter = new JavaEclipseLinkStructConverter((JavaJpaContextNode)this);
        contextConverter.initialize((JavaResourcePersistentMember)this.resourcePersistentAttribute);
        return contextConverter;
    }

    protected String getResourceConverterType() {
        if (this.resourcePersistentAttribute.getAnnotation("org.eclipse.persistence.annotations.Converter") != null) {
            return "customConverter";
        }
        if (this.resourcePersistentAttribute.getAnnotation("org.eclipse.persistence.annotations.TypeConverter") != null) {
            return "typeConverter";
        }
        if (this.resourcePersistentAttribute.getAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter") != null) {
            return "objectTypeConverter";
        }
        if (this.resourcePersistentAttribute.getAnnotation("org.eclipse.persistence.annotations.StructConverter") != null) {
            return "structConverter";
        }
        return null;
    }

    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.convertValueTouches(pos, astRoot) && (result = this.persistenceConvertersNames(filter)) != null) {
            return result;
        }
        return null;
    }

    protected boolean convertValueTouches(int pos, CompilationUnit astRoot) {
        if (this.getResourceConvert() != null) {
            return this.getResourceConvert().valueTouches(pos, astRoot);
        }
        return false;
    }

    protected Iterator<String> persistenceConvertersNames() {
        if (this.getEclipseLinkPersistenceUnit().convertersSize() == 0) {
            return EmptyIterator.instance();
        }
        return CollectionTools.iterator((Object[])this.getEclipseLinkPersistenceUnit().uniqueConverterNames());
    }

    private Iterator<String> convertersNames(Filter<String> filter) {
        return new FilteringIterator(this.persistenceConvertersNames(), filter);
    }

    protected Iterator<String> persistenceConvertersNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.convertersNames(filter));
    }

    protected EclipseLinkPersistenceUnit getEclipseLinkPersistenceUnit() {
        return (EclipseLinkPersistenceUnit)this.getPersistenceUnit();
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.getConverter() != null) {
            this.getConverter().validate(messages, reporter, astRoot);
        }
    }
}

