/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jst.ws.jaxws.utils.annotations.IValue;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.ValueImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayValueImpl
extends ValueImpl {
    private Set<IValue> values = new HashSet<IValue>();

    public ArrayValueImpl(Set<IValue> values) {
        if (values == null) {
            throw new NullPointerException("values should not be null");
        }
        this.values = values;
    }

    @Override
    public String toString() {
        String result = "[";
        boolean first = true;
        for (IValue value : this.values) {
            if (first) {
                result = String.valueOf(result) + value.toString();
                first = false;
                continue;
            }
            result = String.valueOf(result) + ", " + value.toString();
        }
        result = String.valueOf(result) + "]";
        return result;
    }

    @Override
    protected Expression getExpression(CompilationUnit unit, AST ast) {
        ArrayInitializer arr = ast.newArrayInitializer();
        for (IValue value : this.values) {
            arr.expressions().add(((ValueImpl)value).getExpression(unit, ast));
        }
        return arr;
    }

    public int hashCode() {
        return Arrays.hashCode(this.values.toArray(new IValue[this.values.size()]));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayValueImpl other = (ArrayValueImpl)obj;
        return Arrays.equals(this.values.toArray(new IValue[this.values.size()]), other.values.toArray(new IValue[this.values.size()]));
    }
}

