/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion.provider;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.ui.completion.IHelpResolver;
import org.eclipse.ease.ui.completion.IImageResolver;
import org.eclipse.ease.ui.completion.ScriptCompletionProposal;
import org.eclipse.ease.ui.completion.provider.ICompletionProvider;
import org.eclipse.ease.ui.completion.tokenizer.TokenList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractCompletionProvider
implements ICompletionProvider {
    private Collection<ScriptCompletionProposal> fProposals = null;
    private ICompletionContext fContext;

    protected static ModuleDefinition getModuleDefinition(String identifier) {
        IScriptService scriptService = ScriptService.getService();
        return scriptService.getModuleDefinition(identifier);
    }

    @Override
    public boolean isActive(ICompletionContext context) {
        return context.isValid();
    }

    @Override
    public Collection<ScriptCompletionProposal> getProposals(ICompletionContext context) {
        this.fContext = context;
        this.fProposals = new ArrayList<ScriptCompletionProposal>();
        this.prepareProposals(context);
        Collection<ScriptCompletionProposal> result = this.fProposals;
        this.fProposals = null;
        this.fContext = null;
        return result;
    }

    public ICompletionContext getContext() {
        return this.fContext;
    }

    protected void addProposal(ScriptCompletionProposal proposal) {
        this.fProposals.add(proposal);
    }

    protected void addProposal(StyledString displayString, String replacementString, IImageResolver imageResolver, int priority, IHelpResolver helpResolver) {
        this.fProposals.add(new ScriptCompletionProposal(this.fContext, displayString, replacementString, imageResolver, priority, helpResolver));
    }

    protected void addProposal(String displayString, String replacementString, IImageResolver imageResolver, int priority, IHelpResolver helpResolver) {
        this.fProposals.add(new ScriptCompletionProposal(this.fContext, displayString, replacementString, imageResolver, priority, helpResolver));
    }

    protected boolean matchesFilter(String proposal) {
        return AbstractCompletionProvider.matches(this.fContext.getFilter(), proposal);
    }

    protected boolean matchesFilterIgnoreCase(String proposal) {
        return AbstractCompletionProvider.matchesIgnoreCase(this.fContext.getFilter(), proposal);
    }

    protected boolean isMethodParameter(ICompletionContext context, Method calledMethod, int parameterIndex) {
        return this.isMethodParameter(context, calledMethod.getName(), parameterIndex);
    }

    protected boolean isMethodParameter(ICompletionContext context, String calledMethod, int parameterIndex) {
        return this.isMethodCall(context) && this.matchesMethodName(context, calledMethod) && this.isParameterIndex(context, parameterIndex);
    }

    protected boolean isStringParameter(ICompletionContext context) {
        return this.isMethodCall(context) && this.isStringLiteral(context);
    }

    protected boolean isStringLiteral(ICompletionContext context) {
        List stringTokens = context.getTokens().stream().filter(t -> t instanceof String).map(t -> (String)t).collect(Collectors.toList());
        for (String token : stringTokens) {
            if (!context.isStringLiteral(token)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesMethodName(ICompletionContext context, String name) {
        List tokens = context.getTokens();
        TokenList candidates = new TokenList(tokens).getFromLast(Method.class);
        if (!candidates.isEmpty()) {
            return name.equals(((Method)candidates.get(0)).getName());
        }
        candidates = new TokenList(context.getTokens()).getFromLast("(");
        if (!candidates.isEmpty() && candidates.size() < tokens.size()) {
            Object methodName = tokens.get(tokens.size() - 1 - candidates.size());
            return name.equals(methodName);
        }
        return false;
    }

    private boolean isMethodCall(ICompletionContext context) {
        TokenList candidates = new TokenList(context.getTokens()).getFromLast(Method.class);
        if (!candidates.isEmpty()) {
            for (Object token : candidates.subList(1, candidates.size())) {
                if (token instanceof String) continue;
                return false;
            }
            return true;
        }
        candidates = new TokenList(context.getTokens()).getFromLast("(");
        if (!candidates.isEmpty()) {
            for (Object token : candidates) {
                if (token instanceof String) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isParameterIndex(ICompletionContext context, int parameterIndex) {
        TokenList candidates = new TokenList(context.getTokens()).getFromLast("(");
        if (!candidates.isEmpty()) {
            candidates.remove(0);
            return (long)parameterIndex == candidates.stream().filter(t -> ",".equals(t)).count();
        }
        return false;
    }

    protected static boolean matches(String filter, String proposal) {
        return filter == null || proposal.startsWith(filter);
    }

    protected static boolean matchesIgnoreCase(String filter, String proposal) {
        return filter == null || proposal.toLowerCase().startsWith(filter.toLowerCase());
    }

    protected abstract void prepareProposals(ICompletionContext var1);

    public static class DescriptorImageResolver
    implements IImageResolver {
        private final ImageDescriptor fDescriptor;

        public DescriptorImageResolver() {
            this.fDescriptor = null;
        }

        public DescriptorImageResolver(ImageDescriptor descriptor) {
            this.fDescriptor = descriptor;
        }

        @Override
        public Image getImage() {
            return this.getDescriptor() != null ? this.getDescriptor().createImage() : null;
        }

        protected ImageDescriptor getDescriptor() {
            return this.fDescriptor;
        }
    }

    public static class WorkbenchDescriptorImageResolver
    extends DescriptorImageResolver {
        private final String fIdentifier;

        public WorkbenchDescriptorImageResolver(String identifier) {
            this.fIdentifier = identifier;
        }

        @Override
        protected ImageDescriptor getDescriptor() {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(this.fIdentifier);
        }
    }
}

