/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.git;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.RawParseUtils;

public class GitModule
extends AbstractScriptModule {
    private static String getGitProjectName(String remoteLocation) {
        int lastSlashPosition = remoteLocation.lastIndexOf(47);
        if (lastSlashPosition >= 0) {
            int lastDotPosition = remoteLocation.indexOf(46, lastSlashPosition);
            if (lastDotPosition >= 0) {
                return remoteLocation.substring(lastSlashPosition + 1, lastDotPosition);
            }
            return remoteLocation.substring(lastSlashPosition + 1);
        }
        return remoteLocation;
    }

    @WrapToScript
    public Git clone(String remoteLocation, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object localLocation, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String user, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String pass, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String branch) throws InvalidRemoteException, TransportException, GitAPIException {
        Object resource;
        File folder;
        if (localLocation == null) {
            IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getRawLocation();
            localLocation = workspacePath.append(GitModule.getGitProjectName(remoteLocation));
        }
        if (!(folder = ResourceTools.toFile((Object)(resource = ResourceTools.resolve((Object)localLocation, (Object)this.getScriptEngine().getExecutedFile())))).exists()) {
            folder.mkdirs();
        }
        if (ResourceTools.isFolder((Object)folder)) {
            CloneCommand cloneCommand = Git.cloneRepository();
            cloneCommand.setURI(remoteLocation);
            cloneCommand.setDirectory(folder);
            if (user != null && pass != null) {
                cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(user, pass));
            }
            if (branch != null) {
                cloneCommand.setBranchesToClone(Arrays.asList(branch));
            }
            Git result = cloneCommand.call();
            GitModule.addToEGit(result.getRepository().getDirectory());
            return result;
        }
        throw new RuntimeException("invalid local folder detected: " + localLocation);
    }

    @WrapToScript
    public Git openRepository(Object location) throws IOException {
        File folder;
        if (location instanceof Git) {
            return (Git)location;
        }
        Object resource = ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile());
        if (resource != null && (folder = ResourceTools.toFile((Object)resource)) != null) {
            return Git.open((File)folder);
        }
        throw new RuntimeException("Invalid folder location: " + location);
    }

    @WrapToScript
    public Git initRepository(Object location, @ScriptParameter(defaultValue="false") boolean bare) throws GitAPIException {
        Object resource = ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile());
        File folder = ResourceTools.toFile((Object)resource);
        if (folder != null) {
            if (!folder.exists()) {
                folder.mkdirs();
            }
            Git result = Git.init().setDirectory(folder).setBare(bare).call();
            GitModule.addToEGit(result.getRepository().getDirectory());
            return result;
        }
        throw new RuntimeException("Invalid folder location: " + location);
    }

    @WrapToScript
    public void setRepositoryConfig(Git repository, String section, String subsection, String name, String value) {
        repository.getRepository().getConfig().setString(section, subsection, name, value.toString());
    }

    @WrapToScript
    public String getRepositoryConfig(Git repository, String section, String subsection, String name) {
        return repository.getRepository().getConfig().getString(section, subsection, name);
    }

    private static void addToEGit(File directory) {
    }

    @WrapToScript
    public RevCommit commit(Object repository, String message, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String author, @ScriptParameter(defaultValue="false") boolean amend) throws IOException, GitAPIException {
        Git repo = this.openRepository(repository);
        if (repo != null) {
            return repo.commit().setMessage(message).setAuthor(RawParseUtils.parsePersonIdent((String)(author != null ? author : ""))).setAmend(amend).call();
        }
        throw new RuntimeException("No repository found at: " + repository);
    }

    @WrapToScript
    public DirCache add(Object repository, String filepattern) throws IOException, NoFilepatternException, GitAPIException {
        Git repo = this.openRepository(repository);
        if (repo != null) {
            return repo.add().addFilepattern(filepattern).call();
        }
        throw new RuntimeException("No repository found at: " + repository);
    }

    @WrapToScript
    public Status getStatus(Object repository) throws IOException, GitAPIException {
        Git repo = this.openRepository(repository);
        if (repo != null) {
            return repo.status().call();
        }
        throw new RuntimeException("No repository found at: " + repository);
    }

    @WrapToScript
    public Iterable<PushResult> push(Object repository) throws IOException, GitAPIException {
        Git repo = this.openRepository(repository);
        if (repo != null) {
            return repo.push().call();
        }
        throw new RuntimeException("No repository found at: " + repository);
    }

    @WrapToScript
    public PullResult pull(Object repository) throws IOException, GitAPIException {
        Git repo = this.openRepository(repository);
        if (repo != null) {
            return repo.pull().call();
        }
        throw new RuntimeException("No repository found at: " + repository);
    }
}

