/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ease.modules.ModuleDefinition;

public class ModuleTracker {
    private final List<ModuleState> fAvailableModules = new ArrayList<ModuleState>();

    public ModuleState addModule(ModuleDefinition definition) {
        ModuleState state = new ModuleState();
        state.setModuleDefinition(definition);
        this.fAvailableModules.add(0, state);
        return state;
    }

    public ModuleState addInstance(Object instance) {
        ModuleState state = new ModuleState();
        this.fAvailableModules.add(0, state);
        state.setInstance(instance);
        return state;
    }

    public ModuleState getModuleState(ModuleDefinition definition) {
        for (ModuleState state : this.fAvailableModules) {
            if (state.getModuleDefinition() == null || !definition.getId().equals(state.getModuleDefinition().getId())) continue;
            return state;
        }
        return null;
    }

    public ModuleState getOrCreateModuleState(ModuleDefinition definition) {
        ModuleState state = this.getModuleState(definition);
        return state != null ? state : this.addModule(definition);
    }

    public List<ModuleState> getAvailableModules() {
        return this.fAvailableModules;
    }

    public class ModuleState {
        private Object fInstance;
        private ModuleDefinition fModuleDefinition;
        private boolean fWrapped = false;

        public void setInstance(Object instance) {
            this.fInstance = instance;
            this.pushUp();
        }

        public Object getInstance() {
            return this.fInstance;
        }

        public void setModuleDefinition(ModuleDefinition moduleDefinition) {
            this.fModuleDefinition = moduleDefinition;
        }

        public ModuleDefinition getModuleDefinition() {
            return this.fModuleDefinition;
        }

        public boolean isLoaded() {
            return this.fInstance != null;
        }

        public boolean isWrapped() {
            return this.fWrapped;
        }

        public void setWrapped(boolean wrapped) {
            this.fWrapped = wrapped;
            this.pushUp();
        }

        private void pushUp() {
            ModuleTracker.this.fAvailableModules.remove(this);
            ModuleTracker.this.fAvailableModules.add(0, this);
        }
    }
}

