/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging.dispatcher;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.ease.Logger;
import org.eclipse.ease.debugging.DebugTracer;
import org.eclipse.ease.debugging.dispatcher.IEventProcessor;
import org.eclipse.ease.debugging.events.IDebugEvent;
import org.eclipse.ease.debugging.events.debugger.IDebuggerEvent;
import org.eclipse.ease.debugging.events.model.IModelRequest;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class EventDispatchJob
extends Job {
    private final List<IDebugEvent> fEvents = new ArrayList<IDebugEvent>();
    private boolean fTerminated = false;
    private final IEventProcessor fModel;
    private final IEventProcessor fDebugger;

    public EventDispatchJob(IEventProcessor host, IEventProcessor debugger) {
        super(debugger + " event dispatcher");
        this.fModel = host;
        this.fDebugger = debugger;
        this.fModel.setDispatcher(this);
        this.fDebugger.setDispatcher(this);
        this.setSystem(true);
        this.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(IDebugEvent event) {
        List<IDebugEvent> list = this.fEvents;
        synchronized (list) {
            DebugTracer.debug("Dispatcher", "[+] " + event);
            this.fEvents.add(event);
            this.fEvents.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        while (!this.fTerminated) {
            boolean platformRunning;
            IDebugEvent event = null;
            List<IDebugEvent> list = this.fEvents;
            synchronized (list) {
                if (this.fEvents.isEmpty()) {
                    try {
                        this.fEvents.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this.fEvents.isEmpty()) {
                    event = this.fEvents.remove(0);
                }
            }
            boolean bl = platformRunning = DebugPlugin.getDefault() != null;
            if (monitor.isCanceled() || !platformRunning) {
                this.terminate();
            }
            if (event == null) continue;
            try {
                this.handleEvent(event);
            }
            catch (Throwable e) {
                DebugTracer.debug("Dispatcher", "Error detected: " + e.getClass().getName() + ": " + e.getMessage());
                Logger.error("org.eclipse.ease", "The debug session encountered an error", e);
                Status status = new Status(4, "org.eclipse.ease", "The debug session encountered an error. We try to gracefully continue the session.", e);
                Display.getDefault().asyncExec(() -> {
                    int n = ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Debug session error", (String)"The debug session encountered an error. We try to gracefully continue the session.", (IStatus)status);
                });
            }
        }
        return Status.OK_STATUS;
    }

    private void handleEvent(IDebugEvent event) {
        if (event instanceof IDebuggerEvent) {
            DebugTracer.debug("Dispatcher", "debugger -> " + event + " -> model");
            this.fModel.handleEvent(event);
        } else if (event instanceof IModelRequest) {
            DebugTracer.debug("Dispatcher", "debugger <- " + event + " <- model");
            this.fDebugger.handleEvent(event);
        } else {
            throw new RuntimeException("Unknown event detected: " + event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.fTerminated = true;
        List<IDebugEvent> list = this.fEvents;
        synchronized (list) {
            this.fEvents.notifyAll();
        }
    }
}

