/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.modules.ui;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.modules.ModuleHelper;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.modules.ui.ModulesTools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;

public class ModulesLabelProvider
extends BaseLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
ILabelProvider {
    private static final StyledString.Styler STRIKE_THROUGH_STYLE = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.strikeout = true;
        }
    };

    public StyledString getStyledText(Object element) {
        StyledString text = new StyledString();
        if (element instanceof ModulesTools.ModuleEntry) {
            element = ((ModulesTools.ModuleEntry)element).getEntry();
        }
        if (element instanceof ModuleDefinition) {
            text.append(((ModuleDefinition)element).getName());
        } else if (element instanceof IPath) {
            text.append(((IPath)element).lastSegment());
        } else if (element instanceof Field) {
            text.append(((Field)element).getName());
            text.append(" : " + ((Field)element).getType().getSimpleName(), StyledString.DECORATIONS_STYLER);
        } else if (element instanceof Method) {
            text.append(ModulesTools.getSignature((Method)element, true));
        }
        if (ModulesLabelProvider.isDeprecated(element)) {
            text.setStyle(0, text.length(), STRIKE_THROUGH_STYLE);
        }
        return text;
    }

    public Image getImage(Object element) {
        if (element instanceof IPath) {
            return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/folder.png", true);
        }
        if (element instanceof ModuleDefinition) {
            ImageDescriptor icon = ((ModuleDefinition)element).getImageDescriptor();
            if (icon == null) {
                return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/module.png", true);
            }
            return icon.createImage();
        }
        if (element instanceof ModulesTools.ModuleEntry) {
            element = ((ModulesTools.ModuleEntry)element).getEntry();
        }
        if (element instanceof Method) {
            return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/function.png", true);
        }
        if (element instanceof Field) {
            return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/field.png", true);
        }
        return null;
    }

    private static boolean isDeprecated(Object element) {
        if (element instanceof AccessibleObject) {
            return ModuleHelper.isDeprecated((AccessibleObject)((AccessibleObject)element));
        }
        if (element instanceof ModuleDefinition) {
            return ((ModuleDefinition)element).isDeprecated();
        }
        return false;
    }

    public String getText(Object element) {
        return this.getStyledText(element).toString();
    }
}

