/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.view;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;

public class ScriptHistoryText
extends StyledText
implements IExecutionListener {
    public static final int STYLE_ERROR = 1;
    public static final int STYLE_RESULT = 3;
    public static final int STYLE_COMMAND = 4;
    private BlendBackgroundJob fBlendBackgroundJob = null;
    private final LocalResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.getParent());
    private final ColorDescriptor fColorDescriptorResult = ColorDescriptor.createFrom((Color)this.getShell().getDisplay().getSystemColor(16));
    private final ColorDescriptor fColorDescriptorCommand = ColorDescriptor.createFrom((Color)this.getShell().getDisplay().getSystemColor(9));
    private final ColorDescriptor fColorDescriptorError = ColorDescriptor.createFrom((Color)this.getShell().getDisplay().getSystemColor(3));
    private ColorDescriptor fColorDefaultBackground = null;
    private ColorDescriptor fColorDarkenedBackground = null;

    public ScriptHistoryText(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public void addScriptEngine(IScriptEngine engine) {
        if (engine != null) {
            engine.addExecutionListener((IExecutionListener)this);
        }
    }

    public void removeScriptEngine(IScriptEngine engine) {
        if (engine != null) {
            engine.removeExecutionListener((IExecutionListener)this);
        }
    }

    private void initialize() {
        String os = Platform.getOS();
        if ("win32".equals(os)) {
            this.setFont(this.fResourceManager.createFont(FontDescriptor.createFrom((String)"Courier New", (int)10, (int)0)));
        } else if ("linux".equals(os)) {
            this.setFont(this.fResourceManager.createFont(FontDescriptor.createFrom((String)"Monospace", (int)10, (int)0)));
        }
        this.fColorDefaultBackground = ColorDescriptor.createFrom((Color)this.getBackground());
        RGB defaultBackground = this.getBackground().getRGB();
        RGB darkenedBackground = new RGB(defaultBackground.red - 16, defaultBackground.green - 16, defaultBackground.blue - 16);
        this.fColorDarkenedBackground = ColorDescriptor.createFrom((RGB)darkenedBackground);
        this.setEditable(false);
        this.fBlendBackgroundJob = new BlendBackgroundJob();
    }

    public void dispose() {
        this.fResourceManager.dispose();
        super.dispose();
    }

    public void clear() {
        this.setText("");
        this.setStyleRanges(new StyleRange[0]);
    }

    public void notify(IScriptEngine engine, Script script, int status) {
        try {
            switch (status) {
                case 3: {
                    this.fBlendBackgroundJob.arm();
                    this.localPrint(script.getCode(), 4);
                    break;
                }
                case 4: {
                    this.fBlendBackgroundJob.disarm();
                    if (this.fBlendBackgroundJob.fStarted) {
                        Display.getDefault().asyncExec(() -> this.setBackground(this.fResourceManager.createColor(this.fColorDefaultBackground)));
                    }
                    if (script.getResult().hasException()) {
                        this.localPrint(script.getResult().getException().getLocalizedMessage(), 1);
                        break;
                    }
                    Object result = script.getResult().getResult();
                    if (result != null) {
                        this.localPrint(script.getResult().getResult().toString(), 3);
                        break;
                    }
                    this.localPrint("[null]", 3);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void localPrint(final String message, final int style) {
        if (message != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    String out = message;
                    if (style != 4) {
                        out = "\t" + message.replaceAll("\\r?\\n", "\n\t");
                    }
                    if (!ScriptHistoryText.this.isDisposed()) {
                        ScriptHistoryText.this.append("\n");
                        StyleRange styleRange = ScriptHistoryText.this.getStyle(style, ScriptHistoryText.this.getText().length(), out.length());
                        ScriptHistoryText.this.append(out);
                        ScriptHistoryText.this.setStyleRange(styleRange);
                        ScriptHistoryText.this.setHorizontalPixel(0);
                        ScriptHistoryText.this.setTopPixel(ScriptHistoryText.this.getLineHeight() * ScriptHistoryText.this.getLineCount());
                    }
                }
            });
        }
    }

    private StyleRange getStyle(int style, int start, int length) {
        StyleRange styleRange = new StyleRange();
        styleRange.start = start;
        styleRange.length = length;
        switch (style) {
            case 3: {
                styleRange.foreground = this.fResourceManager.createColor(this.fColorDescriptorResult);
                break;
            }
            case 4: {
                styleRange.foreground = this.fResourceManager.createColor(this.fColorDescriptorCommand);
                styleRange.fontStyle = 1;
                break;
            }
            case 1: {
                styleRange.foreground = this.fResourceManager.createColor(this.fColorDescriptorError);
                styleRange.fontStyle = 2;
                break;
            }
        }
        return styleRange;
    }

    private class BlendBackgroundJob
    extends UIJob {
        private boolean fRun;
        private volatile boolean fStarted;

        public BlendBackgroundJob() {
            super("Darken Script Shell background");
            this.setSystem(true);
        }

        public void arm() {
            this.fRun = true;
            this.fStarted = false;
            this.schedule(300L);
        }

        public void disarm() {
            this.fRun = false;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            this.fStarted = true;
            if (this.fRun) {
                ScriptHistoryText.this.setBackground(ScriptHistoryText.this.fResourceManager.createColor(ScriptHistoryText.this.fColorDarkenedBackground));
            }
            return Status.OK_STATUS;
        }
    }
}

