/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.ui.editor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ease.Logger;
import org.eclipse.ease.lang.unittest.UnitTestHelper;
import org.eclipse.ease.lang.unittest.definition.ITestSuiteDefinition;
import org.eclipse.ease.lang.unittest.definition.provider.DefinitionItemProviderAdapterFactory;
import org.eclipse.ease.lang.unittest.ui.editor.CustomCodePage;
import org.eclipse.ease.lang.unittest.ui.editor.FileSelectionPage;
import org.eclipse.ease.lang.unittest.ui.editor.OverviewPage;
import org.eclipse.ease.lang.unittest.ui.editor.VariablesPage;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;

public class TestSuiteEditor
extends FormEditor
implements IEditingDomainProvider {
    public static final String EDITOR_ID = "org.eclipse.ease.editor.suiteEditor";
    public static final String OVERVIEW_PAGE = "Overview";
    public static final String TEST_SELECTION_PAGE = "Test Selection";
    public static final String VARIABLES_PAGE = "Variables";
    public static final String CUSTOM_CODE_PAGE = "Custom Code";
    private boolean fDirty = false;
    private AdapterFactoryEditingDomain fEditingDomain;
    private ITestSuiteDefinition fTestSuite = null;
    private LocalResourceManager fResourceManager;
    private ComposedAdapterFactory fAdapterFactory;

    public TestSuiteEditor() {
        this.initializeEditingDomain();
        this.addChangeListener();
    }

    private void initializeEditingDomain() {
        this.fAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new DefinitionItemProviderAdapterFactory());
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        this.fEditingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.fAdapterFactory, (CommandStack)commandStack, new HashMap());
    }

    private void addChangeListener() {
        this.fEditingDomain.getCommandStack().addCommandStackListener(event -> {
            this.fDirty = true;
            this.firePropertyChange(257);
        });
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        try {
            this.fTestSuite = UnitTestHelper.loadTestSuite((InputStream)this.getFile().getContents());
            this.fTestSuite.setResource((Object)this.getFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        this.setPartName(this.getFile().getName());
        this.firePropertyChange(1);
    }

    protected void addPages() {
        try {
            this.addPage((IFormPage)new OverviewPage(this, OVERVIEW_PAGE, OVERVIEW_PAGE));
            this.addPage((IFormPage)new FileSelectionPage(this, TEST_SELECTION_PAGE, TEST_SELECTION_PAGE));
            this.addPage((IFormPage)new VariablesPage(this, VARIABLES_PAGE, VARIABLES_PAGE));
            this.addPage((IFormPage)new CustomCodePage(this, CUSTOM_CODE_PAGE, CUSTOM_CODE_PAGE));
        }
        catch (PartInitException e) {
            Logger.error((String)"org.eclipse.ease.lang.unittest.ui", (String)"Could not create all pages for TestSuiteEditor", (Throwable)e);
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            byte[] xmlContent = UnitTestHelper.serializeTestSuite((ITestSuiteDefinition)this.getTestSuite());
            this.getFile().setContents((InputStream)new ByteArrayInputStream(xmlContent), true, true, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        this.fDirty = false;
        this.editorDirtyStateChanged();
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        IFormPage page = this.getActivePageInstance();
        if (page != null) {
            page.setFocus();
        }
    }

    public ITestSuiteDefinition getTestSuite() {
        return this.fTestSuite;
    }

    public boolean isDirty() {
        return super.isDirty() | this.fDirty;
    }

    public IFile getFile() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof FileEditorInput) {
            return ((FileEditorInput)input).getFile();
        }
        return null;
    }

    public AdapterFactoryEditingDomain getEditingDomain() {
        return this.fEditingDomain;
    }

    public void dispose() {
        this.fResourceManager.dispose();
        super.dispose();
    }

    public LocalResourceManager getResourceManager() {
        return this.fResourceManager;
    }
}

