/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ease.AbstractCodeFactory;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.lang.javascript.JavaScriptHelper;
import org.eclipse.ease.modules.IEnvironment;
import org.eclipse.ease.modules.ModuleHelper;
import org.eclipse.ease.tools.StringTools;

public class JavaScriptCodeFactory
extends AbstractCodeFactory {
    public static List<String> RESERVED_KEYWORDS = new ArrayList<String>();

    static {
        RESERVED_KEYWORDS.add("abstract");
        RESERVED_KEYWORDS.add("arguments");
        RESERVED_KEYWORDS.add("boolean");
        RESERVED_KEYWORDS.add("break");
        RESERVED_KEYWORDS.add("byte");
        RESERVED_KEYWORDS.add("case");
        RESERVED_KEYWORDS.add("catch");
        RESERVED_KEYWORDS.add("char");
        RESERVED_KEYWORDS.add("class");
        RESERVED_KEYWORDS.add("const");
        RESERVED_KEYWORDS.add("continue");
        RESERVED_KEYWORDS.add("debugger");
        RESERVED_KEYWORDS.add("default");
        RESERVED_KEYWORDS.add("delete");
        RESERVED_KEYWORDS.add("do");
        RESERVED_KEYWORDS.add("double");
        RESERVED_KEYWORDS.add("else");
        RESERVED_KEYWORDS.add("enum");
        RESERVED_KEYWORDS.add("eval");
        RESERVED_KEYWORDS.add("export");
        RESERVED_KEYWORDS.add("extends");
        RESERVED_KEYWORDS.add("false");
        RESERVED_KEYWORDS.add("final");
        RESERVED_KEYWORDS.add("finally");
        RESERVED_KEYWORDS.add("float");
        RESERVED_KEYWORDS.add("for");
        RESERVED_KEYWORDS.add("function");
        RESERVED_KEYWORDS.add("goto");
        RESERVED_KEYWORDS.add("if");
        RESERVED_KEYWORDS.add("implements");
        RESERVED_KEYWORDS.add("import");
        RESERVED_KEYWORDS.add("in");
        RESERVED_KEYWORDS.add("instanceof");
        RESERVED_KEYWORDS.add("int");
        RESERVED_KEYWORDS.add("interface");
        RESERVED_KEYWORDS.add("let");
        RESERVED_KEYWORDS.add("long");
        RESERVED_KEYWORDS.add("native");
        RESERVED_KEYWORDS.add("new");
        RESERVED_KEYWORDS.add("null");
        RESERVED_KEYWORDS.add("package");
        RESERVED_KEYWORDS.add("private");
        RESERVED_KEYWORDS.add("protected");
        RESERVED_KEYWORDS.add("public");
        RESERVED_KEYWORDS.add("return");
        RESERVED_KEYWORDS.add("short");
        RESERVED_KEYWORDS.add("static");
        RESERVED_KEYWORDS.add("super");
        RESERVED_KEYWORDS.add("switch");
        RESERVED_KEYWORDS.add("synchronized");
        RESERVED_KEYWORDS.add("this");
        RESERVED_KEYWORDS.add("throw");
        RESERVED_KEYWORDS.add("throws");
        RESERVED_KEYWORDS.add("transient");
        RESERVED_KEYWORDS.add("true");
        RESERVED_KEYWORDS.add("try");
        RESERVED_KEYWORDS.add("typeof");
        RESERVED_KEYWORDS.add("var");
        RESERVED_KEYWORDS.add("void");
        RESERVED_KEYWORDS.add("volatile");
        RESERVED_KEYWORDS.add("while");
        RESERVED_KEYWORDS.add("with");
        RESERVED_KEYWORDS.add("yield");
    }

    private static boolean isValidMethodName(String methodName) {
        return JavaScriptHelper.isSaveName(methodName) && !RESERVED_KEYWORDS.contains(methodName);
    }

    public String classInstantiation(Class<?> clazz, String[] parameters) {
        StringBuilder code = new StringBuilder();
        code.append("new Packages.").append(clazz.getName()).append('(');
        if (parameters != null) {
            String[] stringArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                code.append(parameter).append(", ");
                ++n2;
            }
            if (parameters.length > 0) {
                code.delete(code.length() - 2, code.length());
            }
        }
        code.append(')');
        return code.toString();
    }

    protected String getNullString() {
        return "null";
    }

    public String getSaveVariableName(String variableName) {
        return JavaScriptHelper.getSaveName(variableName);
    }

    private StringBuilder verifyParameters(List<ICodeFactory.Parameter> parameters, String indent) {
        StringBuilder data = new StringBuilder();
        if (!parameters.isEmpty()) {
            ICodeFactory.Parameter parameter = parameters.get(parameters.size() - 1);
            data.append(indent).append("if (typeof " + parameter.getName() + " === \"undefined\") {").append(StringTools.LINE_DELIMITER);
            if (parameter.isOptional()) {
                data.append(indent).append("\t" + parameter.getName() + " = " + this.getDefaultValue(parameter) + ';').append(StringTools.LINE_DELIMITER);
            } else {
                data.append(indent).append("\tthrow 'Parameter <" + parameter.getName() + "> is not optional';").append(StringTools.LINE_DELIMITER);
            }
            data.append((CharSequence)this.verifyParameters(parameters.subList(0, parameters.size() - 1), String.valueOf(indent) + "\t"));
            data.append(indent).append('}').append(StringTools.LINE_DELIMITER);
        }
        return data;
    }

    public String createCommentedString(String comment, boolean addBlockComment) {
        if (addBlockComment) {
            StringBuilder builder = new StringBuilder();
            builder.append("/**").append(StringTools.LINE_DELIMITER);
            String[] stringArray = comment.split("\\r?\\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                builder.append(" * ").append(line).append(StringTools.LINE_DELIMITER);
                ++n2;
            }
            builder.append(" */").append(StringTools.LINE_DELIMITER);
            return builder.toString();
        }
        return super.createCommentedString(comment, addBlockComment);
    }

    public String createWrapper(IEnvironment environment, Object instance, String identifier, boolean customNamespace, IScriptEngine engine) {
        if (customNamespace) {
            return this.createObjectWrapper(environment, instance, identifier);
        }
        return super.createWrapper(environment, instance, identifier, customNamespace, engine);
    }

    private String createObjectWrapper(IEnvironment environment, Object instance, String identifier) {
        StringBuilder scriptCode = new StringBuilder();
        scriptCode.append("__EASE_temporary_wrapper_object = {").append(StringTools.LINE_DELIMITER);
        scriptCode.append("\tjavaInstance: ").append(identifier).append(',').append(StringTools.LINE_DELIMITER);
        scriptCode.append(StringTools.LINE_DELIMITER).append("\t// field definitions").append(StringTools.LINE_DELIMITER);
        for (Field field : ModuleHelper.getFields(instance.getClass())) {
            scriptCode.append('\t').append(field.getName()).append(": ").append(identifier).append('.').append(field.getName()).append(',').append(StringTools.LINE_DELIMITER);
        }
        scriptCode.append(StringTools.LINE_DELIMITER).append("\t// method definitions").append(StringTools.LINE_DELIMITER);
        for (Method method : ModuleHelper.getMethods(instance.getClass())) {
            List parameters = ModuleHelper.getParameters((Method)method);
            String body = "\t\t" + this.buildMethodBody(parameters, environment, method, identifier).replaceAll("\n", "\n\t\t");
            scriptCode.append('\t').append(method.getName()).append(": function(");
            scriptCode.append(JavaScriptCodeFactory.buildParameterList((List)parameters)).append(") {").append(StringTools.LINE_DELIMITER);
            scriptCode.append(body).append(StringTools.LINE_DELIMITER);
            scriptCode.append("\t},").append(StringTools.LINE_DELIMITER).append(StringTools.LINE_DELIMITER);
            for (String alias : JavaScriptCodeFactory.getMethodAliases((Method)method)) {
                if (!JavaScriptCodeFactory.isValidMethodName(alias)) {
                    Logger.error((String)"org.eclipse.ease.lang.javascript", (String)("The method name \"" + alias + "\" from the module \"" + identifier + "\" can not be wrapped because it's name is reserved"));
                    continue;
                }
                if (alias.isEmpty()) continue;
                scriptCode.append('\t').append(alias).append(": function(");
                scriptCode.append(JavaScriptCodeFactory.buildParameterList((List)parameters)).append(") {").append(StringTools.LINE_DELIMITER);
                scriptCode.append("\t\t// method alias").append(StringTools.LINE_DELIMITER);
                scriptCode.append("\t\treturn this.").append(method.getName()).append('(').append(JavaScriptCodeFactory.buildParameterList((List)parameters)).append(");").append(StringTools.LINE_DELIMITER);
                scriptCode.append("\t},").append(StringTools.LINE_DELIMITER).append(StringTools.LINE_DELIMITER);
            }
        }
        scriptCode.append("};").append(StringTools.LINE_DELIMITER);
        return scriptCode.toString();
    }

    protected String createFunctionWrapper(IEnvironment environment, String moduleVariable, Method method) {
        StringBuilder javaScriptCode = new StringBuilder();
        List parameters = ModuleHelper.getParameters((Method)method);
        String parameterList = JavaScriptCodeFactory.buildParameterList((List)parameters);
        String body = "\t" + this.buildMethodBody(parameters, environment, method, moduleVariable).replaceAll("\n", "\n\t");
        for (String name : JavaScriptCodeFactory.getMethodNames((Method)method)) {
            if (!JavaScriptCodeFactory.isValidMethodName(name)) {
                Logger.error((String)"org.eclipse.ease.lang.javascript", (String)("The method name \"" + name + "\" from the module \"" + moduleVariable + "\" can not be wrapped because it's name is reserved"));
                continue;
            }
            if (name.isEmpty()) continue;
            javaScriptCode.append("function ").append(name).append('(').append(parameterList).append(") {").append(StringTools.LINE_DELIMITER);
            javaScriptCode.append(body).append(StringTools.LINE_DELIMITER);
            javaScriptCode.append('}').append(StringTools.LINE_DELIMITER);
        }
        return javaScriptCode.toString();
    }

    private String buildMethodBody(List<ICodeFactory.Parameter> parameters, IEnvironment environment, Method method, String classIdentifier) {
        StringBuilder body = new StringBuilder();
        body.append("// verify mandatory and optional parameters").append(StringTools.LINE_DELIMITER);
        body.append((CharSequence)this.verifyParameters(parameters, "")).append(StringTools.LINE_DELIMITER);
        body.append(JavaScriptCodeFactory.getPreExecutionCode((IEnvironment)environment, (Method)method));
        if (ModuleHelper.isDeprecated((AccessibleObject)method)) {
            body.append("printError('" + method.getName() + "() is deprecated. Consider updating your code.');").append(StringTools.LINE_DELIMITER);
        }
        body.append("// delegate call to java layer").append(StringTools.LINE_DELIMITER);
        body.append("var ").append("__result").append(" = ").append(classIdentifier).append('.').append(method.getName()).append('(');
        body.append(JavaScriptCodeFactory.buildParameterList(parameters));
        body.append(");").append(StringTools.LINE_DELIMITER);
        body.append(JavaScriptCodeFactory.getPostExecutionCode((IEnvironment)environment, (Method)method));
        body.append("return ").append("__result").append(';');
        return body.toString();
    }
}

