/*******************************************************************************
 * Copyright (c) 2015 Christian Pontesegger and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Christian Pontesegger - initial API and implementation
 *******************************************************************************/
package org.eclipse.ease.modules.unittest.components;

public enum TestStatus {

	NOT_RUN, PASS, ERROR, FAILURE, RUNNING;

	public TestStatus merge(final TestStatus status) {
		return (isEqualOrWorse(status)) ? this : status;
	}

	public boolean isEqualOrWorse(final TestStatus status) {
		return (compareTo(status) >= 0);
	}

	public boolean isEqualOrBetter(final TestStatus status) {
		return (compareTo(status) <= 0);
	}
}
