/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript.rhino.debugger;

import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;

public class LineNumberDebugger
implements Debugger {
    private boolean mFreezeStack = false;
    private final List<LineNumberDebugFrame> mFrames = new ArrayList<LineNumberDebugFrame>();

    public Object getContextData() {
        return null;
    }

    public void handleCompilationDone(Context cx, DebuggableScript fnOrScript, String source) {
    }

    public DebugFrame getFrame(Context cx, DebuggableScript fnOrScript) {
        return new LineNumberDebugFrame(fnOrScript);
    }

    public List<LineNumberDebugFrame> getFrames() {
        return this.mFrames;
    }

    public class LineNumberDebugFrame
    implements DebugFrame {
        private int mLineNumber;
        private final DebuggableScript mScript;

        public LineNumberDebugFrame(DebuggableScript fnOrScript) {
            this.mScript = fnOrScript;
        }

        public void onEnter(Context cx, Scriptable activation, Scriptable thisObj, Object[] args) {
            LineNumberDebugger.this.mFreezeStack = false;
            this.mLineNumber = 1;
            LineNumberDebugger.this.mFrames.add(this);
        }

        public void onLineChange(Context cx, int lineNumber) {
            LineNumberDebugger.this.mFreezeStack = false;
            this.mLineNumber = lineNumber;
        }

        public void onExceptionThrown(Context cx, Throwable ex) {
            LineNumberDebugger.this.mFreezeStack = true;
        }

        public void onExit(Context cx, boolean byThrow, Object resultOrException) {
            if (!LineNumberDebugger.this.mFreezeStack) {
                LineNumberDebugger.this.mFrames.remove(LineNumberDebugger.this.mFrames.size() - 1);
            }
        }

        public void onDebuggerStatement(Context cx) {
        }

        public int getLineNumber() {
            return this.mLineNumber;
        }

        public DebuggableScript getScript() {
            return this.mScript;
        }
    }
}

