/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/language-service/src/types", ["require", "exports", "@angular/compiler", "@angular/language-service/src/symbols"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var compiler_1 = require("@angular/compiler");
    exports.StaticSymbol = compiler_1.StaticSymbol;
    var symbols_1 = require("@angular/language-service/src/symbols");
    exports.BuiltinType = symbols_1.BuiltinType;
    /**
     * The kind of diagnostic message.
     *
     * @publicApi
     */
    var DiagnosticKind;
    (function (DiagnosticKind) {
        DiagnosticKind[DiagnosticKind["Error"] = 0] = "Error";
        DiagnosticKind[DiagnosticKind["Warning"] = 1] = "Warning";
    })(DiagnosticKind = exports.DiagnosticKind || (exports.DiagnosticKind = {}));
    /**
     * The type of Angular directive. Used for QuickInfo in template.
     */
    var DirectiveKind;
    (function (DirectiveKind) {
        DirectiveKind["COMPONENT"] = "component";
        DirectiveKind["DIRECTIVE"] = "directive";
        DirectiveKind["EVENT"] = "event";
    })(DirectiveKind = exports.DirectiveKind || (exports.DirectiveKind = {}));
    /**
     * ScriptElementKind for completion.
     */
    var CompletionKind;
    (function (CompletionKind) {
        CompletionKind["ANGULAR_ELEMENT"] = "angular element";
        CompletionKind["ATTRIBUTE"] = "attribute";
        CompletionKind["COMPONENT"] = "component";
        CompletionKind["ELEMENT"] = "element";
        CompletionKind["ENTITY"] = "entity";
        CompletionKind["HTML_ATTRIBUTE"] = "html attribute";
        CompletionKind["HTML_ELEMENT"] = "html element";
        CompletionKind["KEY"] = "key";
        CompletionKind["METHOD"] = "method";
        CompletionKind["PIPE"] = "pipe";
        CompletionKind["PROPERTY"] = "property";
        CompletionKind["REFERENCE"] = "reference";
        CompletionKind["TYPE"] = "type";
        CompletionKind["VARIABLE"] = "variable";
    })(CompletionKind = exports.CompletionKind || (exports.CompletionKind = {}));
});
//# sourceMappingURL=data:application/json;base64,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