/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.debug.AbstractDebugAdapterLaunchShortcut;
import org.eclipse.wildwebdeveloper.debug.Messages;
import org.eclipse.wildwebdeveloper.debug.SelectionUtils;
import org.eclipse.wildwebdeveloper.debug.chrome.ChromeRunDebugLaunchShortcut;

public abstract class AbstractRunHTMLDebugTab
extends AbstractLaunchConfigurationTab {
    private Text programPathText;
    private Text argumentsText;
    private Text workingDirectoryText;
    protected Composite resComposite;
    protected AbstractDebugAdapterLaunchShortcut shortcut = new ChromeRunDebugLaunchShortcut();

    public void createControl(Composite parent) {
        this.resComposite = new Composite(parent, 0);
        this.resComposite.setLayout((Layout)new GridLayout(3, false));
        new Label(this.resComposite, 0).setText(Messages.FirefoxDebugTab_File);
        this.programPathText = new Text(this.resComposite, 2048);
        this.programPathText.setLayoutData((Object)new GridData(4, -1, true, false));
        ControlDecoration decoration = new ControlDecoration((Control)this.programPathText, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        decoration.setImage(fieldDecoration.getImage());
        this.programPathText.addModifyListener(event -> {
            this.setDirty(true);
            File file = new File(this.programPathText.getText());
            if (!file.isFile()) {
                String errorMessage = Messages.RunProgramTab_error_unknownFile;
                this.setErrorMessage(errorMessage);
                decoration.setDescriptionText(errorMessage);
                decoration.show();
            } else if (!this.shortcut.canLaunch(file)) {
                String errorMessage = "Not a html file";
                this.setErrorMessage(errorMessage);
                decoration.setDescriptionText(errorMessage);
                decoration.show();
            } else if (!file.canRead()) {
                String errorMessage = Messages.RunProgramTab_error_nonReadableFile;
                this.setErrorMessage(errorMessage);
                decoration.setDescriptionText(errorMessage);
                decoration.show();
            } else {
                this.setErrorMessage(null);
                decoration.hide();
            }
            this.updateLaunchConfigurationDialog();
        });
        Button filePath = new Button(this.resComposite, 8);
        filePath.setText("Browse...");
        filePath.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog filePathDialog = new FileDialog(this.resComposite.getShell());
            filePathDialog.setFilterPath(this.workingDirectoryText.getText());
            filePathDialog.setText("Select a .html file to debug");
            String path = filePathDialog.open();
            if (path != null) {
                this.programPathText.setText(path);
                this.setDirty(true);
                this.updateLaunchConfigurationDialog();
            }
        }));
        new Label(this.resComposite, 0).setText(Messages.RunProgramTab_argument);
        this.argumentsText = new Text(this.resComposite, 2048);
        GridData argsGD = new GridData(4, -1, true, false);
        argsGD.horizontalSpan = 2;
        this.argumentsText.setLayoutData((Object)argsGD);
        this.argumentsText.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        new Label(this.resComposite, 0).setText(Messages.RunProgramTab_workingDirectory);
        this.workingDirectoryText = new Text(this.resComposite, 2048);
        this.workingDirectoryText.setLayoutData((Object)new GridData(4, -1, true, false));
        this.workingDirectoryText.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        Button workingDirectoryButton = new Button(this.resComposite, 8);
        workingDirectoryButton.setText("Browse...");
        workingDirectoryButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            DirectoryDialog workingDirectoryDialog = new DirectoryDialog(this.resComposite.getShell());
            workingDirectoryDialog.setFilterPath(this.workingDirectoryText.getText());
            workingDirectoryDialog.setText("Select folder to watch for changes");
            String path = workingDirectoryDialog.open();
            if (path != null) {
                this.workingDirectoryText.setText(path);
                this.setDirty(true);
                this.updateLaunchConfigurationDialog();
            }
        }));
        this.setControl((Control)this.resComposite);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String defaultSelectedFile = SelectionUtils.pathOrEmpty(SelectionUtils.getSelectedFile(this.shortcut::canLaunch));
            this.programPathText.setText(configuration.getAttribute("program", defaultSelectedFile));
            this.argumentsText.setText(configuration.getAttribute("runtimeArgs", ""));
            this.workingDirectoryText.setText(configuration.getAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", SelectionUtils.pathOrEmpty(SelectionUtils.getSelectedProject())));
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("program", this.programPathText.getText());
        configuration.setAttribute("runtimeArgs", this.argumentsText.getText());
        configuration.setAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", this.workingDirectoryText.getText());
    }

    public String getName() {
        return Messages.RunProgramTab_title;
    }
}

