/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.testcases;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Collectors;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.petrinet.PetrinetBuilder;
import org.eclipse.comma.testcases.TestCasesTemplate;
import org.eclipse.xtext.scoping.IScopeProvider;

public class TestCasesGenerator {
    public static String generate(Interface itf, Parameters params, IScopeProvider scopeProvider, int maxDepth, String templatePath, String outputFile, String taskName) {
        String code = "SELF_CONTAINED = True\n" + PetrinetBuilder.getModelCode() + PetrinetBuilder.getReachabilityGraphCode();
        code = String.valueOf(code) + "## scenarios.py\n" + TestCasesGenerator.getResourceText("/scenarios.py") + "\n\n";
        code = String.valueOf(code) + PetrinetBuilder.forInterface((Interface)itf, (Parameters)params, (IScopeProvider)scopeProvider, (PetrinetBuilder.Mode)PetrinetBuilder.Mode.NOT_INTERACTIVE) + "\n\n";
        code = String.valueOf(code) + "## Parameters\n";
        code = String.valueOf(code) + String.format("MAX_DEPTH = %d\n", maxDepth);
        code = String.valueOf(code) + String.format("OUTPUT_FILE = '%s'\n", outputFile);
        code = String.valueOf(code) + String.format("TEMPLATE = '%s'\n\n", templatePath);
        code = String.valueOf(code) + String.format("TASK_NAME = '%s'\n\n", taskName);
        code = String.valueOf(code) + "## generator_tc.py\n" + TestCasesGenerator.getResourceText("/generator_tc.py") + "\n\n";
        return code;
    }

    public static TestCasesTemplate getTemplate(File projectFile, String template) {
        String resourcePath = String.format("/%s.j2", template);
        if (template == null) {
            return null;
        }
        if (TestCasesGenerator.class.getResource(resourcePath) != null) {
            String content = TestCasesGenerator.getResourceText(resourcePath);
            return new TestCasesTemplate(String.valueOf(template) + ".j2", content);
        }
        Path file = projectFile.getParentFile().toPath().resolve(template);
        if (file.toFile().exists()) {
            try {
                String content = Files.readString(file);
                TestCasesTemplate k = new TestCasesTemplate(file.toFile().getName(), content);
                return k;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String getResourceText(String resource) {
        InputStream stream = TestCasesGenerator.class.getResourceAsStream(resource);
        return new BufferedReader(new InputStreamReader(stream)).lines().collect(Collectors.joining("\n"));
    }
}

