/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.java;

import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import org.eclipse.comma.java.JCmd;
import org.eclipse.comma.java.JProcessMonitor;

public class JCmdExecutor {
    private final ProcessBuilder processBuilder;
    private Consumer<String> onStdOut;
    private Consumer<String> onStdErr;

    public JCmdExecutor(JCmd cmd) {
        this.processBuilder = new ProcessBuilder(cmd.toArray());
    }

    public JCmdExecutor withWorkingDirectory(File directory) {
        this.processBuilder.directory(directory);
        return this;
    }

    public JCmdExecutor withOnStdOut(Consumer<String> onStdOut) {
        this.onStdOut = onStdOut;
        return this;
    }

    public JCmdExecutor withOnStdErr(Consumer<String> onStdErr) {
        this.onStdErr = onStdErr;
        return this;
    }

    public JProcessMonitor execute() throws IOException, InterruptedException {
        return new JProcessMonitor(this.processBuilder, this.onStdOut, this.onStdErr);
    }
}

