/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.core.internal;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Optional;
import org.eclipse.codewind.filewatchers.core.FWAuthToken;
import org.eclipse.codewind.filewatchers.core.FWLogger;
import org.eclipse.codewind.filewatchers.core.IAuthTokenProvider;

public class AuthTokenWrapper {
    private static final int KEEP_LAST_X_STALE_KEYS = 10;
    private static final FWLogger log = FWLogger.getInstance();
    private final Object lock = new Object();
    private final Deque<FWAuthToken> recentInvalidKeysQueue_synch_lock = new ArrayDeque<FWAuthToken>();
    private final HashSet<FWAuthToken> invalidKeysMap_synch_lock = new HashSet();
    private final IAuthTokenProvider authTokenProvider;

    public AuthTokenWrapper(IAuthTokenProvider authTokenProvider) {
        this.authTokenProvider = authTokenProvider;
    }

    public Optional<FWAuthToken> getLatestToken() {
        if (this.authTokenProvider == null) {
            return Optional.empty();
        }
        FWAuthToken token = this.authTokenProvider.getLatestAuthToken();
        if (token == null) {
            return Optional.empty();
        }
        log.logInfo("IDE returned a new security token to filewatcher: " + AuthTokenWrapper.digest(token));
        return Optional.of(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informBadToken(FWAuthToken token) {
        if (this.authTokenProvider == null || token == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.invalidKeysMap_synch_lock.contains(token)) {
                log.logInfo("Filewatcher informed us of a bad token, but we've already reported it to the IDE: " + AuthTokenWrapper.digest(token));
                return;
            }
            this.invalidKeysMap_synch_lock.add(token);
            this.recentInvalidKeysQueue_synch_lock.offer(token);
            while (this.recentInvalidKeysQueue_synch_lock.size() > 10) {
                FWAuthToken keyToRemove = this.recentInvalidKeysQueue_synch_lock.poll();
                this.invalidKeysMap_synch_lock.remove(keyToRemove);
            }
        }
        this.authTokenProvider.informReceivedInvalidAuthToken(token);
        log.logInfo("Filewatcher informed us of a new invalid token, so we've already reported it to the IDE: " + AuthTokenWrapper.digest(token));
    }

    private static String digest(FWAuthToken token) {
        if (token == null) {
            return null;
        }
        String key = token.getAccessToken();
        if (key == null) {
            return null;
        }
        return key.substring(0, Math.min(key.length(), 32));
    }
}

