/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.tasks;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.Messages;
import java.util.Iterator;
import java.util.List;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.cli.ProjectUtil;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.jetbrains.annotations.NotNull;

public class RemoveProjectTask
extends Task.Backgroundable {
    private final List<CodewindApplication> applications;
    private CodewindApplication errorApp;

    public RemoveProjectTask(List<CodewindApplication> applications) {
        super(null, CodewindUIBundle.message("UnbindActionJobTitle", new Object[0]));
        this.applications = applications;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            RemoveProjectTask.$$$reportNull$$$0(0);
        }
        try {
            Iterator<CodewindApplication> iterator = this.applications.iterator();
            while (iterator.hasNext()) {
                CodewindApplication application;
                this.errorApp = application = iterator.next();
                ProjectUtil.removeProject(application.name, application.projectID, indicator);
                this.errorApp = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void onThrowable(@NotNull Throwable error) {
        if (error == null) {
            RemoveProjectTask.$$$reportNull$$$0(1);
        }
        Throwable t = error;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        Logger.logWarning("An error occurred removing project " + this.errorApp.name, t);
        Messages.showErrorDialog((String)CodewindUIBundle.message("UnbindActionError", this.errorApp.name, t.getLocalizedMessage()), (String)CodewindUIBundle.message("CodewindLabel", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        objectArray2[1] = "org/eclipse/codewind/intellij/ui/tasks/RemoveProjectTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onThrowable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

