/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.tasks;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.console.ProjectLogInfo;
import org.eclipse.codewind.intellij.core.messages.CodewindCoreBundle;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.tree.CodewindToolWindowHelper;
import org.jetbrains.annotations.NotNull;

public class CloseAllLogFilesTask
extends Task.Backgroundable {
    private final CodewindApplication application;
    private ToolWindow logFilesToolWindow;
    private ContentManager contentManager = null;

    public CloseAllLogFilesTask(CodewindApplication application, Project project) {
        super(project, CodewindUIBundle.message("ShowAllLogFilesAction", new Object[0]));
        this.application = application;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CloseAllLogFilesTask.$$$reportNull$$$0(0);
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.getProject());
        this.logFilesToolWindow = toolWindowManager.getToolWindow(CodewindToolWindowHelper.SHOW_LOG_FILES_TOOLWINDOW_ID);
        if (this.logFilesToolWindow != null) {
            this.contentManager = this.logFilesToolWindow.getContentManager();
            for (ProjectLogInfo logInfo : this.application.getLogInfos()) {
                final Content content = this.contentManager.findContent(CodewindCoreBundle.message("LogFileConsoleName", this.application.name, logInfo.logName));
                CoreUtil.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (content != null) {
                            CloseAllLogFilesTask.this.contentManager.removeContent(content, true);
                        }
                    }
                });
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/eclipse/codewind/intellij/ui/tasks/CloseAllLogFilesTask", "run"));
    }
}

