/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.module;

import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilderListener;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SdkSettingsStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.InvalidDataException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.FileUtil;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.cli.ProjectUtil;
import org.eclipse.codewind.intellij.core.connection.ConnectionManager;
import org.eclipse.codewind.intellij.core.connection.ProjectTemplateInfo;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.module.CodewindModuleType;
import org.eclipse.codewind.intellij.ui.module.CustomOptionsStep;
import org.eclipse.codewind.intellij.ui.module.NewCodewindProjectStep;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodewindModuleBuilder
extends JavaModuleBuilder
implements ModuleBuilderListener {
    private ProjectTemplateInfo template;

    public CodewindModuleBuilder() {
        this.addListener(this);
    }

    public CodewindModuleType getModuleType() {
        return CodewindModuleType.getInstance();
    }

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        return new CustomOptionsStep();
    }

    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        if (wizardContext == null) {
            CodewindModuleBuilder.$$$reportNull$$$0(0);
        }
        if (modulesProvider == null) {
            CodewindModuleBuilder.$$$reportNull$$$0(1);
        }
        return new ModuleWizardStep[]{new NewCodewindProjectStep(this)};
    }

    @NotNull
    public Module createModule(@NotNull ModifiableModuleModel moduleModel) throws InvalidDataException, IOException, ModuleWithNameAlreadyExists, JDOMException, ConfigurationException {
        if (moduleModel == null) {
            CodewindModuleBuilder.$$$reportNull$$$0(2);
        }
        String moduleFilePath = this.getModuleFilePath();
        CodewindModuleBuilder.deleteModuleFile((String)moduleFilePath);
        Module module = moduleModel.newModule(moduleFilePath, StdModuleTypes.JAVA.getId());
        this.setupModule(module);
        Module module2 = module;
        if (module2 == null) {
            CodewindModuleBuilder.$$$reportNull$$$0(3);
        }
        return module2;
    }

    public ModuleWizardStep modifyProjectTypeStep(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            CodewindModuleBuilder.$$$reportNull$$$0(4);
        }
        return new SdkSettingsStep(settingsStep, (ModuleBuilder)this, arg_0 -> ((CodewindModuleBuilder)this).isSuitableSdkType(arg_0));
    }

    public void setupRootModel(@NotNull ModifiableRootModel modifiableRootModel) throws ConfigurationException {
        if (modifiableRootModel == null) {
            CodewindModuleBuilder.$$$reportNull$$$0(5);
        }
        modifiableRootModel.inheritSdk();
        super.setupRootModel(modifiableRootModel);
    }

    public void setSelectedTemplate(ProjectTemplateInfo template) {
        this.template = template;
    }

    public void moduleCreated(@NotNull Module module) {
        String javaHome;
        if (module == null) {
            CodewindModuleBuilder.$$$reportNull$$$0(6);
        }
        final String path = this.getModuleFileDirectory();
        final String name = this.getName();
        final String url = this.template.getUrl();
        final String language = this.template.getLanguage();
        final String projectType = this.template.getProjectType();
        final String conid = "local";
        final Project ideaProject = module.getProject();
        Sdk sdk = ProjectRootManager.getInstance((Project)ideaProject).getProjectSdk();
        String string = javaHome = sdk == null ? null : sdk.getHomePath();
        if (javaHome == null) {
            Logger.log("createProject: no sdk set for project: " + ideaProject.getName());
        }
        Task.Backgroundable task = new Task.Backgroundable(ideaProject, CodewindUIBundle.message("CodewindLabel", new Object[0]), false, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setText(CodewindUIBundle.message("NewProjectPage_CreateJobLabel", name));
                indicator.setIndeterminate(true);
                try {
                    Path projectPath = Paths.get(path, new String[0]);
                    Path tmpProjectPath = Files.createTempDirectory("codewind", new FileAttribute[0]).resolve(projectPath.getFileName());
                    ProjectUtil.createProject(name, tmpProjectPath.toString(), url, conid, javaHome, (ProgressIndicator)new EmptyProgressIndicator());
                    FileUtil.copyDirectory(tmpProjectPath, projectPath);
                    ProjectUtil.bindProject(name, path, language, projectType, conid, (ProgressIndicator)new EmptyProgressIndicator());
                    FileUtil.deleteDirectory(tmpProjectPath.getParent().toString(), true);
                }
                catch (Exception error) {
                    Throwable thrown = Logger.unwrap(error);
                    Logger.logWarning("An error occurred creating project " + name, thrown);
                    CoreUtil.openDialog(CoreUtil.DialogType.ERROR, CodewindUIBundle.message("CodewindLabel", new Object[0]), CodewindUIBundle.message("StartBuildError", name, thrown.getLocalizedMessage()));
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ProjectManager.getInstance().reloadProject(ideaProject);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/eclipse/codewind/intellij/ui/module/CodewindModuleBuilder$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    void onWizardFinished() throws CommitStepException {
        if (this.getName() == null) {
            return;
        }
        File projectFolder = new File(this.getModuleFileDirectory());
        File[] files = projectFolder.listFiles();
        if (files.length > 1 || files.length == 1 && !files[0].getName().equals(".idea")) {
            throw new CommitStepException(CodewindUIBundle.message("ProjectFolderNotEmpty", projectFolder));
        }
        List<CodewindApplication> applications = ConnectionManager.getManager().getLocalConnection().getApps();
        if (applications.stream().anyMatch(a -> a.getName().equals(this.getName()))) {
            throw new CommitStepException(CodewindUIBundle.message("NewProjectPage_ProjectExistsError", this.getName()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizardContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/eclipse/codewind/intellij/ui/module/CodewindModuleBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableRootModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/eclipse/codewind/intellij/ui/module/CodewindModuleBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createWizardSteps";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "modifyProjectTypeStep";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupRootModel";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "moduleCreated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

