/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.prefs;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.TemplateUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.RepositoryInfo;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class RepositoryManagementComposite
extends Composite {
    private final CodewindConnection connection;
    private final List<RepositoryInfo> repoList;
    private List<RepoEntry> repoEntries;
    private CheckboxTableViewer repoViewer;
    private Button removeButton;
    private StyledText descLabel;
    private StyledText descText;
    private StyledText styleLabel;
    private StyledText styleText;
    private StyledText linkLabel;
    private Link urlLink;

    public RepositoryManagementComposite(Composite parent, CodewindConnection connection, List<RepositoryInfo> repoList) {
        super(parent, 0);
        this.connection = connection;
        this.repoList = repoList;
        this.repoEntries = this.getRepoEntries(repoList);
        this.createControl();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = 7;
        layout.verticalSpacing = 5;
        this.setLayout((Layout)layout);
        Text description = new Text((Composite)this, 74);
        description.setText("");
        description.setBackground(this.getBackground());
        description.setForeground(this.getForeground());
        description.setLayoutData((Object)new GridData(4, 3, true, false, 1, 1));
        Link learnMoreLink = new Link((Composite)this, 0);
        learnMoreLink.setText("<a>" + Messages.RepoMgmtLearnMoreLink + "</a>");
        learnMoreLink.setLayoutData((Object)new GridData(3, 3, false, false, 1, 1));
        learnMoreLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser browser = browserSupport.getExternalBrowser();
                    URL url = new URL("https://www.eclipse.org/codewind/mdteclipseworkingwithtemplates.html");
                    browser.openURL(url);
                }
                catch (Exception e) {
                    Logger.logError((String)"An error occurred trying to open an external browser at: https://www.eclipse.org/codewind/mdteclipseworkingwithtemplates.html", (Throwable)e);
                }
            }
        });
        new Label((Composite)this, 0).setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.repoViewer = CheckboxTableViewer.newCheckList((Composite)this, (int)2560);
        this.repoViewer.setContentProvider((IContentProvider)new RepoContentProvider());
        this.repoViewer.setLabelProvider((IBaseLabelProvider)new RepoLabelProvider());
        this.repoViewer.setInput((Object)this.repoEntries.toArray(new RepoEntry[this.repoEntries.size()]));
        GridData tableData = new GridData(4, 4, true, true, 1, 2);
        tableData.horizontalIndent = 1;
        this.repoViewer.getTable().setLayoutData((Object)tableData);
        Button addButton = new Button((Composite)this, 8);
        addButton.setText(Messages.RepoMgmtAddButton);
        addButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.removeButton = new Button((Composite)this, 8);
        this.removeButton.setText(Messages.RepoMgmtRemoveButton);
        this.removeButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.repoViewer.getTable().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RepositoryManagementComposite.this.updateDetails();
                RepositoryManagementComposite.this.updateButtons();
            }
        });
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RepoEntry repoEntry;
                AddDialog dialog = new AddDialog(RepositoryManagementComposite.this.getShell());
                if (dialog.open() == 0 && (repoEntry = dialog.getRepoEntry()) != null) {
                    RepositoryManagementComposite.this.repoEntries.add(repoEntry);
                    RepositoryManagementComposite.this.repoViewer.refresh();
                    RepositoryManagementComposite.this.repoViewer.setChecked((Object)repoEntry, true);
                }
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableItem[] items;
                for (TableItem item : items = RepositoryManagementComposite.this.repoViewer.getTable().getSelection()) {
                    RepositoryManagementComposite.this.repoEntries.remove(item.getData());
                    RepositoryManagementComposite.this.repoViewer.refresh();
                }
            }
        });
        ScrolledComposite detailsScroll = new ScrolledComposite((Composite)this, 512);
        GridData data = new GridData(4, 4, true, true, 2, 1);
        data.widthHint = 300;
        detailsScroll.setLayoutData((Object)data);
        Composite detailsComp = new Composite((Composite)detailsScroll, 0);
        GridLayout detailsLayout = new GridLayout();
        detailsLayout.numColumns = 1;
        detailsComp.setLayout((Layout)detailsLayout);
        detailsComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.descLabel = new StyledText(detailsComp, 12);
        this.descLabel.setText(Messages.RepoMgmtDescriptionLabel);
        IDEUtil.setBold(this.descLabel);
        IDEUtil.normalizeBackground((Control)this.descLabel, (Control)detailsComp);
        this.descText = new StyledText(detailsComp, 74);
        this.descText.setText("");
        GridData descData = new GridData(4, 4, false, false);
        this.descText.setLayoutData((Object)descData);
        IDEUtil.normalizeBackground((Control)this.descText, (Control)detailsComp);
        this.styleLabel = new StyledText(detailsComp, 12);
        this.styleLabel.setText(Messages.RepoMgmtStylesLabel);
        IDEUtil.setBold(this.styleLabel);
        IDEUtil.normalizeBackground((Control)this.styleLabel, (Control)detailsComp);
        this.styleText = new StyledText(detailsComp, 74);
        this.styleText.setText("");
        GridData styleData = new GridData(4, 4, false, false);
        this.styleText.setLayoutData((Object)styleData);
        IDEUtil.normalizeBackground((Control)this.styleText, (Control)detailsComp);
        this.linkLabel = new StyledText(detailsComp, 12);
        this.linkLabel.setText(Messages.RepoMgmtUrlLabel);
        IDEUtil.setBold(this.linkLabel);
        IDEUtil.normalizeBackground((Control)this.linkLabel, (Control)detailsComp);
        this.urlLink = new Link(detailsComp, 64);
        this.urlLink.setText("");
        GridData linkData = new GridData(4, 4, false, false);
        this.urlLink.setLayoutData((Object)linkData);
        this.urlLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RepoEntry entry = (RepoEntry)RepositoryManagementComposite.this.urlLink.getData();
                if (entry.url != null) {
                    try {
                        URL url = new URL(entry.url);
                        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                        IWebBrowser browser = browserSupport.getExternalBrowser();
                        if (browser == null) {
                            browser = browserSupport.createBrowser(6, entry.url, null, null);
                        }
                        browser.openURL(url);
                    }
                    catch (Exception e) {
                        Logger.logError((String)("Failed to open the browser for url: " + entry.url), (Throwable)e);
                    }
                }
            }
        });
        detailsScroll.addListener(11, event -> {
            int width = detailsScroll.getClientArea().width;
            descData.widthHint = width - detailsLayout.marginWidth;
            styleData.widthHint = width - detailsLayout.marginWidth;
            linkData.widthHint = width - detailsLayout.marginWidth;
            Point size = detailsComp.computeSize(-1, -1);
            detailsScroll.setMinSize(size);
        });
        detailsScroll.setContent((Control)detailsComp);
        detailsScroll.setExpandHorizontal(true);
        detailsScroll.setExpandVertical(true);
        detailsScroll.setMinSize(detailsScroll.getContent().computeSize(-1, -1));
        description.setText(Messages.RepoMgmtDescription);
        for (TableItem item : this.repoViewer.getTable().getItems()) {
            RepoEntry entry = (RepoEntry)item.getData();
            item.setChecked(entry.enabled);
        }
        this.repoViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ((RepoEntry)event.getElement()).enabled = event.getChecked();
            }
        });
        if (this.repoViewer.getTable().getItemCount() > 0) {
            this.repoViewer.getTable().setSelection(0);
        }
        this.updateDetails();
        this.updateButtons();
    }

    private void updateDetails() {
        TableItem[] items = this.repoViewer.getTable().getSelection();
        String desc = "";
        String styles = "";
        String url = "";
        RepoEntry entry = null;
        boolean enabled = false;
        if (items.length == 1) {
            enabled = true;
            entry = (RepoEntry)items[0].getData();
            desc = entry.description;
            styles = entry.getStyles();
            url = entry.url;
        }
        this.descLabel.setEnabled(enabled);
        this.descText.setText(desc);
        this.styleLabel.setEnabled(enabled);
        this.styleText.setText(styles);
        this.linkLabel.setEnabled(enabled);
        this.urlLink.setText("<a href=\"" + url + "\">" + url + "</a>");
        if (entry != null) {
            this.urlLink.setData((Object)entry);
        }
        this.resizeEntry((Control)this.descText);
        this.resizeEntry((Control)this.styleText);
        this.resizeEntry((Control)this.urlLink);
    }

    private void resizeEntry(Control control) {
        int width = control.getParent().getClientArea().width;
        control.setSize(width, control.computeSize((int)width, (int)-1).y);
        int newWidth = control.getParent().getClientArea().width;
        if (newWidth != width) {
            control.setSize(newWidth, control.computeSize((int)newWidth, (int)-1).y);
        }
    }

    private void updateButtons() {
        boolean enabled = true;
        TableItem[] items = this.repoViewer.getTable().getSelection();
        if (items.length >= 1) {
            for (TableItem item : items) {
                if (!((RepoEntry)item.getData()).isProtected()) continue;
                enabled = false;
                break;
            }
        } else {
            enabled = false;
        }
        this.removeButton.setEnabled(enabled);
    }

    private List<RepoEntry> getRepoEntries(List<RepositoryInfo> infos) {
        ArrayList<RepoEntry> entries = new ArrayList<RepoEntry>(infos.size());
        for (RepositoryInfo info : infos) {
            entries.add(new RepoEntry(info));
        }
        return entries;
    }

    public IStatus updateRepos(IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.RepoUpdateTask, (int)100);
        MultiStatus multiStatus = new MultiStatus("org.eclipse.codewind.core", 4, Messages.RepoMgmtUpdateError, null);
        for (RepositoryInfo info : this.repoList) {
            RepoEntry entry = this.getRepoEntry(info.getURL());
            if (entry == null) {
                try {
                    TemplateUtil.removeTemplateSource((String)info.getURL(), (String)this.connection.getConid(), (IProgressMonitor)mon.split(25));
                }
                catch (Exception e) {
                    Logger.logError((String)("Failed to remove repository: " + info.getURL()), (Throwable)e);
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.codewind.core", NLS.bind((String)Messages.RepoMgmtRemoveFailed, (Object)info.getURL()), (Throwable)e));
                }
            } else if (info.getEnabled() != entry.enabled) {
                try {
                    TemplateUtil.enableTemplateSource((boolean)entry.enabled, (String)info.getURL(), (String)this.connection.getConid(), (IProgressMonitor)mon.split(25));
                }
                catch (Exception e) {
                    Logger.logError((String)("Failed to update repository: " + info.getURL()), (Throwable)e);
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.codewind.core", NLS.bind((String)Messages.RepoMgmtUpdateFailed, (Object)info.getURL()), (Throwable)e));
                }
            }
            if (mon.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            mon.setWorkRemaining(100);
        }
        for (RepoEntry entry : this.repoEntries) {
            RepositoryInfo info = this.getRepoInfo(entry.url);
            if (info == null) {
                try {
                    TemplateUtil.addTemplateSource((String)entry.url, (String)entry.name, (String)entry.description, (String)this.connection.getConid(), (IProgressMonitor)mon.split(25));
                }
                catch (Exception e) {
                    Logger.logError((String)("Failed to add repository: " + entry.url), (Throwable)e);
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.codewind.core", NLS.bind((String)Messages.RepoMgmtAddFailed, (Object)entry.url), (Throwable)e));
                }
            }
            if (mon.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            mon.setWorkRemaining(100);
        }
        if (multiStatus.getChildren().length > 0) {
            return multiStatus;
        }
        return Status.OK_STATUS;
    }

    public boolean hasChanges() {
        for (RepositoryInfo info : this.repoList) {
            RepoEntry entry = this.getRepoEntry(info.getURL());
            if (entry == null) {
                return true;
            }
            if (info.getEnabled() == entry.enabled) continue;
            return true;
        }
        for (RepoEntry entry : this.repoEntries) {
            RepositoryInfo info = this.getRepoInfo(entry.url);
            if (info != null) continue;
            return true;
        }
        return false;
    }

    private RepoEntry getRepoEntry(String url) {
        for (RepoEntry entry : this.repoEntries) {
            if (!url.equals(entry.url)) continue;
            return entry;
        }
        return null;
    }

    private RepositoryInfo getRepoInfo(String url) {
        for (RepositoryInfo info : this.repoList) {
            if (!url.equals(info.getURL())) continue;
            return info;
        }
        return null;
    }

    private static class AddDialog
    extends TitleAreaDialog {
        private String name;
        private String description;
        private String url;

        public AddDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.AddRepoDialogShell);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createButtonBar(Composite parent) {
            return super.createButtonBar(parent);
        }

        protected Control createDialogArea(Composite parent) {
            this.setTitleImage(CodewindUIPlugin.getImage("codewindBanner.png"));
            this.setTitle(Messages.AddRepoDialogTitle);
            this.setMessage(Messages.AddRepoDialogMessage);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 11;
            layout.marginWidth = 9;
            layout.horizontalSpacing = 5;
            layout.verticalSpacing = 7;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            GridData data = new GridData(1808);
            data.minimumWidth = 300;
            composite.setLayoutData((Object)data);
            composite.setFont(parent.getFont());
            Label label = new Label(composite, 0);
            label.setText(Messages.AddRepoDialogUrlLabel);
            label.setLayoutData((Object)new GridData(1, 2, false, false));
            final Text urlText = new Text(composite, 2048);
            urlText.setLayoutData((Object)new GridData(4, 4, true, false));
            label = new Label(composite, 0);
            label.setText(Messages.AddRepoDialogNameLabel);
            label.setLayoutData((Object)new GridData(1, 2, false, false));
            final Text nameText = new Text(composite, 2048);
            nameText.setLayoutData((Object)new GridData(4, 4, true, false));
            label = new Label(composite, 0);
            label.setText(Messages.AddRepoDialogDescriptionLabel);
            label.setLayoutData((Object)new GridData(1, 2, false, false));
            final Text descriptionText = new Text(composite, 2048);
            descriptionText.setLayoutData((Object)new GridData(4, 4, true, false));
            urlText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    url = urlText.getText().trim();
                    this.enableOKButton(this.validate());
                }
            });
            nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    name = nameText.getText().trim();
                    this.enableOKButton(this.validate());
                }
            });
            descriptionText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    description = descriptionText.getText().trim();
                    this.enableOKButton(this.validate());
                }
            });
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.enableOKButton(false);
        }

        protected void enableOKButton(boolean value) {
            this.getButton(0).setEnabled(value);
        }

        private boolean validate() {
            if (this.url == null || this.url.isEmpty()) {
                this.setErrorMessage(Messages.AddRepoDialogNoUrl);
                return false;
            }
            if (this.name == null || this.name.isEmpty()) {
                this.setErrorMessage(Messages.AddRepoDialogNoName);
                return false;
            }
            if (this.description == null || this.description.isEmpty()) {
                this.setErrorMessage(Messages.AddRepoDialogNoDescription);
                return false;
            }
            this.setErrorMessage(null);
            return true;
        }

        public RepoEntry getRepoEntry() {
            if (!(this.name == null || this.name.isEmpty() || this.description == null || this.description.isEmpty() || this.url == null || this.url.isEmpty())) {
                return new RepoEntry(this.name, this.description, this.url);
            }
            return null;
        }
    }

    private static class RepoEntry {
        public final String name;
        public final String description;
        public final String url;
        public boolean enabled;
        public RepositoryInfo info;

        public RepoEntry(String name, String description, String url) {
            this.name = name;
            this.description = description;
            this.url = url;
            this.enabled = true;
        }

        public RepoEntry(RepositoryInfo info) {
            this.name = info.getName();
            this.description = info.getDescription();
            this.url = info.getURL();
            this.enabled = info.getEnabled();
            this.info = info;
        }

        public boolean isProtected() {
            if (this.info != null) {
                return this.info.isProtected();
            }
            return false;
        }

        public String getStyles() {
            if (this.info != null) {
                List styles = this.info.getStyles();
                if (styles == null || styles.isEmpty()) {
                    return Messages.GenericNotAvailable;
                }
                StringBuilder builder = new StringBuilder();
                boolean start = true;
                Iterator iterator = styles.iterator();
                if (iterator.hasNext()) {
                    String style = (String)iterator.next();
                    if (!start) {
                        builder.append(", ");
                    } else {
                        start = false;
                    }
                    builder.append(style);
                    return builder.toString();
                }
            }
            return Messages.GenericNotAvailable;
        }
    }

    private static class RepoLabelProvider
    extends LabelProvider {
        private RepoLabelProvider() {
        }

        public String getText(Object element) {
            String name = ((RepoEntry)element).name;
            if (name == null || name.isEmpty()) {
                name = ((RepoEntry)element).description;
            }
            return name;
        }
    }

    private class RepoContentProvider
    implements IStructuredContentProvider {
        private RepoContentProvider() {
        }

        public Object[] getElements(Object arg0) {
            return RepositoryManagementComposite.this.repoEntries.toArray(new RepoEntry[RepositoryManagementComposite.this.repoEntries.size()]);
        }
    }
}

