/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindEclipseApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.console.ProjectLogInfo;
import org.eclipse.codewind.core.internal.console.SocketConsole;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;

public class HideAllLogsAction
extends Action {
    protected CodewindEclipseApplication app;

    public HideAllLogsAction() {
        super(Messages.HideAllLogFilesAction);
    }

    public void setApp(CodewindEclipseApplication app) {
        this.app = app;
        boolean enabled = false;
        if (app.getLogInfos() != null && !app.getLogInfos().isEmpty()) {
            for (ProjectLogInfo logInfo : app.getLogInfos()) {
                if (app.getConsole(logInfo) == null) continue;
                enabled = true;
                break;
            }
        }
        this.setEnabled(enabled);
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)"HideAllLogsAction ran but no application was selected");
            return;
        }
        if (this.app.getLogInfos() == null || this.app.getLogInfos().isEmpty()) {
            Logger.logError((String)("HideAllLogsAction ran but there are no logs for the selected application: " + this.app.name));
            return;
        }
        for (ProjectLogInfo logInfo : this.app.getLogInfos()) {
            SocketConsole console = this.app.getConsole(logInfo);
            if (console == null) continue;
            IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
            consoleManager.removeConsoles(new IConsole[]{console});
            this.app.removeConsole(console);
        }
    }
}

