/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import org.eclipse.codewind.core.internal.Logger;

public class FileUtil {
    public static boolean makeDir(String path) {
        boolean result = true;
        if (path != null) {
            try {
                File fp = new File(path);
                if (!fp.exists() || !fp.isDirectory()) {
                    result = fp.mkdirs();
                }
            }
            catch (Exception e) {
                Logger.logError("Failed to create directory: " + path, e);
                result = false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream inStream, String path) throws IOException, FileNotFoundException {
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(path);
            byte[] bytes = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = inStream.read(bytes)) > 0) {
                outStream.write(bytes, 0, bytesRead);
            }
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void deleteDirectory(String dir, boolean recursive) throws IOException {
        boolean isSuccess;
        String[] fileList;
        if (dir == null || dir.length() <= 0) {
            return;
        }
        if (new StringTokenizer(dir.replace(File.separatorChar, '/'), "/").countTokens() < 2) {
            return;
        }
        File fp = new File(dir);
        if (!fp.exists() || !fp.isDirectory()) {
            throw new IOException("Directory does not exist: " + fp.toString());
        }
        if (recursive && (fileList = fp.list()) != null) {
            String curBasePath = dir + File.separator;
            for (int i = 0; i < fileList.length; ++i) {
                File curFp = new File(curBasePath + fileList[i]);
                if (!curFp.exists()) continue;
                if (curFp.isDirectory()) {
                    FileUtil.deleteDirectory(dir + File.separator + fileList[i], recursive);
                    continue;
                }
                if (curFp.delete()) continue;
                Logger.log("Could not delete " + curFp.getName());
            }
        }
        if (!(isSuccess = fp.delete())) {
            throw new IOException("Directory cannot be removed.");
        }
    }
}

