/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import java.util.ArrayList;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.ProjectUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.core.internal.connection.ProjectTypeInfo;
import org.eclipse.codewind.core.internal.constants.ProjectInfo;
import org.eclipse.codewind.core.internal.constants.ProjectType;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.actions.ImportProjectAction;
import org.eclipse.codewind.ui.internal.actions.OpenAppOverviewAction;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.prefs.RegistryManagementDialog;
import org.eclipse.codewind.ui.internal.wizards.ProjectDeployedDialog;
import org.eclipse.codewind.ui.internal.wizards.ProjectSelectionPage;
import org.eclipse.codewind.ui.internal.wizards.ProjectTypeSelectionPage;
import org.eclipse.codewind.ui.internal.wizards.ProjectValidationPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class BindProjectWizard
extends Wizard
implements INewWizard {
    private ProjectSelectionPage projectPage;
    private ProjectValidationPage projectValidationPage;
    private ProjectTypeSelectionPage projectTypePage;
    private final CodewindConnection connection;
    private IPath projectPath = null;

    public BindProjectWizard(CodewindConnection connection) {
        this(connection, null);
    }

    public BindProjectWizard(CodewindConnection connection, IPath projectPath) {
        this.connection = connection;
        this.projectPath = projectPath;
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(CodewindUIPlugin.getImageDescriptor("codewindBanner.png"));
        this.setHelpAvailable(false);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.setWindowTitle(Messages.BindProjectWizardTitle);
        if (this.projectPath == null) {
            this.projectPage = new ProjectSelectionPage(this, this.connection);
            this.addPage((IWizardPage)this.projectPage);
        }
        this.projectValidationPage = new ProjectValidationPage(this, this.connection, this.projectPath);
        this.projectTypePage = new ProjectTypeSelectionPage(this.connection);
        this.addPage((IWizardPage)this.projectValidationPage);
        this.addPage((IWizardPage)this.projectTypePage);
    }

    public boolean canFinish() {
        if (this.projectPage != null && !this.projectPage.canFinish()) {
            return false;
        }
        if (this.projectValidationPage.isActivePage() && this.projectValidationPage.canFinish()) {
            return true;
        }
        return this.projectTypePage.isActivePage() && this.projectTypePage.canFinish();
    }

    public boolean performCancel() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean performFinish() {
        ProjectDeployedDialog.Behaviour selectedBehaviour;
        if (!this.canFinish()) {
            return false;
        }
        if (this.projectPage != null) {
            this.projectPath = this.projectPage.getProjectPath();
        }
        final String name = this.projectPath.lastSegment();
        final ArrayList<CodewindApplication> existingDeployments = new ArrayList<CodewindApplication>();
        for (CodewindConnection conn : CodewindConnectionManager.activeConnections()) {
            CodewindApplication app;
            if (!conn.isConnected() || (app = conn.getAppByName(name)) == null || !app.isEnabled()) continue;
            existingDeployments.add(app);
        }
        if (!existingDeployments.isEmpty()) {
            ProjectDeployedDialog dialog = new ProjectDeployedDialog(this.getShell(), name);
            if (dialog.open() != 0) return false;
            selectedBehaviour = dialog.getSelectedBehaviour();
        } else {
            selectedBehaviour = null;
        }
        final ProjectInfo projectInfo = this.projectValidationPage.isActivePage() ? this.projectValidationPage.getProjectInfo() : null;
        final ProjectTypeInfo type = this.projectTypePage.getType();
        final ProjectTypeInfo.ProjectSubtypeInfo projectSubtype = this.projectTypePage.getSubtype();
        final String language = this.projectTypePage.getLanguage();
        Job job = new Job(NLS.bind((String)Messages.BindProjectWizardJobLabel, (Object[])new String[]{this.connection.getName(), name})){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    CodewindApplication app2;
                    final SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)140);
                    if (!BindProjectWizard.this.connection.isLocal() && ProjectType.isCodewindStyle((String)type.getId()) && !BindProjectWizard.this.connection.requestHasPushRegistry()) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (MessageDialog.openConfirm((Shell)BindProjectWizard.this.getShell(), (String)Messages.NoPushRegistryTitle, (String)Messages.NoPushRegistryMessage)) {
                                    RegistryManagementDialog.open(BindProjectWizard.this.getShell(), BindProjectWizard.this.connection, (IProgressMonitor)mon.split(40));
                                } else {
                                    mon.setCanceled(true);
                                }
                            }
                        });
                        if (mon.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        if (!BindProjectWizard.this.connection.requestHasPushRegistry()) {
                            return new Status(4, "org.eclipse.codewind.ui", Messages.NoPushRegistryError, null);
                        }
                    }
                    mon.setWorkRemaining(100);
                    if (selectedBehaviour != null) {
                        switch (selectedBehaviour) {
                            case REMOVE: {
                                mon.setTaskName(Messages.BindProjectWizardRemoveTask);
                                mon.split(10 * existingDeployments.size());
                                for (CodewindApplication app2 : existingDeployments) {
                                    try {
                                        app2.connection.requestProjectUnbind(app2.projectID);
                                    }
                                    catch (Exception e) {
                                        Logger.logError((String)("An error occurred trying to unbind the " + app2.name + " project from connection: " + app2.connection.getBaseURI()));
                                    }
                                    if (mon.isCanceled()) {
                                        return Status.CANCEL_STATUS;
                                    }
                                    mon.worked(10);
                                }
                                break;
                            }
                            case DISABLE: {
                                mon.setTaskName(Messages.BindProjectWizardDisableTask);
                                mon.split(10 * existingDeployments.size());
                                for (CodewindApplication app2 : existingDeployments) {
                                    try {
                                        app2.connection.requestProjectOpenClose(app2, false);
                                    }
                                    catch (Exception e) {
                                        Logger.logError((String)("An error occurred trying to disable the " + app2.name + " project on connection: " + app2.connection.getBaseURI()));
                                    }
                                    if (mon.isCanceled()) {
                                        return Status.CANCEL_STATUS;
                                    }
                                    mon.worked(10);
                                }
                                break;
                            }
                        }
                    }
                    mon.setWorkRemaining(50);
                    String path = BindProjectWizard.this.projectPath.toFile().getAbsolutePath();
                    if (projectInfo != null) {
                        ProjectUtil.bindProject((String)name, (String)path, (String)projectInfo.language.getId(), (String)projectInfo.type.getId(), (String)BindProjectWizard.this.connection.getConid(), (IProgressMonitor)mon.split(30));
                    } else {
                        if (projectSubtype != null) {
                            ProjectUtil.validateProject((String)name, (String)path, (String)(type + ":" + projectSubtype.id), (String)BindProjectWizard.this.connection.getConid(), (IProgressMonitor)mon.split(10));
                        }
                        mon.setWorkRemaining(40);
                        ProjectUtil.bindProject((String)name, (String)path, (String)language, (String)type.getId(), (String)BindProjectWizard.this.connection.getConid(), (IProgressMonitor)mon.split(20));
                    }
                    if (mon.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    mon.split(10);
                    BindProjectWizard.this.connection.refreshApps(null);
                    if (mon.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    mon.split(10);
                    app2 = BindProjectWizard.this.connection.getAppByName(name);
                    if (app2 != null) {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                        if (project == null || !project.exists()) {
                            ImportProjectAction.importProject(app2);
                        }
                        if (CodewindCorePlugin.getDefault().getPreferenceStore().getBoolean("autoOpenOverviewPage")) {
                            Display.getDefault().asyncExec(() -> OpenAppOverviewAction.openAppOverview(app2));
                        }
                    }
                    mon.done();
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    Logger.logError((String)("An error occured trying to add the project to Codewind: " + BindProjectWizard.this.projectPath.toOSString()), (Throwable)e);
                    return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.BindProjectWizardError, (Object)BindProjectWizard.this.projectPath.toOSString()), (Throwable)e);
                }
            }
        };
        job.schedule();
        return true;
    }

    public void setProjectInfo(ProjectInfo projectInfo) {
        if (this.projectTypePage != null) {
            this.projectTypePage.setProjectInfo(projectInfo);
        }
    }

    public void setProjectPath(IPath projectPath) {
        if (this.projectValidationPage != null) {
            this.projectValidationPage.setProjectPath(projectPath, true);
        }
    }
}

