/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.constants;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.codewind.core.internal.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProjectCapabilities {
    public static final ProjectCapabilities emptyCapabilities = new ProjectCapabilities();
    private final Set<StartMode> startModes = new HashSet<StartMode>();
    private final Set<ControlCommand> controlCommands = new HashSet<ControlCommand>();

    public ProjectCapabilities(JSONObject capabilities) {
        int i;
        try {
            if (capabilities.has("startModes")) {
                JSONArray modes = capabilities.getJSONArray("startModes");
                for (i = 0; i < modes.length(); ++i) {
                    StartMode startMode = StartMode.getStartMode(modes.getString(i));
                    if (startMode == null) continue;
                    this.startModes.add(startMode);
                }
            }
        }
        catch (JSONException e) {
            Logger.logError("Failed to parse the start mode capabilities.", e);
        }
        try {
            if (capabilities.has("controlCommands")) {
                JSONArray commands = capabilities.getJSONArray("controlCommands");
                for (i = 0; i < commands.length(); ++i) {
                    ControlCommand controlCommand = ControlCommand.getControlCommand(commands.getString(i));
                    if (controlCommand == null) continue;
                    this.controlCommands.add(controlCommand);
                }
            }
        }
        catch (JSONException e) {
            Logger.logError("Failed to parse the control command capabilities.", e);
        }
    }

    private ProjectCapabilities() {
    }

    public boolean canRestart() {
        return this.controlCommands.contains((Object)ControlCommand.RESTART);
    }

    public boolean supportsDebugMode() {
        return this.startModes.contains((Object)StartMode.DEBUG);
    }

    public boolean supportsDebugNoInitMode() {
        return this.startModes.contains((Object)StartMode.DEBUG_NO_INIT);
    }

    public static enum ControlCommand {
        RESTART("restart");

        private final String name;

        private ControlCommand(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static ControlCommand getControlCommand(String name) {
            for (ControlCommand command : ControlCommand.values()) {
                if (!command.name.equals(name)) continue;
                return command;
            }
            return null;
        }
    }

    public static enum StartMode {
        RUN("run"),
        DEBUG("debug"),
        DEBUG_NO_INIT("debugNoInit");

        private final String name;

        private StartMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static StartMode getStartMode(String name) {
            for (StartMode mode : StartMode.values()) {
                if (!mode.name.equals(name)) continue;
                return mode;
            }
            return null;
        }
    }
}

